/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.spi.PropagationContext;
import org.drools.util.Iterator;

public class JoinNode
extends BetaNode {
    private static final long serialVersionUID = 400L;

    public JoinNode() {
    }

    public JoinNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints binder, Behavior[] behaviors, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, binder, behaviors);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (this.tupleMemoryEnabled) {
            memory.getLeftTupleMemory().add(leftTuple);
        }
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        for (RightTuple rightTuple = memory.getRightTupleMemory().getFirst(leftTuple); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            InternalFactHandle handle = rightTuple.getFactHandle();
            if (!this.constraints.isAllowedCachedLeft(memory.getContext(), handle)) continue;
            this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, context, workingMemory, this.tupleMemoryEnabled);
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        RightTuple rightTuple = this.createRightTuple(factHandle, this);
        if (!this.behavior.assertRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory)) {
            rightTuple.unlinkFromRightParent();
            return;
        }
        memory.getRightTupleMemory().add(rightTuple);
        if (!this.tupleMemoryEnabled) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, factHandle);
        int i = 0;
        for (LeftTuple leftTuple = memory.getLeftTupleMemory().getFirst(rightTuple); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getNext()) {
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
            ++i;
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        this.behavior.retractRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory);
        memory.getRightTupleMemory().remove(rightTuple);
        if (rightTuple.getBetaChildren() != null) {
            this.sink.propagateRetractRightTuple(rightTuple, context, workingMemory);
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getLeftTupleMemory().remove(leftTuple);
        if (leftTuple.getBetaChildren() != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            for (RightTuple rightTuple = memory.getRightTupleMemory().getFirst(leftTuple); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
                if (!this.constraints.isAllowedCachedLeft(memory.getContext(), rightTuple.getFactHandle())) continue;
                sink.assertLeftTuple(new LeftTuple(leftTuple, rightTuple, sink, this.tupleMemoryEnabled), context, workingMemory);
            }
            this.constraints.resetTuple(memory.getContext());
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    public short getType() {
        return 0;
    }

    public String toString() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.source;
        }
        return "[JoinNode(" + this.getId() + ") - " + ((ObjectTypeNode)source).getObjectType() + "]";
    }
}

