/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.spi.PropagationContext;
import org.drools.util.Iterator;

public class NotNode
extends BetaNode {
    private static final long serialVersionUID = 400L;
    static int notAssertObject = 0;
    static int notAssertTuple = 0;

    public NotNode() {
    }

    public NotNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, Behavior[] behaviors, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, joinNodeBinder, behaviors);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        for (RightTuple rightTuple = memory.getRightTupleMemory().getFirst(leftTuple); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            if (!this.constraints.isAllowedCachedLeft(memory.getContext(), rightTuple.getFactHandle())) continue;
            leftTuple.setBlocker(rightTuple);
            if (!this.tupleMemoryEnabled) break;
            rightTuple.setBlocked(leftTuple);
            break;
        }
        this.constraints.resetTuple(memory.getContext());
        if (leftTuple.getBlocker() == null) {
            if (this.tupleMemoryEnabled) {
                memory.getLeftTupleMemory().add(leftTuple);
            }
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
        }
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple rightTuple = this.createRightTuple(factHandle, this);
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!this.behavior.assertRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory)) {
            rightTuple.unlinkFromRightParent();
            return;
        }
        memory.getRightTupleMemory().add(rightTuple);
        if (!this.tupleMemoryEnabled) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, factHandle);
        LeftTuple leftTuple = memory.getLeftTupleMemory().getFirst(rightTuple);
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)leftTuple.getNext();
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.setBlocked(leftTuple);
                memory.getLeftTupleMemory().remove(leftTuple);
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
            leftTuple = temp;
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple rootBlocker = (RightTuple)rightTuple.getNext();
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        this.behavior.retractRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory);
        memory.getRightTupleMemory().remove(rightTuple);
        if (rightTuple.getBlocked() == null) {
            return;
        }
        LeftTuple leftTuple = rightTuple.getBlocked();
        while (leftTuple != null) {
            LeftTuple temp = leftTuple.getBlockedNext();
            leftTuple.setBlocker(null);
            leftTuple.setBlockedPrevious(null);
            leftTuple.setBlockedNext(null);
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            for (RightTuple newBlocker = rootBlocker; newBlocker != null; newBlocker = (RightTuple)newBlocker.getNext()) {
                if (!this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) continue;
                leftTuple.setBlocker(newBlocker);
                newBlocker.setBlocked(leftTuple);
                break;
            }
            if (leftTuple.getBlocker() == null) {
                memory.getLeftTupleMemory().add(leftTuple);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
            leftTuple = temp;
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
            memory.getLeftTupleMemory().remove(leftTuple);
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        } else {
            blocker.removeBlocked(leftTuple);
        }
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            sink.assertLeftTuple(new LeftTuple(leftTuple, sink, this.tupleMemoryEnabled), context, workingMemory);
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    public short getType() {
        return 1;
    }

    public String toString() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.source;
        }
        return "[NotNode - " + ((ObjectTypeNode)source).getObjectType() + "]";
    }
}

