/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.drools.rule.CompositeClassLoader;
import org.drools.rule.DialectRuntimeData;
import org.drools.rule.Function;
import org.drools.rule.LineMappings;
import org.drools.rule.Package;
import org.drools.rule.Rule;

public class DialectRuntimeRegistry
implements Externalizable {
    private Map<String, DialectRuntimeData> dialects = new HashMap<String, DialectRuntimeData>();
    private Map lineMappings;

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.dialects);
        stream.writeObject(this.lineMappings);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.dialects = (Map)stream.readObject();
        this.lineMappings = (Map)stream.readObject();
    }

    public void onAdd(CompositeClassLoader rootClassLoader) {
        for (DialectRuntimeData data : this.dialects.values()) {
            data.onAdd(this, rootClassLoader);
        }
    }

    public void onRemove() {
        for (DialectRuntimeData data : this.dialects.values()) {
            data.onRemove();
        }
    }

    public void setDialectData(String name, DialectRuntimeData data) {
        this.dialects.put(name, data);
    }

    public DialectRuntimeData getDialectData(String dialect) {
        return this.dialects.get(dialect);
    }

    public DialectRuntimeData removeRule(Package pkg, Rule rule) {
        DialectRuntimeData dialect = this.dialects.get(rule.getDialect());
        dialect.removeRule(pkg, rule);
        return dialect;
    }

    public DialectRuntimeData removeFunction(Package pkg, Function function) {
        DialectRuntimeData dialect = this.dialects.get(function.getDialect());
        dialect.removeFunction(pkg, function);
        return dialect;
    }

    public void merge(DialectRuntimeRegistry newDatas, CompositeClassLoader rootClassLoader) {
        for (Map.Entry<String, DialectRuntimeData> entry : newDatas.dialects.entrySet()) {
            DialectRuntimeData data = this.dialects.get(entry.getKey());
            if (data == null) {
                DialectRuntimeData dialectData = entry.getValue().clone(this, rootClassLoader);
                this.dialects.put(entry.getKey(), dialectData);
                continue;
            }
            data.merge(this, entry.getValue());
        }
        this.getLineMappings().putAll(newDatas.getLineMappings());
    }

    public boolean isDirty() {
        return true;
    }

    public void onBeforeExecute() {
        DialectRuntimeData data = this.dialects.get("java");
        if (data != null) {
            data.onBeforeExecute();
        }
        for (Map.Entry<String, DialectRuntimeData> entry : this.dialects.entrySet()) {
            if ("java".equals(entry.getKey())) continue;
            entry.getValue().onBeforeExecute();
        }
    }

    public void clear() {
        this.dialects.clear();
    }

    public LineMappings getLineMappings(String className) {
        return (LineMappings)this.getLineMappings().get(className);
    }

    public Map getLineMappings() {
        if (this.lineMappings == null) {
            this.lineMappings = new HashMap();
        }
        return this.lineMappings;
    }
}

