/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance;

import java.util.HashMap;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.definition.process.NodeContainer;
import org.drools.definition.process.Process;
import org.drools.definition.process.WorkflowProcess;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.workflow.core.impl.NodeImpl;
import org.drools.workflow.instance.NodeInstance;
import org.drools.workflow.instance.NodeInstanceContainer;
import org.drools.workflow.instance.impl.NodeInstanceImpl;
import org.drools.workflow.instance.impl.WorkflowProcessInstanceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowProcessInstanceUpgrader {
    public static void upgradeProcessInstance(StatefulKnowledgeSession session, long processInstanceId, String processId, Map<String, Long> nodeMapping) {
        WorkflowProcessInstanceUpgrader.upgradeProcessInstance(((StatefulKnowledgeSessionImpl)session).session, processInstanceId, processId, nodeMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeProcessInstance(WorkingMemory workingMemory, long processInstanceId, String processId, Map<String, Long> nodeMapping) {
        WorkflowProcessInstanceImpl processInstance;
        if (nodeMapping == null) {
            nodeMapping = new HashMap<String, Long>();
        }
        if ((processInstance = (WorkflowProcessInstanceImpl)workingMemory.getProcessInstance(processInstanceId)) == null) {
            throw new IllegalArgumentException("Could not find process instance " + processInstanceId);
        }
        if (processId == null) {
            throw new IllegalArgumentException("Null process id");
        }
        WorkflowProcess process = (WorkflowProcess)((InternalRuleBase)workingMemory.getRuleBase()).getProcess(processId);
        if (process == null) {
            throw new IllegalArgumentException("Could not find process " + processId);
        }
        if (processInstance.getProcessId().equals(processId)) {
            return;
        }
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = processInstance;
        synchronized (workflowProcessInstanceImpl) {
            Process oldProcess = processInstance.getProcess();
            processInstance.disconnect();
            processInstance.setProcess(oldProcess);
            WorkflowProcessInstanceUpgrader.updateNodeInstances(processInstance, nodeMapping);
            processInstance.setWorkingMemory((InternalWorkingMemory)workingMemory);
            processInstance.setProcess((Process)process);
            processInstance.reconnect();
        }
    }

    private static void updateNodeInstances(NodeInstanceContainer nodeInstanceContainer, Map<String, Long> nodeMapping) {
        NodeContainer nodeContainer = nodeInstanceContainer.getNodeContainer();
        for (org.drools.runtime.process.NodeInstance nodeInstance : nodeInstanceContainer.getNodeInstances()) {
            String oldNodeId = ((NodeImpl)((NodeInstance)nodeInstance).getNode()).getUniqueId();
            Long newNodeId = nodeMapping.get(oldNodeId);
            if (newNodeId == null) {
                newNodeId = nodeInstance.getNodeId();
            }
            ((NodeInstanceImpl)nodeInstance).setNodeId(newNodeId);
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            WorkflowProcessInstanceUpgrader.updateNodeInstances((NodeInstanceContainer)nodeInstance, nodeMapping);
        }
    }
}

