/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.agent.AgentEventListener;
import org.drools.agent.FileScanner;
import org.drools.agent.MockListener;
import org.drools.agent.PackageProvider;
import org.drools.agent.RuleBaseAssemblerTest;
import org.drools.rule.Package;

public class FileScannerTest
extends TestCase {
    public void testHasChanged() {
        HashMap lastMod = new HashMap();
        FileScanner scan = new FileScanner();
        FileScannerTest.assertTrue((boolean)scan.hasChanged("/goo/ber", lastMod, 42L));
        FileScannerTest.assertFalse((boolean)scan.hasChanged("/goo/ber", lastMod, 42L));
        FileScannerTest.assertTrue((boolean)scan.hasChanged("/goo/baaaa", lastMod, 42L));
        FileScannerTest.assertFalse((boolean)scan.hasChanged("/goo/baaaa", lastMod, 42L));
        FileScannerTest.assertFalse((boolean)scan.hasChanged("/goo/ber", lastMod, 42L));
        FileScannerTest.assertTrue((boolean)scan.hasChanged("/goo/ber", lastMod, 400L));
        FileScannerTest.assertFalse((boolean)scan.hasChanged("/goo/baaaa", lastMod, 42L));
        FileScannerTest.assertTrue((boolean)scan.hasChanged("/goo/baaaa", lastMod, 69L));
    }

    public void testScanAndLoad() throws Exception {
        Package p1 = new Package("p1");
        Package p2 = new Package("p2");
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        File p1f = new File(dir, "p1.pkg");
        File p2f = new File(dir, "p2.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        FileScanner scan = new FileScanner();
        Properties props = new Properties();
        props.setProperty("file", String.valueOf(p1f.getPath()) + " " + p2f.getPath());
        scan.configure(props);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)new MockListener());
        FileScannerTest.assertEquals((int)2, (int)rb.getPackages().length);
        FileScannerTest.assertTrue(("p1".equals(rb.getPackages()[0].getName()) || "p1".equals(rb.getPackages()[1].getName()) ? 1 : 0) != 0);
        FileScannerTest.assertTrue(("p2".equals(rb.getPackages()[0].getName()) || "p2".equals(rb.getPackages()[1].getName()) ? 1 : 0) != 0);
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)new MockListener());
        FileScannerTest.assertEquals((int)2, (int)rb.getPackages().length);
        FileScannerTest.assertTrue(("p1".equals(rb.getPackages()[0].getName()) || "p1".equals(rb.getPackages()[1].getName()) ? 1 : 0) != 0);
        FileScannerTest.assertTrue(("p2".equals(rb.getPackages()[0].getName()) || "p2".equals(rb.getPackages()[1].getName()) ? 1 : 0) != 0);
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)new MockListener());
        FileScannerTest.assertEquals((int)2, (int)rb.getPackages().length);
        FileScannerTest.assertTrue(("p1".equals(rb.getPackages()[0].getName()) || "p1".equals(rb.getPackages()[1].getName()) ? 1 : 0) != 0);
        FileScannerTest.assertTrue(("p2".equals(rb.getPackages()[0].getName()) || "p2".equals(rb.getPackages()[1].getName()) ? 1 : 0) != 0);
    }

    public void testEmptyList() throws Exception {
        FileScanner scan = new FileScanner();
        RuleBase rb = RuleBaseFactory.newRuleBase();
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)new MockListener());
        FileScannerTest.assertEquals((int)0, (int)rb.getPackages().length);
    }

    public void testFileChanges() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        File t = new File(dir, "x.bar");
        Package x = new Package("x");
        RuleBaseAssemblerTest.writePackage(x, t);
        FileScanner scan = new FileScanner();
        HashMap updates = new HashMap();
        FileScannerTest.assertTrue((boolean)scan.hasChanged("x", updates, t.lastModified()));
        FileScannerTest.assertFalse((boolean)scan.hasChanged("x", updates, t.lastModified()));
    }
}

