/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.definition.KnowledgePackage;
import org.drools.rule.Package;

public class RuleBaseAssemblerTest
extends TestCase {
    public void testAssemblePackages() throws Exception {
        RuleBase rb = RuleBaseFactory.newRuleBase();
        Package pkg = new Package("goober");
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        rb.addPackage(pkg);
        Package p1 = new Package("p1");
        p1.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        File f = RuleBaseAssemblerTest.getTempDirectory();
        File p1file = new File(f, "p1.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1file);
        Package p1_ = RuleBaseAssemblerTest.readPackage(p1file);
        rb = RuleBaseFactory.newRuleBase();
        rb.addPackage(p1_);
    }

    public static Package readPackage(File p1file) throws IOException, FileNotFoundException, ClassNotFoundException {
        return (Package)DroolsStreamUtils.streamIn((InputStream)new FileInputStream(p1file));
    }

    public static void writePackage(Package pkg, File p1file) throws IOException, FileNotFoundException {
        FileOutputStream out = new FileOutputStream(p1file);
        try {
            DroolsStreamUtils.streamOut((OutputStream)out, (Object)pkg);
        }
        finally {
            out.close();
        }
    }

    public static void writePackage(KnowledgePackage kpackage, File p1file) throws IOException, FileNotFoundException {
        FileOutputStream out = new FileOutputStream(p1file);
        try {
            DroolsStreamUtils.streamOut((OutputStream)out, (Object)kpackage);
        }
        finally {
            out.close();
        }
    }

    public static File getTempDirectory() {
        File f = RuleBaseAssemblerTest.tempDir();
        if (f.exists()) {
            if (f.isFile()) {
                throw new IllegalStateException("The temp directory exists as a file. Nuke it now !");
            }
            RuleBaseAssemblerTest.deleteDir(f);
            f.mkdir();
        } else {
            f.mkdir();
        }
        return f;
    }

    private static File tempDir() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        return new File(tmp, "__temp_test_drools_packages");
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            String[] stringArray = children = dir.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                File file = new File(dir, child);
                boolean success = RuleBaseAssemblerTest.deleteDir(file);
                if (!success) {
                    System.gc();
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("This should never happen");
                    }
                    success = RuleBaseAssemblerTest.deleteDir(file);
                    if (!success) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return dir.delete();
    }

    public static void clearTempDirectory() {
        RuleBaseAssemblerTest.deleteDir(RuleBaseAssemblerTest.tempDir());
    }

    public static Test suite() {
        return new TestSuite(RuleBaseAssemblerTest.class);
    }

    public static void main(String[] args) {
        RuleBaseAssemblerTest.suite();
    }
}

