/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldAccessor;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ConcreteChild;
import org.drools.util.asm.BeanInherit;
import org.drools.util.asm.InterfaceChild;
import org.drools.util.asm.TestAbstract;
import org.drools.util.asm.TestAbstractImpl;
import org.drools.util.asm.TestBean;
import org.drools.util.asm.TestInterface;
import org.drools.util.asm.TestInterfaceImpl;

public class ClassFieldAccessorTest
extends TestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    protected void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    public void testBasic() throws Exception {
        Object[] objArray = new Object[1];
        TestBean obj = new TestBean();
        obj.setBlah(false);
        obj.setSomething("no");
        obj.setObjArray(objArray);
        ClassFieldReader ext = this.store.getReader(TestBean.class, "blah", ((Object)((Object)this)).getClass().getClassLoader());
        ClassFieldAccessorTest.assertEquals((boolean)false, (boolean)((Boolean)ext.getValue(null, (Object)obj)));
        ClassFieldReader ext2 = this.store.getReader(TestBean.class, "fooBar", ((Object)((Object)this)).getClass().getClassLoader());
        ClassFieldAccessorTest.assertEquals((Object)"fooBar", (Object)ext2.getValue(null, (Object)obj));
        ClassFieldReader ext3 = this.store.getReader(TestBean.class, "objArray", ((Object)((Object)this)).getClass().getClassLoader());
        ClassFieldAccessorTest.assertEquals((Object)objArray, (Object)ext3.getValue(null, (Object)obj));
    }

    public void testInterface() throws Exception {
        TestInterfaceImpl obj = new TestInterfaceImpl();
        ClassFieldReader ext = this.store.getReader(TestInterface.class, "something", ((Object)((Object)this)).getClass().getClassLoader());
        ClassFieldAccessorTest.assertEquals((String)"foo", (String)((String)ext.getValue(null, (Object)obj)));
    }

    public void testAbstract() throws Exception {
        ClassFieldReader ext = this.store.getReader(TestAbstract.class, "something", ((Object)((Object)this)).getClass().getClassLoader());
        TestAbstractImpl obj = new TestAbstractImpl();
        ClassFieldAccessorTest.assertEquals((String)"foo", (String)((String)ext.getValue(null, (Object)obj)));
    }

    public void testInherited() throws Exception {
        ClassFieldReader ext = this.store.getReader(BeanInherit.class, "text", ((Object)((Object)this)).getClass().getClassLoader());
        BeanInherit obj = new BeanInherit();
        ClassFieldAccessorTest.assertEquals((String)"hola", (String)((String)ext.getValue(null, (Object)obj)));
    }

    public void testMultipleInterfaces() throws Exception {
        ConcreteChild obj = new ConcreteChild();
        ClassFieldReader ext = this.store.getReader(InterfaceChild.class, "foo", ((Object)((Object)this)).getClass().getClassLoader());
        ClassFieldAccessorTest.assertEquals((int)42, (int)((Number)ext.getValue(null, (Object)obj)).intValue());
    }

    public void testLong() throws Exception {
        ClassFieldReader ext = this.store.getReader(TestBean.class, "longField", ((Object)((Object)this)).getClass().getClassLoader());
        TestBean bean = new TestBean();
        ClassFieldAccessorTest.assertEquals((long)424242L, (long)((Number)ext.getValue(null, (Object)bean)).longValue());
    }

    public void testNonExistentField() throws Exception {
        Object[] objArray = new Object[1];
        TestBean obj = new TestBean();
        obj.setBlah(false);
        obj.setSomething("no");
        obj.setObjArray(objArray);
        try {
            ClassFieldReader ext = this.store.getReader(TestBean.class, "xyz", ((Object)((Object)this)).getClass().getClassLoader());
            ClassFieldAccessorTest.fail((String)"A RuntimeDroolsException should have been raised");
        }
        catch (RuntimeDroolsException ext) {
        }
        catch (Exception e) {
            ClassFieldAccessorTest.fail((String)"A RuntimeDroolsException should have been raised");
        }
    }

    public void testBuildFieldAccessor() {
        try {
            ClassFieldAccessor intAccessor = this.store.getAccessor(TestClass.class, "intAttr", ((Object)((Object)this)).getClass().getClassLoader());
            ClassFieldAccessor strAccessor = this.store.getAccessor(TestClass.class, "strAttr", ((Object)((Object)this)).getClass().getClassLoader());
            String testString1 = "TestAttr1";
            String testString2 = "TestAttr2";
            TestClass instance = new TestClass();
            instance.setIntAttr(10);
            instance.setStrAttr(testString1);
            Assert.assertEquals((String)"Error reading int attr", (int)10, (int)((Integer)intAccessor.getValue((Object)instance)));
            Assert.assertEquals((String)"Error reading int attr", (int)10, (int)intAccessor.getIntValue((Object)instance));
            Assert.assertEquals((String)"Error reading String attr", (Object)testString1, (Object)strAccessor.getValue((Object)instance));
            intAccessor.setValue((Object)instance, (Object)new Integer(50));
            strAccessor.setValue((Object)instance, (Object)testString2);
            Assert.assertEquals((String)"Error setting int attr", (int)50, (int)instance.getIntAttr());
            Assert.assertEquals((String)"Error setting String attr", (String)testString2, (String)instance.getStrAttr());
            intAccessor.setIntValue((Object)instance, 40);
            Assert.assertEquals((String)"Error reading int attr", (int)40, (int)intAccessor.getIntValue((Object)instance));
            Assert.assertEquals((String)"Error reading String attr", (Object)testString2, (Object)strAccessor.getValue((Object)instance));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("No exception is supposed to be generated when creating field accessor: " + e));
        }
    }

    public void testNullOnPrimitives() {
        try {
            ClassFieldAccessor intAccessor = this.store.getAccessor(TestClass.class, "intAttr", ((Object)((Object)this)).getClass().getClassLoader());
            ClassFieldAccessor strAccessor = this.store.getAccessor(TestClass.class, "strAttr", ((Object)((Object)this)).getClass().getClassLoader());
            ClassFieldAccessor byteAccessor = this.store.getAccessor(TestClass.class, "byteAttr", ((Object)((Object)this)).getClass().getClassLoader());
            ClassFieldAccessor booleanAccessor = this.store.getAccessor(TestClass.class, "booleanAttr", ((Object)((Object)this)).getClass().getClassLoader());
            ClassFieldAccessor charAccessor = this.store.getAccessor(TestClass.class, "charAttr", ((Object)((Object)this)).getClass().getClassLoader());
            ClassFieldAccessor doubleAccessor = this.store.getAccessor(TestClass.class, "doubleAttr", ((Object)((Object)this)).getClass().getClassLoader());
            ClassFieldAccessor floatAccessor = this.store.getAccessor(TestClass.class, "floatAttr", ((Object)((Object)this)).getClass().getClassLoader());
            ClassFieldAccessor longAccessor = this.store.getAccessor(TestClass.class, "longAttr", ((Object)((Object)this)).getClass().getClassLoader());
            ClassFieldAccessor shortAccessor = this.store.getAccessor(TestClass.class, "shortAttr", ((Object)((Object)this)).getClass().getClassLoader());
            String testString1 = "TestAttr1";
            TestClass instance = new TestClass();
            instance.setIntAttr(25);
            instance.setStrAttr(testString1);
            instance.setByteAttr((byte)10);
            instance.setBooleanAttr(true);
            instance.setCharAttr('x');
            instance.setDoubleAttr(10.5);
            instance.setFloatAttr(40.3f);
            instance.setLongAttr(43L);
            instance.setShortAttr((short)20);
            intAccessor.setValue((Object)instance, null);
            strAccessor.setValue((Object)instance, null);
            byteAccessor.setValue((Object)instance, null);
            booleanAccessor.setValue((Object)instance, null);
            charAccessor.setValue((Object)instance, null);
            doubleAccessor.setValue((Object)instance, null);
            floatAccessor.setValue((Object)instance, null);
            longAccessor.setValue((Object)instance, null);
            shortAccessor.setValue((Object)instance, null);
            Assert.assertEquals((String)"Error setting attr", (int)0, (int)instance.getIntAttr());
            Assert.assertNull((String)"Error setting attr", (Object)instance.getStrAttr());
            Assert.assertEquals((String)"Error setting attr", (int)0, (int)instance.getByteAttr());
            Assert.assertEquals((String)"Error setting attr", (boolean)false, (boolean)instance.isBooleanAttr());
            Assert.assertEquals((String)"Error setting attr", (char)'\u0000', (char)instance.getCharAttr());
            Assert.assertEquals((String)"Error setting attr", (double)0.0, (double)instance.getDoubleAttr(), (double)0.1);
            Assert.assertEquals((String)"Error setting attr", (float)0.0f, (float)instance.getFloatAttr(), (float)0.1f);
            Assert.assertEquals((String)"Error setting attr", (long)0L, (long)instance.getLongAttr());
            Assert.assertEquals((String)"Error setting attr", (short)0, (short)instance.getShortAttr());
            Assert.assertEquals((String)"Error reading int attr", (int)0, (int)((Integer)intAccessor.getValue((Object)instance)));
            Assert.assertNull((String)"Error reading String attr", (Object)strAccessor.getValue((Object)instance));
            Assert.assertEquals((String)"Error reading attr", (int)0, (int)((Byte)byteAccessor.getValue((Object)instance)).byteValue());
            Assert.assertEquals((String)"Error reading attr", (boolean)false, (boolean)((Boolean)booleanAccessor.getValue((Object)instance)));
            Assert.assertEquals((String)"Error reading attr", (char)'\u0000', (char)((Character)charAccessor.getValue((Object)instance)).charValue());
            Assert.assertEquals((String)"Error reading attr", (double)0.0, (double)((Double)doubleAccessor.getValue((Object)instance)), (double)0.1);
            Assert.assertEquals((String)"Error reading attr", (float)0.0f, (float)((Float)floatAccessor.getValue((Object)instance)).floatValue(), (float)0.1f);
            Assert.assertEquals((String)"Error reading attr", (long)0L, (long)((Long)longAccessor.getValue((Object)instance)));
            Assert.assertEquals((String)"Error reading attr", (short)0, (short)((Short)shortAccessor.getValue((Object)instance)));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("No exception is supposed to be generated when creating field accessor: " + e));
        }
    }

    public static class TestClass {
        private int intAttr;
        private String strAttr;
        private byte byteAttr;
        private boolean booleanAttr;
        private char charAttr;
        private double doubleAttr;
        private float floatAttr;
        private long longAttr;
        private short shortAttr;

        public int getIntAttr() {
            return this.intAttr;
        }

        public void setIntAttr(int intAttr) {
            this.intAttr = intAttr;
        }

        public String getStrAttr() {
            return this.strAttr;
        }

        public void setStrAttr(String strAttr) {
            this.strAttr = strAttr;
        }

        public boolean isBooleanAttr() {
            return this.booleanAttr;
        }

        public void setBooleanAttr(boolean booleanAttr) {
            this.booleanAttr = booleanAttr;
        }

        public byte getByteAttr() {
            return this.byteAttr;
        }

        public void setByteAttr(byte byteAttr) {
            this.byteAttr = byteAttr;
        }

        public char getCharAttr() {
            return this.charAttr;
        }

        public void setCharAttr(char charAttr) {
            this.charAttr = charAttr;
        }

        public double getDoubleAttr() {
            return this.doubleAttr;
        }

        public void setDoubleAttr(double doubleAttr) {
            this.doubleAttr = doubleAttr;
        }

        public float getFloatAttr() {
            return this.floatAttr;
        }

        public void setFloatAttr(float floatAttr) {
            this.floatAttr = floatAttr;
        }

        public long getLongAttr() {
            return this.longAttr;
        }

        public void setLongAttr(long longAttr) {
            this.longAttr = longAttr;
        }

        public short getShortAttr() {
            return this.shortAttr;
        }

        public void setShortAttr(short shortAttr) {
            this.shortAttr = shortAttr;
        }
    }
}

