/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Address;
import org.drools.Person;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.spi.InternalReadAccessor;

public class MVELClassFieldExtractorTest
extends TestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    InternalReadAccessor extractor;
    private final Person[] person = new Person[2];
    private final Address[] business = new Address[2];
    private final Address[] home = new Address[2];

    protected void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.extractor = this.store.getReader(Person.class, "addresses['home'].street", ((Object)((Object)this)).getClass().getClassLoader());
        this.person[0] = new Person("bob", 30);
        this.business[0] = new Address("Business Street", "999", null);
        this.home[0] = new Address("Home Street", "555", "55555555");
        this.person[0].getAddresses().put("business", this.business[0]);
        this.person[0].getAddresses().put("home", this.home[0]);
        this.person[1] = new Person("mark", 35);
        this.business[1] = new Address("Another Business Street", "999", null);
        this.home[1] = new Address("Another Home Street", "555", "55555555");
        this.person[1].getAddresses().put("business", this.business[1]);
        this.person[1].getAddresses().put("home", this.home[1]);
    }

    public void testGetBooleanValue() {
        try {
            this.extractor.getBooleanValue(null, (Object)this.person[0]);
            MVELClassFieldExtractorTest.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetByteValue() {
        try {
            this.extractor.getByteValue(null, (Object)this.person[0]);
            MVELClassFieldExtractorTest.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetCharValue() {
        try {
            this.extractor.getCharValue(null, (Object)this.person[0]);
            MVELClassFieldExtractorTest.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetDoubleValue() {
        try {
            this.extractor.getDoubleValue(null, (Object)this.person[0]);
            MVELClassFieldExtractorTest.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetFloatValue() {
        try {
            this.extractor.getFloatValue(null, (Object)this.person[0]);
            MVELClassFieldExtractorTest.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetIntValue() {
        try {
            this.extractor.getIntValue(null, (Object)this.person[0]);
            MVELClassFieldExtractorTest.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetLongValue() {
        try {
            this.extractor.getLongValue(null, (Object)this.person[0]);
            MVELClassFieldExtractorTest.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetShortValue() {
        try {
            this.extractor.getShortValue(null, (Object)this.person[0]);
            MVELClassFieldExtractorTest.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetValue() {
        try {
            Assert.assertEquals((Object)this.home[0].getStreet(), (Object)this.extractor.getValue(null, (Object)this.person[0]));
            Assert.assertTrue((boolean)(this.extractor.getValue(null, (Object)this.person[0]) instanceof String));
        }
        catch (Exception e) {
            MVELClassFieldExtractorTest.fail((String)"Should not throw an exception");
        }
    }

    public void testIsNullValue() {
        try {
            Assert.assertFalse((boolean)this.extractor.isNullValue(null, (Object)this.person[0]));
            ClassFieldReader nullExtractor = this.store.getReader(Person.class, "addresses['business'].phone", ((Object)((Object)this)).getClass().getClassLoader());
            Assert.assertTrue((boolean)nullExtractor.isNullValue(null, (Object)this.person[0]));
        }
        catch (Exception e) {
            MVELClassFieldExtractorTest.fail((String)"Should not throw an exception");
        }
    }

    public void testMultithreads() {
        int THREAD_COUNT = 30;
        try {
            final Vector errors = new Vector();
            Thread[] t = new Thread[30];
            int j = 0;
            while (j < 10) {
                int i = 0;
                while (i < t.length) {
                    final int ID = i;
                    t[i] = new Thread(){

                        public void run() {
                            try {
                                int ITERATIONS = 300;
                                int k = 0;
                                while (k < 300) {
                                    String value = (String)MVELClassFieldExtractorTest.this.extractor.getValue(null, (Object)MVELClassFieldExtractorTest.this.person[ID % 2]);
                                    if (!MVELClassFieldExtractorTest.this.home[ID % 2].getStreet().equals(value)) {
                                        errors.add("THREAD(" + ID + "): Wrong value at iteration " + k + ". Value='" + value + "'\n");
                                    }
                                    ++k;
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                errors.add(ex);
                            }
                        }
                    };
                    t[i].start();
                    ++i;
                }
                i = 0;
                while (i < t.length) {
                    t[i].join();
                    ++i;
                }
                ++j;
            }
            if (!errors.isEmpty()) {
                System.out.println(errors.toString());
                MVELClassFieldExtractorTest.fail((String)" Errors occured during execution ");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            MVELClassFieldExtractorTest.fail((String)("Unexpected exception running test: " + e.getMessage()));
        }
    }
}

