/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.RuleBaseConfiguration;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.evaluators.ComparableEvaluatorsDefinition;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.base.evaluators.MatchesEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.SetEvaluatorsDefinition;
import org.drools.base.evaluators.SoundslikeEvaluatorsDefinition;
import org.drools.common.BetaConstraints;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.LeftTupleIndexHashTable;
import org.drools.core.util.LeftTupleList;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.RightTupleIndexHashTable;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.BetaMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Evaluator;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;

public abstract class BaseBetaConstraintsTest
extends TestCase {
    public static EvaluatorRegistry registry = new EvaluatorRegistry();

    static {
        registry.addEvaluatorDefinition((EvaluatorDefinition)new EqualityEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new ComparableEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new SetEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new MatchesEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new SoundslikeEvaluatorsDefinition());
    }

    protected BetaNodeFieldConstraint getConstraint(String identifier, Operator operator, String fieldName, Class clazz) {
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        ClassFieldReader extractor = store.getReader(clazz, fieldName, ((Object)((Object)this)).getClass().getClassLoader());
        Declaration declaration = new Declaration(identifier, (InternalReadAccessor)extractor, new Pattern(0, (ObjectType)new ClassObjectType(clazz)));
        Evaluator evaluator = registry.getEvaluatorDefinition(operator.getOperatorString()).getEvaluator(extractor.getValueType(), operator.getOperatorString(), operator.isNegated(), null);
        return new VariableConstraint((InternalReadAccessor)extractor, declaration, evaluator);
    }

    protected void checkBetaConstraints(VariableConstraint[] constraints, Class cls) {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        int depth = config.getCompositeKeyDepth();
        BetaConstraints betaConstraints = null;
        try {
            betaConstraints = (BetaConstraints)cls.getConstructor(BetaNodeFieldConstraint[].class, RuleBaseConfiguration.class).newInstance(constraints, config);
        }
        catch (Exception e) {
            throw new RuntimeException("could not invoke constructor for " + cls.getName());
        }
        constraints = this.convertToConstraints(betaConstraints.getConstraints());
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < constraints.length && list.size() < depth) {
            if (constraints[i].getEvaluator().getOperator() == Operator.EQUAL) {
                list.add(new Integer(i));
            }
            ++i;
        }
        int[] indexedPositions = new int[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            indexedPositions[i2] = i2;
            ++i2;
        }
        BaseBetaConstraintsTest.assertEquals((indexedPositions.length > 0 ? 1 : 0) != 0, (boolean)betaConstraints.isIndexed());
        BaseBetaConstraintsTest.assertEquals((int)indexedPositions.length, (int)betaConstraints.getIndexCount());
        BetaMemory betaMemory = betaConstraints.createBetaMemory(config);
        if (indexedPositions.length > 0) {
            LeftTupleIndexHashTable tupleHashTable = (LeftTupleIndexHashTable)betaMemory.getLeftTupleMemory();
            BaseBetaConstraintsTest.assertTrue((boolean)tupleHashTable.isIndexed());
            AbstractHashTable.Index index = tupleHashTable.getIndex();
            int i3 = 0;
            while (i3 < indexedPositions.length) {
                this.checkSameConstraintForIndex(constraints[indexedPositions[i3]], index.getFieldIndex(i3));
                ++i3;
            }
            RightTupleIndexHashTable factHashTable = (RightTupleIndexHashTable)betaMemory.getRightTupleMemory();
            BaseBetaConstraintsTest.assertTrue((boolean)factHashTable.isIndexed());
            index = factHashTable.getIndex();
            int i4 = 0;
            while (i4 < indexedPositions.length) {
                this.checkSameConstraintForIndex(constraints[indexedPositions[i4]], index.getFieldIndex(i4));
                ++i4;
            }
        } else {
            LeftTupleList tupleHashTable = (LeftTupleList)betaMemory.getLeftTupleMemory();
            BaseBetaConstraintsTest.assertFalse((boolean)tupleHashTable.isIndexed());
            RightTupleList factHashTable = (RightTupleList)betaMemory.getRightTupleMemory();
            BaseBetaConstraintsTest.assertFalse((boolean)factHashTable.isIndexed());
        }
    }

    protected void checkSameConstraintForIndex(VariableConstraint constraint, AbstractHashTable.FieldIndex fieldIndex) {
        BaseBetaConstraintsTest.assertSame((Object)constraint.getRequiredDeclarations()[0], (Object)fieldIndex.getDeclaration());
        BaseBetaConstraintsTest.assertSame((Object)constraint.getEvaluator(), (Object)fieldIndex.getEvaluator());
        BaseBetaConstraintsTest.assertSame((Object)constraint.getFieldExtractor(), (Object)fieldIndex.getExtractor());
    }

    protected VariableConstraint[] convertToConstraints(LinkedList list) {
        VariableConstraint[] array = new VariableConstraint[list.size()];
        int i = 0;
        LinkedListEntry entry = (LinkedListEntry)list.getFirst();
        while (entry != null) {
            array[i++] = (VariableConstraint)entry.getObject();
            entry = (LinkedListEntry)entry.getNext();
        }
        return array;
    }
}

