/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event.process;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.WorkingMemory;
import org.drools.definition.process.Node;
import org.drools.definition.process.Process;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.event.process.ProcessCompletedEvent;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.process.ProcessNodeLeftEvent;
import org.drools.event.process.ProcessNodeTriggeredEvent;
import org.drools.event.process.ProcessStartedEvent;
import org.drools.rule.Package;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.spi.Action;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ProcessContext;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.ConnectionImpl;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.EndNode;
import org.drools.workflow.core.node.StartNode;

public class ProcessEventSupportTest
extends TestCase {
    public void testProcessEventListener() throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Package pkg = new Package("org.drools.test");
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory, ProcessContext context) throws Exception {
                System.out.println("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(2L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        pkg.addProcess((Process)process);
        ArrayList<KnowledgePackageImp> pkgs = new ArrayList<KnowledgePackageImp>();
        pkgs.add(new KnowledgePackageImp(pkg));
        kbase.addKnowledgePackages(pkgs);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        final ArrayList processEventList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }
        };
        session.addEventListener(processEventListener);
        session.startProcess("org.drools.process.event");
        ProcessEventSupportTest.assertEquals((int)16, (int)processEventList.size());
        ProcessEventSupportTest.assertEquals((String)"org.drools.process.event", (String)((ProcessStartedEvent)processEventList.get(0)).getProcessInstance().getProcessId());
        ProcessEventSupportTest.assertEquals((String)"Start", (String)((ProcessNodeTriggeredEvent)processEventList.get(1)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"Start", (String)((ProcessNodeLeftEvent)processEventList.get(2)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"Print", (String)((ProcessNodeTriggeredEvent)processEventList.get(3)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"Print", (String)((ProcessNodeLeftEvent)processEventList.get(4)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"End", (String)((ProcessNodeTriggeredEvent)processEventList.get(5)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"End", (String)((ProcessNodeLeftEvent)processEventList.get(6)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"org.drools.process.event", (String)((ProcessCompletedEvent)processEventList.get(7)).getProcessInstance().getProcessId());
        ProcessEventSupportTest.assertEquals((String)"org.drools.process.event", (String)((ProcessCompletedEvent)processEventList.get(8)).getProcessInstance().getProcessId());
        ProcessEventSupportTest.assertEquals((String)"End", (String)((ProcessNodeLeftEvent)processEventList.get(9)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"End", (String)((ProcessNodeTriggeredEvent)processEventList.get(10)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"Print", (String)((ProcessNodeLeftEvent)processEventList.get(11)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"Print", (String)((ProcessNodeTriggeredEvent)processEventList.get(12)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"Start", (String)((ProcessNodeLeftEvent)processEventList.get(13)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"Start", (String)((ProcessNodeTriggeredEvent)processEventList.get(14)).getNodeInstance().getNodeName());
        ProcessEventSupportTest.assertEquals((String)"org.drools.process.event", (String)((ProcessStartedEvent)processEventList.get(15)).getProcessInstance().getProcessId());
    }
}

