/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.DroolsTestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.SalienceInteger;
import org.drools.common.ArrayAgendaGroup;
import org.drools.common.BinaryHeapQueueAgendaGroup;
import org.drools.common.DefaultAgenda;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.DefaultAgendaEventListener;
import org.drools.event.rule.ActivationCancelledCause;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AgendaGroup;
import org.drools.spi.Consequence;
import org.drools.spi.ConsequenceException;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleFlowGroup;
import org.drools.spi.Salience;
import org.drools.time.impl.DurationTimer;
import org.drools.time.impl.Timer;

public class AgendaTest
extends DroolsTestCase {
    private InternalRuleBase ruleBase;
    private BuildContext buildContext;

    protected void setUp() throws Exception {
        this.ruleBase = (InternalRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext(this.ruleBase, ((ReteooRuleBase)this.ruleBase).getReteooBuilder().getIdGenerator());
    }

    public void testClearAgenda() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Rule rule1 = new Rule("test-rule1");
        Rule rule2 = new Rule("test-rule2");
        RuleTerminalNode node1 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), this.buildContext);
        RuleTerminalNode node2 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule2, rule2.getLhs(), this.buildContext);
        LeftTuple tuple = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, null);
        rule1.setConsequence(new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        rule2.setConsequence(new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        rule1.setNoLoop(false);
        rule2.setTimer((Timer)new DurationTimer(5000L));
        node1.assertLeftTuple(tuple, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        node2.assertLeftTuple(tuple, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)1, (int)agenda.getScheduledActivations().length);
        agenda.clearAndCancel();
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)0, (int)agenda.getScheduledActivations().length);
    }

    public void testFilters() throws Exception {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        final Boolean[] filtered = new Boolean[]{false};
        workingMemory.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
                if (event.getCause() == ActivationCancelledCause.FILTER) {
                    filtered[0] = true;
                }
            }
        });
        Rule rule = new Rule("test-rule");
        RuleTerminalNode node = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), this.buildContext);
        final HashMap results = new HashMap();
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                results.put("fired", new Boolean(true));
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        LeftTuple tuple = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, null);
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        AgendaFilter filterTrue = new AgendaFilter(){

            public boolean accept(Activation item) {
                return true;
            }
        };
        rule.setNoLoop(false);
        node.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        agenda.fireNextItem(filterTrue);
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((Object)new Boolean(true), results.get("fired"));
        AgendaTest.assertEquals((boolean)false, (boolean)filtered[0]);
        agenda.clearAndCancel();
        results.clear();
        AgendaFilter filterFalse = new AgendaFilter(){

            public boolean accept(Activation item) {
                return false;
            }
        };
        rule.setNoLoop(false);
        node.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        agenda.fireNextItem(filterFalse);
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        AgendaTest.assertNull(results.get("fired"));
        AgendaTest.assertEquals((boolean)true, (boolean)filtered[0]);
    }

    public void testFocusStack() throws ConsequenceException {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        LeftTuple tuple = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule0 = new Rule("test-rule0");
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), this.buildContext);
        rule0.setConsequence(consequence);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        Rule rule1 = new Rule("test-rule1", "agendaGroup1");
        RuleTerminalNode node1 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule1, rule1.getLhs(), this.buildContext);
        rule1.setConsequence(consequence);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, null);
        Rule rule2 = new Rule("test-rule2", "agendaGroup2");
        RuleTerminalNode node2 = new RuleTerminalNode(7, (LeftTupleSource)new MockTupleSource(6), rule2, rule2.getLhs(), this.buildContext);
        rule2.setConsequence(consequence);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule2, null, null);
        Rule rule3 = new Rule("test-rule3", "agendaGroup3");
        RuleTerminalNode node3 = new RuleTerminalNode(9, (LeftTupleSource)new MockTupleSource(8), rule3, rule3.getLhs(), this.buildContext);
        rule3.setConsequence(consequence);
        PropagationContextImpl context3 = new PropagationContextImpl(0L, 0, rule3, null, null);
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        BinaryHeapQueueAgendaGroup agendaGroup1 = new BinaryHeapQueueAgendaGroup("agendaGroup1", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup1);
        BinaryHeapQueueAgendaGroup agendaGroup2 = new BinaryHeapQueueAgendaGroup("agendaGroup2", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup2);
        BinaryHeapQueueAgendaGroup agendaGroup3 = new BinaryHeapQueueAgendaGroup("agendaGroup3", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup3);
        AgendaTest.assertEquals((int)0, (int)agenda.focusStackSize());
        node0.assertLeftTuple(tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        AgendaGroup main = agenda.getAgendaGroup("MAIN");
        AgendaTest.assertEquals((Object)agenda.getFocus(), (Object)main);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        node2.assertLeftTuple(tuple, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)1, (int)agendaGroup2.size());
        AgendaTest.assertEquals((int)2, (int)agenda.agendaSize());
        node2.assertLeftTuple(tuple, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)2, (int)agendaGroup2.size());
        AgendaTest.assertEquals((int)3, (int)agenda.agendaSize());
        agenda.setFocus("agendaGroup1");
        agenda.setFocus("agendaGroup2");
        agenda.setFocus("agendaGroup3");
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        node3.assertLeftTuple(tuple, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        node3.assertLeftTuple(tuple, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)2, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)5, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((Object)agenda.getFocus(), (Object)agendaGroup3);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)4, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((Object)agenda.getFocus(), (Object)agendaGroup3);
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)3, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((Object)agendaGroup2, (Object)agenda.getFocus());
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)2, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((Object)agenda.getFocus(), (Object)agendaGroup2);
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)1, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((Object)agenda.getFocus(), (Object)main);
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
    }

    public void testAutoFocus() throws ConsequenceException {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        BinaryHeapQueueAgendaGroup agendaGroup = new BinaryHeapQueueAgendaGroup("agendaGroup", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup);
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        LeftTuple tuple = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule = new Rule("test-rule", "agendaGroup");
        RuleTerminalNode node = new RuleTerminalNode(2, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), this.buildContext);
        rule.setConsequence(consequence);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, null);
        rule.setAutoFocus(false);
        node.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agendaGroup.size());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)1, (int)agendaGroup.size());
        agenda.clearAndCancel();
        AgendaTest.assertEquals((int)0, (int)agendaGroup.size());
        rule.setAutoFocus(true);
        node.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agendaGroup.size());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)0, (int)agendaGroup.size());
    }

    public void testAgendaGroupLockOnActive() {
        InternalRuleBase ruleBase = (InternalRuleBase)RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        BinaryHeapQueueAgendaGroup agendaGroup = new BinaryHeapQueueAgendaGroup("agendaGroup", ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup);
        LeftTuple tuple = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule = new Rule("test-rule", "agendaGroup");
        RuleTerminalNode node = new RuleTerminalNode(2, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), this.buildContext);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, null);
        rule.setLockOnActive(true);
        agendaGroup.setActive(true);
        node.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)0, (int)agendaGroup.size());
        rule.setLockOnActive(false);
        node.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agendaGroup.size());
        rule.setLockOnActive(true);
        agendaGroup.setActive(false);
        node.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)2, (int)agendaGroup.size());
    }

    public void testActivationGroup() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        final ArrayList list = new ArrayList();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                list.add(knowledgeHelper.getRule());
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        LeftTuple tuple = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule0 = new Rule("test-rule0");
        rule0.setActivationGroup("activation-group-0");
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), this.buildContext);
        rule0.setConsequence(consequence);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        Rule rule1 = new Rule("test-rule1");
        rule1.setActivationGroup("activation-group-0");
        RuleTerminalNode node1 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule1, rule1.getLhs(), this.buildContext);
        rule1.setConsequence(consequence);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, null);
        Rule rule2 = new Rule("test-rule2");
        rule2.setSalience((Salience)new SalienceInteger(-5));
        RuleTerminalNode node2 = new RuleTerminalNode(7, (LeftTupleSource)new MockTupleSource(6), rule2, rule2.getLhs(), this.buildContext);
        rule2.setConsequence(consequence);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule2, null, null);
        Rule rule3 = new Rule("test-rule3", "agendaGroup3");
        rule3.setSalience((Salience)new SalienceInteger(-10));
        rule3.setActivationGroup("activation-group-3");
        RuleTerminalNode node3 = new RuleTerminalNode(9, (LeftTupleSource)new MockTupleSource(8), rule3, rule3.getLhs(), this.buildContext);
        rule3.setConsequence(consequence);
        PropagationContextImpl context3 = new PropagationContextImpl(0L, 0, rule3, null, null);
        node0.assertLeftTuple(tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        ActivationGroup activationGroup0 = agenda.getActivationGroup("activation-group-0");
        AgendaTest.assertEquals((int)1, (int)activationGroup0.size());
        node0.retractLeftTuple(tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)0, (int)activationGroup0.size());
        node0.assertLeftTuple(tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)activationGroup0.size());
        node1.assertLeftTuple(tuple, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)2, (int)activationGroup0.size());
        AgendaTest.assertEquals((int)2, (int)agenda.focusStackSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)0, (int)activationGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.focusStackSize());
        AgendaTest.assertEquals((int)1, (int)list.size());
        AgendaTest.assertSame((Object)rule1, list.get(0));
        list.clear();
        node0.assertLeftTuple(tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        node1.assertLeftTuple(tuple, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        node2.assertLeftTuple(tuple, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        node3.assertLeftTuple(tuple, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)2, (int)activationGroup0.size());
        ActivationGroup activationGroup3 = agenda.getActivationGroup("activation-group-3");
        AgendaTest.assertEquals((int)4, (int)agenda.agendaSize());
        AgendaTest.assertEquals((int)1, (int)activationGroup3.size());
        agenda.clearAndCancelAgendaGroup("agendaGroup3");
        AgendaTest.assertEquals((int)3, (int)agenda.agendaSize());
        AgendaTest.assertEquals((int)0, (int)activationGroup3.size());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)1, (int)agenda.agendaSize());
        AgendaTest.assertEquals((int)0, (int)activationGroup0.size());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        AgendaTest.assertEquals((int)2, (int)list.size());
        AgendaTest.assertEquals((Object)rule1, list.get(0));
        AgendaTest.assertEquals((Object)rule2, list.get(1));
    }

    public void testRuleFlowGroup() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        final ArrayList list = new ArrayList();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                list.add(knowledgeHelper.getRule());
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence);
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), this.buildContext);
        Rule rule1 = new Rule("test-rule1");
        rule1.setRuleFlowGroup("rule-flow-group-1");
        rule1.setConsequence(consequence);
        RuleTerminalNode node1 = new RuleTerminalNode(4, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), this.buildContext);
        Rule rule2 = new Rule("test-rule2");
        rule2.setRuleFlowGroup("rule-flow-group-2");
        rule2.setConsequence(consequence);
        rule2.setSalience((Salience)new SalienceInteger(10));
        RuleTerminalNode node2 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(2), rule2, rule2.getLhs(), this.buildContext);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        RuleFlowGroup ruleFlowGroup1 = agenda.getRuleFlowGroup("rule-flow-group-1");
        RuleFlowGroup ruleFlowGroup2 = agenda.getRuleFlowGroup("rule-flow-group-2");
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple(tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple(tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        LeftTuple tuple2 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node1.assertLeftTuple(tuple2, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        LeftTuple tuple3 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node2.assertLeftTuple(tuple3, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)2, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup1.size());
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup2.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertEquals((int)2, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)2, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)1, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-1");
        agenda.activateRuleFlowGroup("rule-flow-group-2");
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup1.size());
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup2.size());
        AgendaTest.assertEquals((int)2, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup1.size());
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup2.size());
        AgendaTest.assertEquals((int)1, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup1.size());
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup2.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
    }

    public void testRuleFlowGroup1() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence1 = new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule1 = new Rule("test-rule1");
        rule1.setRuleFlowGroup("rule-flow-group-0");
        rule1.setConsequence(consequence1);
        final RuleTerminalNode node1 = new RuleTerminalNode(4, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), this.buildContext);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule1, null, null);
        Consequence consequence0 = new Consequence((PropagationContext)context0, workingMemory){
            private static final long serialVersionUID = 400L;
            private final /* synthetic */ PropagationContext val$context0;
            private final /* synthetic */ ReteooWorkingMemory val$workingMemory;
            {
                this.val$context0 = propagationContext;
                this.val$workingMemory = reteooWorkingMemory;
            }

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
                LeftTuple tuple1 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
                node1.assertLeftTuple(tuple1, this.val$context0, (InternalWorkingMemory)this.val$workingMemory);
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple(tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)1, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)1, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
    }

    public void testRuleFlowGroup2() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence1 = new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule1 = new Rule("test-rule1");
        rule1.setRuleFlowGroup("rule-flow-group-0");
        rule1.setConsequence(consequence1);
        final RuleTerminalNode node1 = new RuleTerminalNode(4, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), this.buildContext);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule1, null, null);
        final LeftTuple tuple1 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Consequence consequence0 = new Consequence((PropagationContext)context0, workingMemory){
            private static final long serialVersionUID = 400L;
            private final /* synthetic */ PropagationContext val$context0;
            private final /* synthetic */ ReteooWorkingMemory val$workingMemory;
            {
                this.val$context0 = propagationContext;
                this.val$workingMemory = reteooWorkingMemory;
            }

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
                node1.retractLeftTuple(tuple1, this.val$context0, (InternalWorkingMemory)this.val$workingMemory);
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        rule0.setSalience((Salience)new SalienceInteger(10));
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple(tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        node1.assertLeftTuple(tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)2, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertEquals((int)2, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)2, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
    }

    public void testRuleFlowGroup3() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence0 = new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleTerminalNode node0 = new RuleTerminalNode(1, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple(tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple(tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)2, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertEquals((int)2, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)2, (int)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertEquals((int)2, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)2, (int)agenda.agendaSize());
        agenda.deactivateRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertEquals((int)2, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertEquals((int)2, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)2, (int)agenda.agendaSize());
    }

    public void testRuleFlowGroup4() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence0 = new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleTerminalNode node0 = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule0, rule0.getLhs(), this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertTrue((boolean)ruleFlowGroup0.isAutoDeactivate());
        ruleFlowGroup0.setAutoDeactivate(false);
        AgendaTest.assertFalse((boolean)ruleFlowGroup0.isAutoDeactivate());
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple(tuple0, (PropagationContext)context0, workingMemory);
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)1, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        AgendaTest.assertTrue((boolean)ruleFlowGroup0.isActive());
        ruleFlowGroup0.setAutoDeactivate(true);
        AgendaTest.assertTrue((boolean)ruleFlowGroup0.isAutoDeactivate());
        AgendaTest.assertFalse((boolean)ruleFlowGroup0.isActive());
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple(tuple1, (PropagationContext)context0, workingMemory);
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)1, (int)agenda.agendaSize());
        AgendaTest.assertTrue((boolean)ruleFlowGroup0.isActive());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        workingMemory.executeQueuedActions();
        AgendaTest.assertFalse((boolean)ruleFlowGroup0.isActive());
        LeftTuple tuple2 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node0.assertLeftTuple(tuple2, (PropagationContext)context0, workingMemory);
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
    }

    public void testRuleFlowGroup5() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence0 = new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertTrue((boolean)ruleFlowGroup0.isAutoDeactivate());
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup0.size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
        workingMemory.executeQueuedActions();
        AgendaTest.assertFalse((boolean)ruleFlowGroup0.isActive());
    }

    public void testRuleFlowGroupLockOnActive() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        RuleFlowGroupImpl ruleFlowGroup = (RuleFlowGroupImpl)agenda.getRuleFlowGroup("rule-flow-group-0");
        LeftTuple tuple = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule = new Rule("test-rule");
        rule.setRuleFlowGroup("rule-flow-group-0");
        RuleTerminalNode node = new RuleTerminalNode(2, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), this.buildContext);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, null);
        rule.setLockOnActive(true);
        ruleFlowGroup.setAutoDeactivate(false);
        ruleFlowGroup.setActive(true);
        node.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)0, (int)ruleFlowGroup.size());
        rule.setLockOnActive(false);
        node.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)ruleFlowGroup.size());
        rule.setLockOnActive(true);
        ruleFlowGroup.setActive(false);
        node.assertLeftTuple(tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)2, (int)ruleFlowGroup.size());
    }

    public void testSequentialAgenda() {
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        InternalRuleBase ruleBase = (InternalRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        LeftTuple tuple = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        Rule rule0 = new Rule("test-rule0");
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), this.buildContext);
        node0.setSequence(72);
        rule0.setConsequence(consequence);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, null);
        Rule rule1 = new Rule("test-rule1", "agendaGroup1");
        RuleTerminalNode node1 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule1, rule1.getLhs(), this.buildContext);
        node1.setSequence(10);
        rule1.setConsequence(consequence);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, null);
        Rule rule2 = new Rule("test-rule2", "agendaGroup1");
        RuleTerminalNode node2 = new RuleTerminalNode(7, (LeftTupleSource)new MockTupleSource(6), rule2, rule2.getLhs(), this.buildContext);
        node2.setSequence(7);
        rule2.setConsequence(consequence);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule2, null, null);
        Rule rule3 = new Rule("test-rule3", "agendaGroup2");
        RuleTerminalNode node3 = new RuleTerminalNode(9, (LeftTupleSource)new MockTupleSource(8), rule3, rule3.getLhs(), this.buildContext);
        node3.setSequence(0);
        rule3.setConsequence(consequence);
        PropagationContextImpl context3 = new PropagationContextImpl(0L, 0, rule3, null, null);
        ruleBase.getAgendaGroupRuleTotals().put("MAIN", new Integer(100));
        ruleBase.getAgendaGroupRuleTotals().put("agendaGroup1", new Integer(10));
        ruleBase.getAgendaGroupRuleTotals().put("agendaGroup2", new Integer(1));
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(0, ruleBase);
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        ArrayAgendaGroup agendaGroup1 = new ArrayAgendaGroup("agendaGroup1", ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup1);
        ArrayAgendaGroup agendaGroup2 = new ArrayAgendaGroup("agendaGroup2", ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup2);
        AgendaTest.assertEquals((int)0, (int)agenda.focusStackSize());
        node0.assertLeftTuple(tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        AgendaGroup main = agenda.getAgendaGroup("MAIN");
        AgendaTest.assertEquals((Object)agenda.getFocus(), (Object)main);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        node2.assertLeftTuple(tuple, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)1, (int)agendaGroup1.size());
        AgendaTest.assertEquals((int)2, (int)agenda.agendaSize());
        node2.assertLeftTuple(tuple, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)2, (int)agendaGroup1.size());
        AgendaTest.assertEquals((int)3, (int)agenda.agendaSize());
        agenda.setFocus("agendaGroup1");
        agenda.setFocus("agendaGroup2");
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        node3.assertLeftTuple(tuple, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        node3.assertLeftTuple(tuple, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        AgendaTest.assertEquals((int)2, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)5, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((Object)agendaGroup2, (Object)agenda.getFocus());
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)4, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((Object)agendaGroup2, (Object)agenda.getFocus());
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)3, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((Object)agendaGroup1, (Object)agenda.getFocus());
        AgendaTest.assertEquals((int)1, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)2, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((Object)agendaGroup1, (Object)agenda.getFocus());
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)1, (int)agenda.agendaSize());
        agenda.fireNextItem(null);
        AgendaTest.assertEquals((Object)agenda.getFocus(), (Object)main);
        AgendaTest.assertEquals((int)0, (int)agenda.getFocus().size());
        AgendaTest.assertEquals((int)0, (int)agenda.agendaSize());
    }

    public void testNullErrorOnGetScheduledActivations() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        try {
            ((DefaultAgenda)workingMemory.getAgenda()).getScheduledActivations();
        }
        catch (NullPointerException e) {
            AgendaTest.fail((String)"Exception Should not have been thrown");
        }
    }
}

