/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.common.InternalWorkingMemory;
import org.drools.concurrent.ExternalExecutorService;
import org.drools.reteoo.PartitionManager;
import org.drools.reteoo.PartitionTaskManager;
import org.junit.Ignore;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;

public class PartitionTaskManagerTest
extends TestCase {
    private PartitionManager manager;
    private PartitionTaskManager taskManager;
    private InternalWorkingMemory workingMemory;

    public void setUp() {
        RuleBase rulebase = RuleBaseFactory.newRuleBase();
        this.workingMemory = (InternalWorkingMemory)rulebase.newStatefulSession();
        this.manager = new PartitionManager(this.workingMemory);
        this.taskManager = new PartitionTaskManager(this.manager, this.workingMemory);
    }

    protected void tearDown() throws Exception {
    }

    @Ignore
    public void testEnqueueBeforeSettingExecutor() throws InterruptedException {
        PartitionTaskManager.Action action = (PartitionTaskManager.Action)Mockito.mock(PartitionTaskManager.Action.class);
        this.taskManager.enqueue(action);
        ExternalExecutorService service = new ExternalExecutorService(Executors.newSingleThreadExecutor());
        this.manager.setPool(service);
        service.waitUntilEmpty();
        ((PartitionTaskManager.Action)Mockito.verify((Object)action)).execute(this.workingMemory);
    }

    @Ignore
    public void testFireCorrectly() throws InterruptedException {
        PartitionTaskManager.Action action = (PartitionTaskManager.Action)Mockito.mock(PartitionTaskManager.Action.class);
        ExternalExecutorService service = new ExternalExecutorService(Executors.newSingleThreadExecutor());
        this.manager.setPool(service);
        this.taskManager.enqueue(action);
        service.waitUntilEmpty();
        ((PartitionTaskManager.Action)Mockito.verify((Object)action)).execute(this.workingMemory);
    }

    @Ignore
    public void FIXME_testActionCallbacks() throws InterruptedException {
        PartitionTaskManager.Action action = (PartitionTaskManager.Action)Mockito.mock(PartitionTaskManager.Action.class);
        this.taskManager.enqueue(action);
        this.taskManager.enqueue(action);
        ExecutorService pool = Executors.newSingleThreadExecutor();
        ExternalExecutorService service = new ExternalExecutorService(pool);
        this.manager.setPool(service);
        this.taskManager.enqueue(action);
        this.taskManager.enqueue(action);
        this.taskManager.enqueue(action);
        service.waitUntilEmpty();
        pool.shutdown();
        ((PartitionTaskManager.Action)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)5))).execute(this.workingMemory);
    }
}

