/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.Agenda;
import org.drools.DroolsTestCase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Rule;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.PropagationContext;
import org.drools.time.impl.DurationTimer;
import org.drools.time.impl.Timer;

public class SchedulerTest
extends DroolsTestCase {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;

    protected void setUp() throws Exception {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
    }

    public void testScheduledActivation() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)this.ruleBase.newStatefulSession();
        Rule rule = new Rule("test-rule");
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule, rule.getLhs(), this.buildContext);
        final ArrayList data = new ArrayList();
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                data.add("tested");
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        rule.setTimer((Timer)new DurationTimer(100L));
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        LeftTuple tuple = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        SchedulerTest.assertEquals((int)0, (int)data.size());
        node.assertLeftTuple(tuple, (PropagationContext)context, workingMemory);
        Thread.sleep(300L);
        SchedulerTest.assertEquals((int)1, (int)data.size());
    }

    public void testDoLoopScheduledActivation() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        final Rule rule = new Rule("test-rule");
        final RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule, rule.getLhs(), this.buildContext);
        final ArrayList data = new ArrayList();
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                if (data.size() < 3) {
                    PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule, (LeftTuple)knowledgeHelper.getTuple(), null);
                    LeftTuple tuple2 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(2, (Object)"cheese"), null, true);
                    node.assertLeftTuple(tuple2, (PropagationContext)context2, (InternalWorkingMemory)((ReteooWorkingMemory)workingMemory));
                }
                data.add("tested");
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, null);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        rule.setTimer((Timer)new DurationTimer(50L));
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        SchedulerTest.assertEquals((int)0, (int)data.size());
        Thread.sleep(2000L);
        SchedulerTest.assertEquals((int)4, (int)data.size());
    }

    public void testNoLoopScheduledActivation() throws Exception {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        final Rule rule = new Rule("test-rule");
        final ArrayList data = new ArrayList();
        final RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule, rule.getLhs(), this.buildContext);
        rule.setTimer((Timer)new DurationTimer(100L));
        rule.setNoLoop(true);
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 400L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                if (data.size() < 5) {
                    PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule, (LeftTuple)knowledgeHelper.getTuple(), null);
                    LeftTuple tuple2 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(2, (Object)"cheese"), null, true);
                    node.assertLeftTuple(tuple2, (PropagationContext)context2, (InternalWorkingMemory)((ReteooWorkingMemory)workingMemory));
                }
                data.add("tested");
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, null);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), null, true);
        node.assertLeftTuple(tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        SchedulerTest.assertEquals((int)0, (int)data.size());
        Thread.sleep(500L);
        SchedulerTest.assertEquals((int)1, (int)data.size());
    }
}

