/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import junit.framework.TestCase;
import org.drools.StockTick;
import org.drools.base.ClassObjectType;
import org.drools.base.ValueType;
import org.drools.base.evaluators.AfterEvaluatorDefinition;
import org.drools.base.extractors.SelfReferenceClassFieldReader;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.rule.GroupElement;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.VariableConstraint;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Constraint;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.Restriction;
import org.drools.time.Interval;
import org.drools.time.TemporalDependencyMatrix;

public class BuildUtilsTest
extends TestCase {
    private BuildUtils utils;

    protected void setUp() throws Exception {
        this.utils = new BuildUtils();
    }

    public void testCalculateTemporalDistance() {
        Interval[][] input = new Interval[][]{{new Interval(0L, 0L), new Interval(-2L, 2L), new Interval(-3L, 4L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(Long.MIN_VALUE, Long.MAX_VALUE)}, {new Interval(-2L, 2L), new Interval(0L, 0L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(1L, 2L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE)}, {new Interval(-4L, 3L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(0L, 0L), new Interval(2L, 3L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE)}, {new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(-2L, -1L), new Interval(-3L, -2L), new Interval(0L, 0L), new Interval(1L, 10L)}, {new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(-10L, -1L), new Interval(0L, 0L)}};
        Interval[][] expected = new Interval[][]{{new Interval(0L, 0L), new Interval(-2L, 2L), new Interval(-3L, 2L), new Interval(-1L, 4L), new Interval(0L, 14L)}, {new Interval(-2L, 2L), new Interval(0L, 0L), new Interval(-2L, 0L), new Interval(1L, 2L), new Interval(2L, 12L)}, {new Interval(-2L, 3L), new Interval(0L, 2L), new Interval(0L, 0L), new Interval(2L, 3L), new Interval(3L, 13L)}, {new Interval(-4L, 1L), new Interval(-2L, -1L), new Interval(-3L, -2L), new Interval(0L, 0L), new Interval(1L, 10L)}, {new Interval(-14L, 0L), new Interval(-12L, -2L), new Interval(-13L, -3L), new Interval(-10L, -1L), new Interval(0L, 0L)}};
        AfterEvaluatorDefinition evals = new AfterEvaluatorDefinition();
        ClassObjectType ot = new ClassObjectType(StockTick.class, true);
        Pattern a = new Pattern(0, (ObjectType)ot, "$a");
        Pattern b = new Pattern(1, (ObjectType)ot, "$b");
        b.addConstraint((Constraint)new VariableConstraint((InternalReadAccessor)new SelfReferenceClassFieldReader(StockTick.class, "this"), (Restriction)new VariableRestriction(null, a.getDeclaration(), evals.getEvaluator(ValueType.OBJECT_TYPE, AfterEvaluatorDefinition.AFTER, "-2,2"))));
        Pattern c = new Pattern(2, (ObjectType)ot, "$c");
        c.addConstraint((Constraint)new VariableConstraint((InternalReadAccessor)new SelfReferenceClassFieldReader(StockTick.class, "this"), (Restriction)new VariableRestriction(null, a.getDeclaration(), evals.getEvaluator(ValueType.OBJECT_TYPE, AfterEvaluatorDefinition.AFTER, "-3,4"))));
        Pattern d = new Pattern(3, (ObjectType)ot, "$d");
        d.addConstraint((Constraint)new VariableConstraint((InternalReadAccessor)new SelfReferenceClassFieldReader(StockTick.class, "this"), (Restriction)new VariableRestriction(null, b.getDeclaration(), evals.getEvaluator(ValueType.OBJECT_TYPE, AfterEvaluatorDefinition.AFTER, "1,2"))));
        d.addConstraint((Constraint)new VariableConstraint((InternalReadAccessor)new SelfReferenceClassFieldReader(StockTick.class, "this"), (Restriction)new VariableRestriction(null, c.getDeclaration(), evals.getEvaluator(ValueType.OBJECT_TYPE, AfterEvaluatorDefinition.AFTER, "2,3"))));
        Pattern e = new Pattern(4, (ObjectType)ot, "$e");
        e.addConstraint((Constraint)new VariableConstraint((InternalReadAccessor)new SelfReferenceClassFieldReader(StockTick.class, "this"), (Restriction)new VariableRestriction(null, d.getDeclaration(), evals.getEvaluator(ValueType.OBJECT_TYPE, AfterEvaluatorDefinition.AFTER, "1,10"))));
        GroupElement not = new GroupElement(GroupElement.Type.NOT);
        not.addChild((RuleConditionElement)e);
        GroupElement and = new GroupElement(GroupElement.Type.AND);
        and.addChild((RuleConditionElement)a);
        and.addChild((RuleConditionElement)b);
        and.addChild((RuleConditionElement)c);
        and.addChild((RuleConditionElement)d);
        and.addChild((RuleConditionElement)not);
        TemporalDependencyMatrix matrix = this.utils.calculateTemporalDistance(and);
        this.assertEqualsMatrix(expected, matrix.getMatrix());
        BuildUtilsTest.assertEquals((long)14L, (long)matrix.getExpirationOffset(a));
        BuildUtilsTest.assertEquals((long)10L, (long)matrix.getExpirationOffset(d));
        BuildUtilsTest.assertEquals((long)0L, (long)matrix.getExpirationOffset(e));
    }

    public void assertEqualsMatrix(Interval[][] expected, Interval[][] matrix) {
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                BuildUtilsTest.assertEquals((String)("Wrong value at (" + i + ", " + j), (Object)expected[i][j], (Object)matrix[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void printMatrix(Interval[][] matrix) {
        System.out.println("------------------------------------------------------------------");
        int i = 0;
        while (i < matrix.length) {
            System.out.print("|  ");
            int j = 0;
            while (j < matrix[i].length) {
                System.out.print(matrix[i][j] + "  ");
                ++j;
            }
            System.out.println("|");
            ++i;
        }
        System.out.println("------------------------------------------------------------------");
    }
}

