/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test.dsl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.reteoo.test.dsl.ReteTesterHelper;
import org.drools.reteoo.test.dsl.Step;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.spi.InternalReadAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingStep
implements Step {
    private ReteTesterHelper reteTesterHelper;

    public BindingStep(ReteTesterHelper reteTesterHelper) {
        this.reteTesterHelper = reteTesterHelper;
    }

    @Override
    public void execute(Map<String, Object> context, List<String[]> args) {
        if (args.size() > 0) {
            for (Object[] objectArray : args) {
                if (objectArray.length == 4) {
                    this.createBinding(context, (String[])objectArray);
                    continue;
                }
                throw new IllegalArgumentException("Cannot create Binding for arguments: " + Arrays.toString(objectArray));
            }
        } else {
            throw new IllegalArgumentException("Cannot arguments " + args);
        }
    }

    private void createBinding(Map<String, Object> context, String[] bind) {
        String name = bind[0];
        String index = bind[1];
        String type = bind[2];
        String field = bind[3];
        try {
            Pattern pattern = this.reteTesterHelper.getPattern(Integer.parseInt(index), type);
            Class clazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
            ClassFieldAccessorStore store = (ClassFieldAccessorStore)context.get("ClassFieldAccessorStore");
            ClassFieldReader extractor = store.getReader(clazz, field, this.getClass().getClassLoader());
            Declaration declr = new Declaration(name, (InternalReadAccessor)extractor, pattern);
            context.put(name, declr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create Binding for arguments: " + Arrays.toString(bind), e);
        }
    }
}

