/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test.dsl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.reteoo.test.dsl.NodeTestCase;
import org.drools.reteoo.test.dsl.NodeTestDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTestCaseResult {
    private NodeTestCase testCase;
    private List<NodeTestResult> results;
    private int totalTests = 0;
    private int executed = 0;
    private int successes = 0;
    private int failures = 0;
    private int errors = 0;

    public NodeTestCaseResult(NodeTestCase testCase) {
        this.testCase = testCase;
        this.totalTests = testCase.getTests().size();
        this.results = new ArrayList<NodeTestResult>(this.totalTests);
    }

    public void add(NodeTestResult testResult) {
        ++this.executed;
        switch (testResult.result) {
            case SUCCESS: {
                ++this.successes;
                break;
            }
            case FAILURE: {
                ++this.failures;
                break;
            }
            case ERROR: {
                ++this.errors;
            }
        }
        this.results.add(testResult);
    }

    public NodeTestCase getTestCase() {
        return this.testCase;
    }

    public List<NodeTestResult> getResults() {
        return this.results;
    }

    public int getTotalTests() {
        return this.totalTests;
    }

    public int getExecuted() {
        return this.executed;
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getFailures() {
        return this.failures;
    }

    public int getErrors() {
        return this.errors;
    }

    public String toString() {
        String toString = "TestCase: '" + this.testCase.getName() + "' total=" + this.totalTests + " executed=" + this.executed + " successes=" + this.successes + " failures=" + this.failures + " errors=" + this.errors;
        if (this.totalTests - this.successes > 0) {
            for (NodeTestResult result : this.results) {
                if (result.result == Result.SUCCESS) continue;
                toString = String.valueOf(toString) + "\n     " + result;
            }
        }
        return toString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeTestResult {
        public NodeTestDef test;
        public Result result;
        public Map<String, Object> context;
        public List<String> errorMsgs;

        public NodeTestResult(NodeTestDef test, Result result, Map<String, Object> context, List<String> errorMsgs) {
            this.test = test;
            this.result = result;
            this.context = context;
            this.errorMsgs = errorMsgs;
        }

        public String getMessages() {
            return "[" + (Object)((Object)this.result) + "] Test '" + this.test.getName() + "' returned messages: " + this.errorMsgs.toString();
        }

        public String toString() {
            return this.getMessages();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        NOT_EXECUTED,
        SUCCESS,
        FAILURE,
        ERROR;

    }
}

