/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.Calendar;
import junit.framework.TestCase;
import org.drools.base.EnabledBoolean;
import org.drools.rule.Rule;
import org.drools.rule.TimeMachine;

public class RuleTest
extends TestCase {
    public void testDateEffective() {
        Rule rule = new Rule("myrule");
        RuleTest.assertTrue((boolean)rule.isEffective(new TimeMachine(), null, null));
        Calendar earlier = Calendar.getInstance();
        earlier.setTimeInMillis(10L);
        rule.setDateEffective(earlier);
        RuleTest.assertTrue((boolean)rule.isEffective(new TimeMachine(), null, null));
        Calendar later = Calendar.getInstance();
        later.setTimeInMillis(later.getTimeInMillis() + 100000000L);
        RuleTest.assertTrue((boolean)later.after(Calendar.getInstance()));
        rule.setDateEffective(later);
        RuleTest.assertFalse((boolean)rule.isEffective(new TimeMachine(), null, null));
    }

    public void testDateExpires() throws Exception {
        Rule rule = new Rule("myrule");
        RuleTest.assertTrue((boolean)rule.isEffective(new TimeMachine(), null, null));
        Calendar earlier = Calendar.getInstance();
        earlier.setTimeInMillis(10L);
        rule.setDateExpires(earlier);
        RuleTest.assertFalse((boolean)rule.isEffective(new TimeMachine(), null, null));
        Calendar later = Calendar.getInstance();
        later.setTimeInMillis(later.getTimeInMillis() + 100000000L);
        rule.setDateExpires(later);
        RuleTest.assertTrue((boolean)rule.isEffective(new TimeMachine(), null, null));
    }

    public void testDateEffectiveExpires() {
        Rule rule = new Rule("myrule");
        Calendar past = Calendar.getInstance();
        past.setTimeInMillis(10L);
        Calendar future = Calendar.getInstance();
        future.setTimeInMillis(future.getTimeInMillis() + 100000000L);
        rule.setDateEffective(past);
        rule.setDateExpires(future);
        RuleTest.assertTrue((boolean)rule.isEffective(new TimeMachine(), null, null));
        rule.setDateExpires(past);
        RuleTest.assertFalse((boolean)rule.isEffective(new TimeMachine(), null, null));
        rule.setDateExpires(future);
        rule.setDateEffective(future);
        RuleTest.assertFalse((boolean)rule.isEffective(new TimeMachine(), null, null));
    }

    public void testRuleEnabled() {
        Rule rule = new Rule("myrule");
        rule.setEnabled(EnabledBoolean.ENABLED_FALSE);
        RuleTest.assertFalse((boolean)rule.isEffective(new TimeMachine(), null, null));
        Calendar past = Calendar.getInstance();
        past.setTimeInMillis(10L);
        rule.setDateEffective(past);
        RuleTest.assertFalse((boolean)rule.isEffective(new TimeMachine(), null, null));
        rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
        RuleTest.assertTrue((boolean)rule.isEffective(new TimeMachine(), null, null));
    }

    public void testTimeMachine() {
        Rule rule = new Rule("myrule");
        rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
        RuleTest.assertTrue((boolean)rule.isEffective(new TimeMachine(), null, null));
        final Calendar future = Calendar.getInstance();
        future.setTimeInMillis(future.getTimeInMillis() + 100000000L);
        rule.setDateEffective(future);
        RuleTest.assertFalse((boolean)rule.isEffective(new TimeMachine(), null, null));
        RuleTest.assertTrue((boolean)rule.isEffective(new TimeMachine(){

            public Calendar getNow() {
                Calendar loveYouLongTime = Calendar.getInstance();
                loveYouLongTime.setTimeInMillis(future.getTimeInMillis() + 1000000000000L);
                return loveYouLongTime;
            }
        }, null, null));
    }
}

