/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import junit.framework.TestCase;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.Queue;
import org.drools.core.util.Queueable;
import org.drools.util.LongQueueable;
import org.drools.util.NaturalComparator;

public class BinaryHeapPriorityQueueTest
extends TestCase {
    public void testOptimised() {
        Random random = new Random();
        LinkedList<LongQueueable> items = new LinkedList<LongQueueable>();
        BinaryHeapQueue queue = new BinaryHeapQueue((Comparator)NaturalComparator.INSTANCE, 100000);
        int i = 0;
        while (i < 100000) {
            items.add(new LongQueueable((Queue)queue, random.nextLong()));
            ++i;
        }
        long startEnqueue = System.currentTimeMillis();
        Iterator i2 = items.iterator();
        while (i2.hasNext()) {
            queue.enqueue((Queueable)i2.next());
        }
        long elapsedEnqueue = System.currentTimeMillis() - startEnqueue;
        long startDequeue = System.currentTimeMillis();
        Iterator i3 = items.iterator();
        while (i3.hasNext()) {
            ((Queueable)i3.next()).dequeue();
        }
        long elapsedDequeue = System.currentTimeMillis() - startDequeue;
    }

    public void testBasic() {
        Random random = new Random();
        LinkedList<LongQueueable> items = new LinkedList<LongQueueable>();
        BinaryHeapQueue queue = new BinaryHeapQueue((Comparator)NaturalComparator.INSTANCE, 100000);
        int i = 0;
        while (i < 100000) {
            items.add(new LongQueueable((Queue)queue, random.nextLong()));
            ++i;
        }
        long startEnqueue = System.currentTimeMillis();
        Iterator i2 = items.iterator();
        while (i2.hasNext()) {
            queue.enqueue((Queueable)i2.next());
        }
        long elapsedEnqueue = System.currentTimeMillis() - startEnqueue;
        long startDequeue = System.currentTimeMillis();
        Iterator i3 = items.iterator();
        while (i3.hasNext()) {
            queue.enqueue((Queueable)i3.next());
        }
        long elapsedDequeue = System.currentTimeMillis() - startDequeue;
    }
}

