/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.drools.core.util.ObjectHashMap;

public class ObjectHashMapTest2
extends TestCase {
    public void testJUHashmap() {
        HashMap<String, String> map = new HashMap<String, String>();
        ObjectHashMapTest2.assertNotNull(map);
        int count = 1000;
        int idx = 0;
        while (idx < 1000) {
            String key = "key" + idx;
            String val = "value" + idx;
            map.put(key, val);
            ObjectHashMapTest2.assertEquals((Object)val, map.get(key));
            ++idx;
        }
    }

    public void testStringData() {
        ObjectHashMap map = new ObjectHashMap();
        ObjectHashMapTest2.assertNotNull((Object)map);
        int count = 1000;
        int idx = 0;
        while (idx < 1000) {
            String key = "key" + idx;
            String val = "value" + idx;
            map.put((Object)key, (Object)val);
            ObjectHashMapTest2.assertEquals((Object)val, (Object)map.get((Object)key));
            ++idx;
        }
    }

    public void testStringDataDupFalse() {
        ObjectHashMap map = new ObjectHashMap();
        ObjectHashMapTest2.assertNotNull((Object)map);
        int count = 10000;
        int idx = 0;
        while (idx < 10000) {
            String key = "key" + idx;
            String val = "value" + idx;
            map.put((Object)key, (Object)val, false);
            ObjectHashMapTest2.assertEquals((Object)val, (Object)map.get((Object)key));
            ++idx;
        }
    }

    public void testIntegerData() {
        ObjectHashMap map = new ObjectHashMap();
        ObjectHashMapTest2.assertNotNull((Object)map);
        int count = 1000;
        int idx = 0;
        while (idx < 1000) {
            Integer key = new Integer(idx);
            Integer val = new Integer(idx);
            map.put((Object)key, (Object)val);
            ObjectHashMapTest2.assertEquals((Object)val, (Object)map.get((Object)key));
            ++idx;
        }
    }

    public void testJUHashMap1() {
        int count = 100000;
        HashMap<String, String> map = new HashMap<String, String>();
        ObjectHashMapTest2.assertNotNull(map);
        long start = System.currentTimeMillis();
        int idx = 0;
        while (idx < 100000) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap put(key,value) ET - " + (end - start));
    }

    public void testStringData2() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        ObjectHashMapTest2.assertNotNull((Object)map);
        long start = System.currentTimeMillis();
        int idx = 0;
        while (idx < 100000) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval);
            ++idx;
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap put(key,value) ET - " + (end - start));
    }

    public void testStringData3() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        ObjectHashMapTest2.assertNotNull((Object)map);
        int idx = 0;
        while (idx < 100000) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval);
            ++idx;
        }
        long start = System.currentTimeMillis();
        int idx2 = 0;
        while (idx2 < 100000) {
            String key = "key" + idx2;
            map.get((Object)key);
            ++idx2;
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap get(key) ET - " + (end - start));
    }

    public void testJUHashMap2() {
        int count = 100000;
        HashMap<String, String> map = new HashMap<String, String>();
        ObjectHashMapTest2.assertNotNull(map);
        int idx = 0;
        while (idx < 100000) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long start = System.currentTimeMillis();
        int idx2 = 0;
        while (idx2 < 100000) {
            String key = "key" + idx2;
            map.get(key);
            ++idx2;
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap get(key) ET - " + (end - start));
    }

    public void testStringData4() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        ObjectHashMapTest2.assertNotNull((Object)map);
        int idx = 0;
        while (idx < 100000) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval);
            ++idx;
        }
        long start = System.currentTimeMillis();
        org.drools.core.util.Iterator itr = map.iterator();
        Object val = null;
        while ((val = itr.next()) != null) {
            val.hashCode();
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap iterate ET - " + (end - start));
    }

    public void testJUHashMap3() {
        int count = 100000;
        HashMap<String, String> map = new HashMap<String, String>();
        ObjectHashMapTest2.assertNotNull(map);
        int idx = 0;
        while (idx < 100000) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long start = System.currentTimeMillis();
        Iterator itr = map.values().iterator();
        while (itr.hasNext()) {
            itr.next().hashCode();
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap iterate ET - " + (end - start));
    }

    public void testStringData5() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        ObjectHashMapTest2.assertNotNull((Object)map);
        long start = System.currentTimeMillis();
        int idx = 0;
        while (idx < 100000) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval, false);
            ++idx;
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap dup false ET - " + (end - start));
    }

    public static void main(String[] args) {
        ObjectHashMapTest2 test = new ObjectHashMapTest2();
        int loop = 5;
        int idx = 0;
        while (idx < 5) {
            test.testIntegerData();
            test.testStringData();
            test.testJUHashmap();
            test.testStringData2();
            test.testJUHashMap1();
            test.testStringData3();
            test.testJUHashMap2();
            test.testStringData4();
            test.testJUHashMap3();
            test.testStringData5();
            test.testStringDataDupFalse();
            System.out.println(" --------------- ");
            ++idx;
        }
    }
}

