/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.asm;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.util.asm.BeanInherit;
import org.drools.util.asm.InterfaceChild;
import org.drools.util.asm.InterfaceChildImpl;
import org.drools.util.asm.TestAbstract;
import org.drools.util.asm.TestInterface;

public class ClassFieldInspectorTest
extends TestCase {
    public void testIt() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(Person.class);
        ClassFieldInspectorTest.assertEquals((int)7, (int)ext.getFieldNames().size());
        ClassFieldInspectorTest.assertEquals((String)"getAge", (String)((Method)ext.getGetterMethods().get("age")).getName());
        ClassFieldInspectorTest.assertEquals((String)"isHappy", (String)((Method)ext.getGetterMethods().get("happy")).getName());
        ClassFieldInspectorTest.assertEquals((String)"getName", (String)((Method)ext.getGetterMethods().get("name")).getName());
        Map names = ext.getFieldNames();
        ClassFieldInspectorTest.assertNotNull((Object)names);
        ClassFieldInspectorTest.assertEquals((int)7, (int)names.size());
        ClassFieldInspectorTest.assertNull(names.get("nAme"));
    }

    public void testInterface() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(TestInterface.class);
        ClassFieldInspectorTest.assertEquals((int)2, (int)ext.getFieldNames().size());
        ClassFieldInspectorTest.assertEquals((String)"getSomething", (String)((Method)ext.getGetterMethods().get("something")).getName());
        ClassFieldInspectorTest.assertEquals((String)"getAnother", (String)((Method)ext.getGetterMethods().get("another")).getName());
        Map names = ext.getFieldNames();
        ClassFieldInspectorTest.assertNotNull((Object)names);
        ClassFieldInspectorTest.assertEquals((int)2, (int)names.size());
    }

    public void testAbstract() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(TestAbstract.class);
        ClassFieldInspectorTest.assertEquals((int)5, (int)ext.getFieldNames().size());
        ClassFieldInspectorTest.assertEquals((String)"getSomething", (String)((Method)ext.getGetterMethods().get("something")).getName());
        ClassFieldInspectorTest.assertEquals((String)"getAnother", (String)((Method)ext.getGetterMethods().get("another")).getName());
        Map names = ext.getFieldNames();
        ClassFieldInspectorTest.assertNotNull((Object)names);
        ClassFieldInspectorTest.assertEquals((int)5, (int)names.size());
    }

    public void testInheritedFields() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(BeanInherit.class);
        ClassFieldInspectorTest.assertEquals((int)5, (int)ext.getFieldNames().size());
        ext = new ClassFieldInspector(InterfaceChildImpl.class);
        ClassFieldInspectorTest.assertEquals((int)8, (int)ext.getFieldNames().size());
        ClassFieldInspectorTest.assertNotNull(ext.getFieldNames().get("HTML"));
        ClassFieldInspectorTest.assertNotNull(ext.getFieldNames().get("baz"));
        ClassFieldInspectorTest.assertNotNull(ext.getFieldNames().get("URI"));
    }

    public void testIntefaceInheritance() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(InterfaceChild.class);
        Map fields = ext.getFieldNames();
        ClassFieldInspectorTest.assertTrue((boolean)fields.containsKey("foo"));
        ClassFieldInspectorTest.assertTrue((boolean)fields.containsKey("bar"));
        ClassFieldInspectorTest.assertTrue((boolean)fields.containsKey("baz"));
        ClassFieldInspectorTest.assertTrue((boolean)fields.containsKey("URI"));
    }

    public void testFieldIndexCalculation() {
        try {
            ClassFieldInspector ext = new ClassFieldInspector(SubPerson.class);
            Map map = ext.getFieldNames();
            String[] fields = new String[map.size()];
            for (Map.Entry entry : map.entrySet()) {
                String fieldName = (String)entry.getKey();
                int fieldIndex = (Integer)entry.getValue();
                if (fields[fieldIndex] == null) {
                    fields[fieldIndex] = fieldName;
                    continue;
                }
                Assert.fail((String)("Duplicate index found for 2 fields: index[" + fieldIndex + "] = [" + fields[fieldIndex] + "] and [" + fieldName + "]"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception thrown");
        }
    }

    public void testGetReturnTypes() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(Person.class);
        Map types = ext.getFieldTypes();
        ClassFieldInspectorTest.assertNotNull((Object)types);
        ClassFieldInspectorTest.assertEquals(Boolean.TYPE, types.get("happy"));
        ClassFieldInspectorTest.assertEquals(Integer.TYPE, types.get("age"));
        ClassFieldInspectorTest.assertEquals(String.class, types.get("name"));
    }

    public void testGetMethodForField() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(Person.class);
        Map methods = ext.getGetterMethods();
        ClassFieldInspectorTest.assertNotNull((Object)methods);
        ClassFieldInspectorTest.assertEquals((String)"isHappy", (String)((Method)methods.get("happy")).getName());
        ClassFieldInspectorTest.assertEquals((String)"getName", (String)((Method)methods.get("name")).getName());
        ClassFieldInspectorTest.assertNull(methods.get("nAme"));
        ClassFieldInspectorTest.assertEquals((String)"getAge", (String)((Method)methods.get("age")).getName());
    }

    public void testNonGetter() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(NonGetter.class);
        Map methods = ext.getGetterMethods();
        ClassFieldInspectorTest.assertEquals((String)"getFoo", (String)((Method)methods.get("foo")).getName());
        ClassFieldInspectorTest.assertEquals((int)5, (int)methods.size());
        ClassFieldInspectorTest.assertTrue((boolean)ext.getFieldNames().containsKey("foo"));
        ClassFieldInspectorTest.assertTrue((boolean)ext.getFieldNames().containsKey("baz"));
        ClassFieldInspectorTest.assertEquals(String.class, ext.getFieldTypes().get("foo"));
    }

    public void testWierdCapsForField() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(Person.class);
        Map methods = ext.getGetterMethods();
        ClassFieldInspectorTest.assertEquals((String)"getURI", (String)((Method)methods.get("URI")).getName());
        ClassFieldInspectorTest.assertEquals((int)7, (int)methods.size());
    }

    static class NonGetter {
        NonGetter() {
        }

        public int foo() {
            return 42;
        }

        public String getFoo() {
            return "foo";
        }

        public String baz() {
            return "";
        }

        public void bas() {
        }
    }

    static class Person {
        public static String aStaticString = "A static String";
        private boolean happy;
        private String name;
        private int age;
        private String URI;

        Person() {
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean isHappy() {
            return this.happy;
        }

        public void setHappy(boolean happy) {
            this.happy = happy;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void getNotAGetter() {
        }

        private boolean isBogus() {
            return false;
        }

        public String getAlsoBad(String s) {
            return "ignored";
        }

        public String getURI() {
            return this.URI;
        }

        public void setURI(String URI2) {
            this.URI = URI2;
        }
    }

    static class SubPerson {
        private int childField;

        SubPerson() {
        }

        public int getChildField() {
            return this.childField;
        }

        public void setChildField(int childField) {
            this.childField = childField;
        }
    }
}

