/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.drools.FactHandle;
import org.drools.QueryResult;
import org.drools.WorkingMemory;
import org.drools.rule.Declaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResults
implements Iterable<QueryResult> {
    private Map<String, Declaration> declarations;
    protected List<FactHandle[]> results;
    protected WorkingMemory workingMemory;

    public QueryResults() {
    }

    public QueryResults(List<FactHandle[]> results, Declaration[] declArray, WorkingMemory workingMemory) {
        this.results = results;
        this.workingMemory = workingMemory;
        if (declArray.length > 0) {
            HashMap<String, Declaration> map = new HashMap<String, Declaration>(declArray.length);
            int i = 0;
            int length = declArray.length;
            while (i < length) {
                map.put(declArray[i].getIdentifier(), declArray[i]);
                ++i;
            }
            this.declarations = map;
        } else {
            this.declarations = Collections.emptyMap();
        }
    }

    public QueryResult get(int i) {
        if (i > this.results.size()) {
            throw new NoSuchElementException();
        }
        return new QueryResult(this.results.get(i), this.workingMemory, this);
    }

    @Override
    public Iterator<QueryResult> iterator() {
        return new QueryResultsIterator(this.results.iterator());
    }

    public Map<String, Declaration> getDeclarations() {
        return this.declarations;
    }

    public int size() {
        return this.results.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryResultsIterator
    implements Iterator<QueryResult> {
        private Iterator<FactHandle[]> iterator;

        public QueryResultsIterator(Iterator<FactHandle[]> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public QueryResult next() {
            return new QueryResult(this.iterator.next(), QueryResults.this.workingMemory, QueryResults.this);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

