/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class DuringEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator DURING = Operator.addOperatorToRegistry("during", false);
    public static final Operator NOT_DURING = Operator.addOperatorToRegistry("during", true);
    private static final String[] SUPPORTED_IDS = new String[]{DURING.getOperatorString()};
    private Map<String, DuringEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        DuringEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, DuringEvaluator>();
        }
        if ((eval = this.cache.get(key = String.valueOf(isNegated) + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new DuringEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class DuringEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -5856043346192967722L;
        private long startMinDev;
        private long startMaxDev;
        private long endMinDev;
        private long endMaxDev;
        private String paramText;

        public DuringEvaluator() {
        }

        public DuringEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText) {
            super(type, isNegated ? NOT_DURING : DURING);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.startMinDev = in.readLong();
            this.startMaxDev = in.readLong();
            this.endMinDev = in.readLong();
            this.endMaxDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.startMinDev);
            out.writeLong(this.startMaxDev);
            out.writeLong(this.endMinDev);
            out.writeLong(this.endMaxDev);
            out.writeObject(this.paramText);
        }

        public Object prepareLeftObject(InternalFactHandle handle) {
            return handle;
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(1L, Long.MAX_VALUE);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'during' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            long distStart = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getStartTimestamp() - ((EventFactHandle)left).getStartTimestamp();
            long distEnd = ((EventFactHandle)left).getEndTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getEndTimestamp();
            return this.getOperator().isNegated() ^ (distStart >= this.startMinDev && distStart <= this.startMaxDev && distEnd >= this.endMinDev && distEnd <= this.endMaxDev);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            long distStart = ((EventFactHandle)right).getStartTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getStartTimestamp();
            long distEnd = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getEndTimestamp() - ((EventFactHandle)right).getEndTimestamp();
            return this.getOperator().isNegated() ^ (distStart >= this.startMinDev && distStart <= this.startMaxDev && distEnd >= this.endMinDev && distEnd <= this.endMaxDev);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            long distStart = ((EventFactHandle)object1).getStartTimestamp() - ((EventFactHandle)object2).getStartTimestamp();
            long distEnd = ((EventFactHandle)object2).getEndTimestamp() - ((EventFactHandle)object1).getEndTimestamp();
            return this.getOperator().isNegated() ^ (distStart >= this.startMinDev && distStart <= this.startMaxDev && distEnd >= this.endMinDev && distEnd <= this.endMaxDev);
        }

        public String toString() {
            return "during[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endMaxDev ^ this.endMaxDev >>> 32);
            result = 31 * result + (int)(this.endMinDev ^ this.endMinDev >>> 32);
            result = 31 * result + (int)(this.startMaxDev ^ this.startMaxDev >>> 32);
            result = 31 * result + (int)(this.startMinDev ^ this.startMinDev >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DuringEvaluator other = (DuringEvaluator)obj;
            return this.endMaxDev == other.endMaxDev && this.endMinDev == other.endMinDev && this.startMaxDev == other.startMaxDev && this.startMinDev == other.startMinDev;
        }

        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.startMinDev = 1L;
                this.startMaxDev = Long.MAX_VALUE;
                this.endMinDev = 1L;
                this.endMaxDev = Long.MAX_VALUE;
            } else if (parameters.length == 1) {
                this.startMinDev = 1L;
                this.startMaxDev = parameters[0];
                this.endMinDev = 1L;
                this.endMaxDev = parameters[0];
            } else if (parameters.length == 2) {
                this.startMinDev = parameters[0];
                this.startMaxDev = parameters[1];
                this.endMinDev = parameters[0];
                this.endMaxDev = parameters[1];
            } else if (parameters.length == 4) {
                this.startMinDev = parameters[0];
                this.startMaxDev = parameters[1];
                this.endMinDev = parameters[2];
                this.endMaxDev = parameters[3];
            } else {
                throw new RuntimeDroolsException("[During Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
            }
        }
    }
}

