/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorCache;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;

public class SetEvaluatorsDefinition
implements EvaluatorDefinition {
    public static final Operator CONTAINS = Operator.addOperatorToRegistry("contains", false);
    public static final Operator NOT_CONTAINS = Operator.addOperatorToRegistry("contains", true);
    public static final Operator EXCLUDES = Operator.addOperatorToRegistry("excludes", false);
    public static final Operator NOT_EXCLUDES = Operator.addOperatorToRegistry("excludes", true);
    public static final Operator MEMBEROF = Operator.addOperatorToRegistry("memberOf", false);
    public static final Operator NOT_MEMBEROF = Operator.addOperatorToRegistry("memberOf", true);
    private static final String[] SUPPORTED_IDS = new String[]{CONTAINS.getOperatorString(), EXCLUDES.getOperatorString(), MEMBEROF.getOperatorString()};
    private EvaluatorCache evaluators = new EvaluatorCache(){
        private static final long serialVersionUID = 4782368623L;
        {
            this.addEvaluator(ValueType.ARRAY_TYPE, CONTAINS, ArrayContainsEvaluator.INSTANCE);
            this.addEvaluator(ValueType.ARRAY_TYPE, NOT_CONTAINS, ArrayExcludesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.ARRAY_TYPE, EXCLUDES, ArrayExcludesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.ARRAY_TYPE, NOT_EXCLUDES, ArrayContainsEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_DECIMAL_TYPE, MEMBEROF, BigDecimalMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_DECIMAL_TYPE, NOT_MEMBEROF, BigDecimalNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_INTEGER_TYPE, MEMBEROF, BigIntegerMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_INTEGER_TYPE, NOT_MEMBEROF, BigIntegerNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BOOLEAN_TYPE, MEMBEROF, BooleanMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BOOLEAN_TYPE, NOT_MEMBEROF, BooleanNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBOOLEAN_TYPE, MEMBEROF, BooleanMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBOOLEAN_TYPE, NOT_MEMBEROF, BooleanNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BYTE_TYPE, MEMBEROF, ByteMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BYTE_TYPE, NOT_MEMBEROF, ByteNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBYTE_TYPE, MEMBEROF, ByteMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBYTE_TYPE, NOT_MEMBEROF, ByteNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.CHAR_TYPE, MEMBEROF, CharacterMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.CHAR_TYPE, NOT_MEMBEROF, CharacterNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PCHAR_TYPE, MEMBEROF, CharacterMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PCHAR_TYPE, NOT_MEMBEROF, CharacterNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DATE_TYPE, MEMBEROF, DateMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DATE_TYPE, NOT_MEMBEROF, DateNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DOUBLE_TYPE, MEMBEROF, DoubleMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DOUBLE_TYPE, NOT_MEMBEROF, DoubleNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PDOUBLE_TYPE, MEMBEROF, DoubleMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PDOUBLE_TYPE, NOT_MEMBEROF, DoubleNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.FLOAT_TYPE, MEMBEROF, FloatMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.FLOAT_TYPE, NOT_MEMBEROF, FloatNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PFLOAT_TYPE, MEMBEROF, FloatMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PFLOAT_TYPE, NOT_MEMBEROF, FloatNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.INTEGER_TYPE, MEMBEROF, IntegerMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.INTEGER_TYPE, NOT_MEMBEROF, IntegerNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PINTEGER_TYPE, MEMBEROF, IntegerMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PINTEGER_TYPE, NOT_MEMBEROF, IntegerNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.LONG_TYPE, MEMBEROF, LongMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.LONG_TYPE, NOT_MEMBEROF, LongNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PLONG_TYPE, MEMBEROF, LongMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PLONG_TYPE, NOT_MEMBEROF, LongNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, CONTAINS, ObjectContainsEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, NOT_CONTAINS, ObjectExcludesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, EXCLUDES, ObjectExcludesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, NOT_EXCLUDES, ObjectContainsEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, MEMBEROF, ObjectMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, NOT_MEMBEROF, ObjectNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.SHORT_TYPE, MEMBEROF, ShortMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.SHORT_TYPE, NOT_MEMBEROF, ShortNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PSHORT_TYPE, MEMBEROF, ShortMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PSHORT_TYPE, NOT_MEMBEROF, ShortNotMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.STRING_TYPE, MEMBEROF, StringMemberOfEvaluator.INSTANCE);
            this.addEvaluator(ValueType.STRING_TYPE, NOT_MEMBEROF, StringNotMemberOfEvaluator.INSTANCE);
        }
    };
    private static ObjectArrayContainsEvaluator objectArrayEvaluator = new ObjectArrayContainsEvaluator();
    private static Map<Class, ArrayContains> primitiveArrayEvaluator = new HashMap(){
        {
            this.put(boolean[].class, new BooleanArrayContainsEvaluator());
            this.put(byte[].class, new ByteArrayContainsEvaluator());
            this.put(short[].class, new ShortArrayContainsEvaluator());
            this.put(char[].class, new CharArrayContainsEvaluator());
            this.put(int[].class, new IntegerArrayContainsEvaluator());
            this.put(long[].class, new LongArrayContainsEvaluator());
            this.put(float[].class, new FloatArrayContainsEvaluator());
            this.put(double[].class, new DoubleArrayContainsEvaluator());
        }
    };

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (EvaluatorCache)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        return this.evaluators.getEvaluator(type, Operator.determineOperator(operatorId, isNegated));
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    public boolean supportsType(ValueType type) {
        return this.evaluators.supportsType(type);
    }

    public static ArrayContains getArrayContains(Class cls) {
        ArrayContains eval = primitiveArrayEvaluator.get(cls);
        if (eval == null) {
            eval = objectArrayEvaluator;
        }
        return eval;
    }

    private static boolean contains(Object[] array, Object value) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == null && value == null || array[i] != null && array[i].equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static interface ArrayContains {
        public Class getArrayType();

        public boolean contains(Object var1, FieldValue var2);

        public boolean contains(Object var1, InternalWorkingMemory var2, InternalReadAccessor var3, Object var4);
    }

    public static class ArrayContainsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ArrayContainsEvaluator();

        public ArrayContainsEvaluator() {
            super(ValueType.ARRAY_TYPE, CONTAINS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object array = extractor.getValue(workingMemory, object1);
            if (array == null) {
                return false;
            }
            return SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, object2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object array = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (array == null) {
                return false;
            }
            return SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, workingMemory, context.declaration.getExtractor(), left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object array = context.extractor.getValue(workingMemory, right);
            if (array == null) {
                return false;
            }
            return SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, workingMemory, context.declaration.getExtractor(), context.reteTuple.get(context.declaration).getObject());
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object array = extractor1.getValue(workingMemory, object1);
            if (array == null) {
                return false;
            }
            return SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, workingMemory, extractor2, object2);
        }

        public String toString() {
            return "Array contains";
        }
    }

    public static class ArrayExcludesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ArrayExcludesEvaluator();

        public ArrayExcludesEvaluator() {
            super(ValueType.ARRAY_TYPE, EXCLUDES);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object array = extractor.getValue(workingMemory, object1);
            if (array == null) {
                return false;
            }
            return !SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, object2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object array = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (array == null) {
                return false;
            }
            return !SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, workingMemory, context.declaration.getExtractor(), left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object array = context.extractor.getValue(workingMemory, right);
            if (array == null) {
                return false;
            }
            return !SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, workingMemory, context.declaration.getExtractor(), context.getTuple().get(context.getVariableDeclaration()).getObject());
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object array = extractor1.getValue(workingMemory, object1);
            if (array == null) {
                return false;
            }
            return !SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, workingMemory, extractor2, object2);
        }

        public String toString() {
            return "Array not contains";
        }
    }

    public static abstract class BaseMemberOfEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 2017803222427893249L;

        public BaseMemberOfEvaluator() {
            super(null, null);
        }

        public BaseMemberOfEvaluator(ValueType type, Operator operator) {
            super(type, operator);
        }

        public ValueType getCoercedValueType() {
            return ValueType.OBJECT_TYPE;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (object2.isNull()) {
                return false;
            }
            if (object2.isCollectionField()) {
                Collection col = (Collection)object2.getValue();
                Object value = extractor.getValue(workingMemory, object1);
                return col.contains(value);
            }
            if (object2.getValue().getClass().isArray()) {
                return SetEvaluatorsDefinition.getArrayContains(object2.getValue().getClass()).contains(object2.getValue(), workingMemory, extractor, object1);
            }
            throw new ClassCastException("Can't check if an attribute is member of an object of class " + object2.getValue().getClass());
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object object = context.declaration.getExtractor().getValue(workingMemory, left);
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = ((VariableRestriction.ObjectVariableContextEntry)context).right;
                return col.contains(value);
            }
            if (object.getClass().isArray()) {
                return SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, workingMemory, context.extractor, context.object);
            }
            throw new ClassCastException("Can't check if an attribute is member of an object of class " + object.getClass());
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object object = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = context.extractor.getValue(workingMemory, right);
                return col.contains(value);
            }
            if (object.getClass().isArray()) {
                return SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, workingMemory, context.extractor, right);
            }
            throw new ClassCastException("Can't check if an attribute is member of an object of class " + object.getClass());
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object object = extractor2.getValue(workingMemory, object2);
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = extractor1.getValue(workingMemory, object1);
                return col.contains(value);
            }
            if (object.getClass().isArray()) {
                return SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, workingMemory, extractor1, object1);
            }
            throw new ClassCastException("Can't check if an attribute is member of an object of class " + object.getClass());
        }

        public abstract String toString();
    }

    public static abstract class BaseNotMemberOfEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -8730331781980886901L;

        public BaseNotMemberOfEvaluator(ValueType type, Operator operator) {
            super(type, operator);
        }

        public ValueType getCoercedValueType() {
            return ValueType.OBJECT_TYPE;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (object2.isNull()) {
                return false;
            }
            if (object2.isCollectionField()) {
                Object value;
                Collection col = (Collection)object2.getValue();
                return !col.contains(value = extractor.getValue(workingMemory, object1));
            }
            if (object2.getValue().getClass().isArray()) {
                return !SetEvaluatorsDefinition.getArrayContains(object2.getValue().getClass()).contains(object2.getValue(), workingMemory, extractor, object1);
            }
            throw new ClassCastException("Can't check if an attribute is not member of an object of class " + object2.getValue().getClass());
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object object = context.declaration.getExtractor().getValue(workingMemory, left);
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = ((VariableRestriction.ObjectVariableContextEntry)context).right;
                return !col.contains(value);
            }
            if (object.getClass().isArray()) {
                return !SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, workingMemory, context.extractor, context.object);
            }
            throw new ClassCastException("Can't check if an attribute is not member of an object of class " + object.getClass());
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object object = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = context.extractor.getValue(workingMemory, right);
                return !col.contains(value);
            }
            if (object.getClass().isArray()) {
                return !SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, workingMemory, context.extractor, right);
            }
            throw new ClassCastException("Can't check if an attribute is not member of an object of class " + object.getClass());
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object object = extractor2.getValue(workingMemory, object2);
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = extractor1.getValue(workingMemory, object1);
                return !col.contains(value);
            }
            if (object.getClass().isArray()) {
                return !SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, workingMemory, extractor1, object1);
            }
            throw new ClassCastException("Can't check if an attribute is not member of an object of class " + object.getClass());
        }

        public abstract String toString();
    }

    public static class BigDecimalMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalMemberOfEvaluator();

        public BigDecimalMemberOfEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, MEMBEROF);
        }

        public String toString() {
            return "BigDecimal memberOf";
        }
    }

    public static class BigDecimalNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalNotMemberOfEvaluator();

        public BigDecimalNotMemberOfEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "BigDecimal not memberOf";
        }
    }

    public static class BigIntegerMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerMemberOfEvaluator();

        public BigIntegerMemberOfEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, MEMBEROF);
        }

        public String toString() {
            return "BigInteger memberOf";
        }
    }

    public static class BigIntegerNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerNotMemberOfEvaluator();

        public BigIntegerNotMemberOfEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "BigInteger not memberOf";
        }
    }

    public static class BooleanArrayContainsEvaluator
    implements ArrayContains {
        public boolean contains(Object array, FieldValue value) {
            boolean[] boolArray = (boolean[])array;
            int i = 0;
            int length = boolArray.length;
            while (i < length) {
                if (boolArray[i] == value.getBooleanValue()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean contains(Object array, InternalWorkingMemory workingMemory, InternalReadAccessor accessor, Object object) {
            boolean[] boolArray = (boolean[])array;
            int i = 0;
            int length = boolArray.length;
            while (i < length) {
                if (boolArray[i] == accessor.getBooleanValue(workingMemory, object)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean contains(byte[] array, byte value, boolean negate) {
            int i = 0;
            int length = array.length;
            while (i < length) {
                if (array[i] == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Class getArrayType() {
            return boolean[].class;
        }
    }

    public static class BooleanMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BooleanMemberOfEvaluator();

        public BooleanMemberOfEvaluator() {
            super(ValueType.PBOOLEAN_TYPE, MEMBEROF);
        }

        public String toString() {
            return "Boolean memberOf";
        }
    }

    public static class BooleanNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BooleanNotMemberOfEvaluator();

        public BooleanNotMemberOfEvaluator() {
            super(ValueType.PBOOLEAN_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "Boolean not memberOf";
        }
    }

    public static class ByteArrayContainsEvaluator
    implements ArrayContains {
        public boolean contains(Object array, FieldValue value) {
            return this.contains((byte[])array, value.getByteValue());
        }

        public boolean contains(Object array, InternalWorkingMemory workingMemory, InternalReadAccessor accessor, Object object) {
            return this.contains((byte[])array, accessor.getByteValue(workingMemory, object));
        }

        private boolean contains(byte[] array, byte value) {
            int i = 0;
            int length = array.length;
            while (i < length) {
                if (array[i] == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Class getArrayType() {
            return byte[].class;
        }
    }

    public static class ByteMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ByteMemberOfEvaluator();

        public ByteMemberOfEvaluator() {
            super(ValueType.PBYTE_TYPE, MEMBEROF);
        }

        public String toString() {
            return "Byte memberOf";
        }
    }

    public static class ByteNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ByteNotMemberOfEvaluator();

        public ByteNotMemberOfEvaluator() {
            super(ValueType.PBYTE_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "Byte not memberOf";
        }
    }

    public static class CharArrayContainsEvaluator
    implements ArrayContains {
        public boolean contains(Object array, FieldValue value) {
            return this.contains((char[])array, value.getCharValue());
        }

        public boolean contains(Object array, InternalWorkingMemory workingMemory, InternalReadAccessor accessor, Object object) {
            return this.contains((char[])array, accessor.getCharValue(workingMemory, object));
        }

        private boolean contains(char[] array, char value) {
            int i = 0;
            int length = array.length;
            while (i < length) {
                if (array[i] == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Class getArrayType() {
            return char[].class;
        }
    }

    public static class CharacterMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterMemberOfEvaluator();

        public CharacterMemberOfEvaluator() {
            super(ValueType.PCHAR_TYPE, MEMBEROF);
        }

        public String toString() {
            return "Character memberOf";
        }
    }

    public static class CharacterNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterNotMemberOfEvaluator();

        public CharacterNotMemberOfEvaluator() {
            super(ValueType.PCHAR_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "Character not memberOf";
        }
    }

    public static class DateMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateMemberOfEvaluator();

        public DateMemberOfEvaluator() {
            super(ValueType.DATE_TYPE, MEMBEROF);
        }

        public String toString() {
            return "Date memberOf";
        }
    }

    public static class DateNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateNotMemberOfEvaluator();

        public DateNotMemberOfEvaluator() {
            super(ValueType.DATE_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "Date not memberOf";
        }
    }

    public static class DoubleArrayContainsEvaluator
    implements ArrayContains {
        public boolean contains(Object array, FieldValue fieldValue) {
            return this.contains((double[])array, fieldValue.getDoubleValue());
        }

        public boolean contains(Object array, InternalWorkingMemory workingMemory, InternalReadAccessor accessor, Object object) {
            return this.contains((double[])array, accessor.getDoubleValue(workingMemory, object));
        }

        private boolean contains(double[] array, double value) {
            int i = 0;
            int length = array.length;
            while (i < length) {
                if (array[i] == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Class getArrayType() {
            return double[].class;
        }
    }

    public static class DoubleMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DoubleMemberOfEvaluator();

        public DoubleMemberOfEvaluator() {
            super(ValueType.PDOUBLE_TYPE, MEMBEROF);
        }

        public String toString() {
            return "Double memberOf";
        }
    }

    public static class DoubleNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DoubleNotMemberOfEvaluator();

        public DoubleNotMemberOfEvaluator() {
            super(ValueType.PDOUBLE_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "Double not memberOf";
        }
    }

    public static class FloatArrayContainsEvaluator
    implements ArrayContains {
        public boolean contains(Object array, FieldValue value) {
            return this.contains((float[])array, value.getFloatValue());
        }

        public boolean contains(Object array, InternalWorkingMemory workingMemory, InternalReadAccessor accessor, Object object) {
            return this.contains((float[])array, accessor.getFloatValue(workingMemory, object));
        }

        private boolean contains(float[] array, float value) {
            int i = 0;
            int length = array.length;
            while (i < length) {
                if (array[i] == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Class getArrayType() {
            return float[].class;
        }
    }

    public static class FloatMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FloatMemberOfEvaluator();

        public FloatMemberOfEvaluator() {
            super(ValueType.PFLOAT_TYPE, MEMBEROF);
        }

        public String toString() {
            return "Float memberOf";
        }
    }

    public static class FloatNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FloatNotMemberOfEvaluator();

        public FloatNotMemberOfEvaluator() {
            super(ValueType.PFLOAT_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "Float not memberOf";
        }
    }

    public static class IntegerArrayContainsEvaluator
    implements ArrayContains {
        public boolean contains(Object array, FieldValue value) {
            return this.contains((int[])array, value.getIntValue());
        }

        public boolean contains(Object array, InternalWorkingMemory workingMemory, InternalReadAccessor accessor, Object object) {
            return this.contains((int[])array, accessor.getIntValue(workingMemory, object));
        }

        private boolean contains(int[] array, int value) {
            int i = 0;
            int length = array.length;
            while (i < length) {
                if (array[i] == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Class getArrayType() {
            return int[].class;
        }
    }

    public static class IntegerMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerMemberOfEvaluator();

        public IntegerMemberOfEvaluator() {
            super(ValueType.PINTEGER_TYPE, MEMBEROF);
        }

        public String toString() {
            return "Integer memberOf";
        }
    }

    public static class IntegerNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerNotMemberOfEvaluator();

        public IntegerNotMemberOfEvaluator() {
            super(ValueType.PINTEGER_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "Integer not memberOf";
        }
    }

    public static class LongArrayContainsEvaluator
    implements ArrayContains {
        public boolean contains(Object array, FieldValue value) {
            return this.contains((long[])array, value.getLongValue());
        }

        public boolean contains(Object array, InternalWorkingMemory workingMemory, InternalReadAccessor accessor, Object object) {
            return this.contains((long[])array, accessor.getLongValue(workingMemory, object));
        }

        private boolean contains(long[] array, long value) {
            int i = 0;
            int length = array.length;
            while (i < length) {
                if (array[i] == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Class getArrayType() {
            return long[].class;
        }
    }

    public static class LongMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new LongMemberOfEvaluator();

        public LongMemberOfEvaluator() {
            super(ValueType.PLONG_TYPE, MEMBEROF);
        }

        public String toString() {
            return "Long memberOf";
        }
    }

    public static class LongNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new LongNotMemberOfEvaluator();

        public LongNotMemberOfEvaluator() {
            super(ValueType.PLONG_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "Long not memberOf";
        }
    }

    public static class ObjectArrayContainsEvaluator
    implements ArrayContains {
        public boolean contains(Object array, FieldValue fieldValue) {
            return this.contains((Object[])array, fieldValue.getValue());
        }

        public boolean contains(Object array, InternalWorkingMemory workingMemory, InternalReadAccessor accessor, Object object) {
            return this.contains((Object[])array, accessor.getValue(workingMemory, object));
        }

        private boolean contains(Object[] array, Object value) {
            int i = 0;
            int length = array.length;
            while (i < length) {
                if (array[i].equals(value)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Class getArrayType() {
            return Object[].class;
        }
    }

    public static class ObjectContainsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectContainsEvaluator();

        public ObjectContainsEvaluator() {
            super(ValueType.OBJECT_TYPE, CONTAINS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value = object2.getValue();
            Collection col = (Collection)extractor.getValue(workingMemory, object1);
            return col == null ? false : col.contains(value);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            Collection col = (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return col == null ? false : col.contains(value);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Collection col = (Collection)context.extractor.getValue(workingMemory, right);
            return col == null ? false : col.contains(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value = extractor2.getValue(workingMemory, object2);
            Collection col = (Collection)extractor1.getValue(workingMemory, object1);
            return col == null ? false : col.contains(value);
        }

        public String toString() {
            return "Object contains";
        }
    }

    public static class ObjectExcludesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectExcludesEvaluator();

        public ObjectExcludesEvaluator() {
            super(ValueType.OBJECT_TYPE, EXCLUDES);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value = object2.getValue();
            Collection col = (Collection)extractor.getValue(workingMemory, object1);
            return col == null ? true : !col.contains(value);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            Collection col = (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return col == null ? true : !col.contains(value);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Collection col = (Collection)context.extractor.getValue(workingMemory, right);
            return col == null ? true : !col.contains(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value = extractor2.getValue(workingMemory, object2);
            Collection col = (Collection)extractor1.getValue(workingMemory, object1);
            return col == null ? true : !col.contains(value);
        }

        public String toString() {
            return "Object excludes";
        }
    }

    public static class ObjectMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectMemberOfEvaluator();

        public ObjectMemberOfEvaluator() {
            super(ValueType.OBJECT_TYPE, MEMBEROF);
        }

        public String toString() {
            return "Object memberOf";
        }
    }

    public static class ObjectNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectNotMemberOfEvaluator();

        public ObjectNotMemberOfEvaluator() {
            super(ValueType.OBJECT_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "Object not memberOf";
        }
    }

    public static class ShortArrayContainsEvaluator
    implements ArrayContains {
        public boolean contains(Object array, FieldValue value) {
            return this.contains((short[])array, value.getShortValue());
        }

        public boolean contains(Object array, InternalWorkingMemory workingMemory, InternalReadAccessor accessor, Object object) {
            return this.contains((short[])array, accessor.getShortValue(workingMemory, object));
        }

        private boolean contains(short[] array, short value) {
            int i = 0;
            int length = array.length;
            while (i < length) {
                if (array[i] == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Class getArrayType() {
            return short[].class;
        }
    }

    public static class ShortMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ShortMemberOfEvaluator();

        public ShortMemberOfEvaluator() {
            super(ValueType.PSHORT_TYPE, MEMBEROF);
        }

        public String toString() {
            return "Short memberOf";
        }
    }

    public static class ShortNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ShortNotMemberOfEvaluator();

        public ShortNotMemberOfEvaluator() {
            super(ValueType.PSHORT_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "Short not memberOf";
        }
    }

    public static class StringMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringMemberOfEvaluator();

        public StringMemberOfEvaluator() {
            super(ValueType.STRING_TYPE, MEMBEROF);
        }

        public String toString() {
            return "String memberOf";
        }
    }

    public static class StringNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringNotMemberOfEvaluator();

        public StringNotMemberOfEvaluator() {
            super(ValueType.STRING_TYPE, NOT_MEMBEROF);
        }

        public String toString() {
            return "String not memberOf";
        }
    }
}

