/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.assertion;

import java.util.HashMap;
import org.drools.command.Command;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.core.util.StringUtils;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertEquals
implements GenericCommand<Void> {
    private String message;
    private Object expectedObject;
    private String expectedIdentifier;
    private Command command;
    private String mvelString;

    public AssertEquals(String message, Object expectedObject, Command command, String mvelString) {
        this.message = message;
        this.expectedObject = expectedObject;
        this.command = command;
        this.mvelString = mvelString;
    }

    public AssertEquals(String message, String expectedIdentifier, Command command, String mvelString) {
        this.message = message;
        this.expectedIdentifier = expectedIdentifier;
        this.command = command;
        this.mvelString = mvelString;
    }

    @Override
    public Void execute(Context context) {
        Object actualObject = ((GenericCommand)this.command).execute(context);
        if (this.mvelString != null) {
            actualObject = MVEL.eval((String)this.mvelString, actualObject);
        }
        if (this.expectedIdentifier != null) {
            this.expectedObject = context.get(this.expectedIdentifier);
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("expected", this.expectedObject);
        vars.put("actual", actualObject);
        if (((Boolean)MVEL.eval((String)"expected != actual", vars)).booleanValue()) {
            throw new AssertionError((Object)AssertEquals.format(this.message, this.expectedObject, actualObject));
        }
        return null;
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        StringBuilder builder = new StringBuilder();
        if (!StringUtils.isEmpty(message)) {
            builder.append(message);
            builder.append(" ");
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            builder.append("expected: ");
            builder.append(AssertEquals.formatClassAndValue(expected, expectedString));
            builder.append(" but was: ");
            builder.append(AssertEquals.formatClassAndValue(actual, actualString));
        } else {
            builder.append("expected:<");
            builder.append(expectedString);
            builder.append("> but was:<");
            builder.append(actualString);
        }
        return builder.toString();
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return String.valueOf(className) + "<" + valueString + ">";
    }

    public String toString() {
        return "assert";
    }
}

