/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.process;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class SignalEventCommand
implements GenericCommand<Object> {
    @XmlAttribute(name="process-instance-id")
    private long processInstanceId = -1L;
    @XmlAttribute(name="event-type", required=true)
    private String eventType;
    @XmlElement(name="event")
    private Object event;

    public SignalEventCommand() {
    }

    public SignalEventCommand(String eventType, Object event) {
        this.eventType = eventType;
        this.event = event;
    }

    public SignalEventCommand(long processInstanceId, String eventType, Object event) {
        this.processInstanceId = processInstanceId;
        this.eventType = eventType;
        this.event = event;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Object getEvent() {
        return this.event;
    }

    public void setEvent(Object event) {
        this.event = event;
    }

    @Override
    public Object execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        if (this.processInstanceId == -1L) {
            ksession.signalEvent(this.eventType, this.event);
        } else {
            ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId);
            if (processInstance != null) {
                processInstance.signalEvent(this.eventType, this.event);
            }
        }
        return null;
    }

    public String toString() {
        if (this.processInstanceId == -1L) {
            return "session.getSignalManager().signalEvent(" + this.eventType + ", " + this.event + ");";
        }
        return "processInstance.signalEvent(" + this.eventType + ", " + this.event + ");";
    }
}

