/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemoryEntryPoint;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.ObjectStore;
import org.drools.common.ObjectTypeConfigurationRegistry;
import org.drools.common.PropagationContextImpl;
import org.drools.common.SingleThreadedObjectStore;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.rule.EntryPoint;
import org.drools.rule.Rule;
import org.drools.runtime.ObjectFilter;
import org.drools.spi.Activation;
import org.drools.spi.FactHandleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedEntryPoint
implements InternalWorkingMemoryEntryPoint,
WorkingMemoryEntryPoint {
    protected final Object[] addRemovePropertyChangeListenerArgs = new Object[]{this};
    private static final long serialVersionUID = 500L;
    protected ObjectStore objectStore;
    protected transient InternalRuleBase ruleBase;
    protected EntryPoint entryPoint;
    protected EntryPointNode entryPointNode;
    private ObjectTypeConfigurationRegistry typeConfReg;
    private final AbstractWorkingMemory wm;
    private FactHandleFactory handleFactory;
    protected final ReentrantLock lock;

    public NamedEntryPoint(EntryPoint entryPoint, EntryPointNode entryPointNode, AbstractWorkingMemory wm) {
        this(entryPoint, entryPointNode, wm, new ReentrantLock());
    }

    public NamedEntryPoint(EntryPoint entryPoint, EntryPointNode entryPointNode, AbstractWorkingMemory wm, ReentrantLock lock) {
        this.entryPoint = entryPoint;
        this.entryPointNode = entryPointNode;
        this.wm = wm;
        this.ruleBase = (InternalRuleBase)this.wm.getRuleBase();
        this.lock = lock;
        this.typeConfReg = new ObjectTypeConfigurationRegistry(this.ruleBase);
        this.handleFactory = this.wm.getFactHandleFactory();
        this.objectStore = new SingleThreadedObjectStore(this.ruleBase.getConfiguration(), this.lock);
    }

    @Override
    public FactHandle insert(Object object) throws FactException {
        return this.insert(object, false, false, null, null);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) throws FactException {
        return this.insert(object, dynamic, false, null, null);
    }

    protected FactHandle insert(Object object, boolean dynamic, boolean logical, Rule rule, Activation activation) throws FactException {
        if (object == null) {
            return null;
        }
        try {
            this.wm.startOperation();
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object);
            InternalFactHandle handle = this.handleFactory.newFactHandle(object, typeConf, this.wm);
            handle.setEntryPoint(this);
            this.objectStore.addHandle(handle, object);
            if (dynamic) {
                this.addPropertyChangeListener(object);
            }
            try {
                this.lock.lock();
                this.insert(handle, object, rule, activation);
            }
            finally {
                this.lock.unlock();
            }
            InternalFactHandle internalFactHandle = handle;
            return internalFactHandle;
        }
        finally {
            this.wm.endOperation();
        }
    }

    protected void insert(InternalFactHandle handle, Object object, Rule rule, Activation activation) {
        this.ruleBase.executeQueuedActions();
        if (activation != null) {
            activation.getPropagationContext().releaseResources();
        }
        PropagationContextImpl propagationContext = new PropagationContextImpl(this.wm.getNextPropagationIdCounter(), 0, rule, activation == null ? null : (LeftTuple)activation.getTuple(), handle, -1, -1, this.entryPoint);
        this.entryPointNode.assertObject(handle, propagationContext, this.typeConfReg.getObjectTypeConf(this.entryPoint, object), this.wm);
        this.wm.executeQueuedActions();
        this.wm.getWorkingMemoryEventSupport().fireObjectInserted(propagationContext, handle, object, this.wm);
    }

    @Override
    public void update(org.drools.runtime.rule.FactHandle handle, Object object) throws FactException {
        this.update(handle, object, null, null);
    }

    @Override
    public void update(org.drools.runtime.rule.FactHandle factHandle, Object object, Rule rule, Activation activation) throws FactException {
        try {
            this.lock.lock();
            this.ruleBase.executeQueuedActions();
            this.wm.startOperation();
            InternalFactHandle handle = (InternalFactHandle)factHandle;
            Object originalObject = handle.getObject();
            if (handle.getId() == -1 || object == null || handle.isEvent() && ((EventFactHandle)handle).isExpired()) {
                return;
            }
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object);
            if (activation != null) {
                activation.getPropagationContext().releaseResources();
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(this.wm.getNextPropagationIdCounter(), 2, rule, activation == null ? null : (LeftTuple)activation.getTuple(), handle, -1, -1, this.entryPoint);
            this.entryPointNode.retractObject(handle, propagationContext, typeConf, this.wm);
            if (originalObject != object || this.ruleBase.getConfiguration().getAssertBehaviour() != RuleBaseConfiguration.AssertBehaviour.IDENTITY) {
                this.objectStore.removeHandle(handle);
                handle.setObject(object);
                this.objectStore.addHandle(handle, object);
            }
            this.handleFactory.increaseFactHandleRecency(handle);
            this.entryPointNode.assertObject(handle, propagationContext, typeConf, this.wm);
            this.wm.getWorkingMemoryEventSupport().fireObjectUpdated(propagationContext, (FactHandle)factHandle, originalObject, object, this.wm);
            this.wm.executeQueuedActions();
        }
        finally {
            this.wm.endOperation();
            this.lock.unlock();
        }
    }

    @Override
    public void retract(org.drools.runtime.rule.FactHandle handle) throws FactException {
        this.retract((FactHandle)handle, true, true, null, null);
    }

    @Override
    public void retract(FactHandle factHandle, boolean removeLogical, boolean updateEqualsMap, Rule rule, Activation activation) throws FactException {
        try {
            this.lock.lock();
            this.ruleBase.executeQueuedActions();
            this.wm.startOperation();
            InternalFactHandle handle = (InternalFactHandle)factHandle;
            if (handle.getId() == -1) {
                return;
            }
            this.removePropertyChangeListener(handle);
            if (activation != null) {
                activation.getPropagationContext().releaseResources();
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(this.wm.getNextPropagationIdCounter(), 1, rule, activation == null ? null : (LeftTuple)activation.getTuple(), handle, -1, -1, this.entryPoint);
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, handle.getObject());
            this.entryPointNode.retractObject(handle, propagationContext, typeConf, this.wm);
            Object object = handle.getObject();
            this.wm.getWorkingMemoryEventSupport().fireObjectRetracted(propagationContext, handle, object, this.wm);
            this.objectStore.removeHandle(handle);
            this.handleFactory.destroyFactHandle(handle);
            this.wm.executeQueuedActions();
        }
        finally {
            this.wm.endOperation();
            this.lock.unlock();
        }
    }

    public void modifyRetract(FactHandle factHandle) {
        this.modifyRetract(factHandle, null, null);
    }

    public void modifyRetract(FactHandle factHandle, Rule rule, Activation activation) {
        try {
            this.lock.lock();
            this.ruleBase.executeQueuedActions();
            this.wm.startOperation();
            InternalFactHandle handle = (InternalFactHandle)factHandle;
            if (handle.getId() == -1 || handle.isEvent() && ((EventFactHandle)handle).isExpired()) {
                return;
            }
            if (activation != null) {
                activation.getPropagationContext().releaseResources();
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(this.wm.getNextPropagationIdCounter(), 2, rule, activation == null ? null : (LeftTuple)activation.getTuple(), handle, -1, -1, this.entryPoint);
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, handle.getObject());
            this.entryPointNode.retractObject(handle, propagationContext, typeConf, this.wm);
        }
        finally {
            this.wm.endOperation();
            this.lock.unlock();
        }
    }

    public void modifyInsert(FactHandle factHandle, Object object) {
        this.modifyInsert(factHandle, object, null, null);
    }

    public void modifyInsert(FactHandle factHandle, Object object, Rule rule, Activation activation) {
        this.modifyInsert(EntryPoint.DEFAULT, factHandle, object, rule, activation);
    }

    protected void modifyInsert(EntryPoint entryPoint, FactHandle factHandle, Object object, Rule rule, Activation activation) {
        try {
            this.lock.lock();
            this.ruleBase.executeQueuedActions();
            this.wm.startOperation();
            InternalFactHandle handle = (InternalFactHandle)factHandle;
            Object originalObject = handle.getObject();
            if (handle.getId() == -1 || handle.isEvent() && ((EventFactHandle)handle).isExpired()) {
                return;
            }
            this.handleFactory.increaseFactHandleRecency(handle);
            if (activation != null) {
                activation.getPropagationContext().releaseResources();
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(this.wm.getNextPropagationIdCounter(), 2, rule, activation == null ? null : (LeftTuple)activation.getTuple(), handle, -1, -1, entryPoint);
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, handle.getObject());
            this.entryPointNode.assertObject(handle, propagationContext, typeConf, this.wm);
            this.wm.getWorkingMemoryEventSupport().fireObjectUpdated(propagationContext, factHandle, originalObject, object, this.wm);
            this.wm.executeQueuedActions();
        }
        finally {
            this.wm.endOperation();
            this.lock.unlock();
        }
    }

    protected void addPropertyChangeListener(Object object) {
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", AbstractWorkingMemory.ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
            method.invoke(object, this.addRemovePropertyChangeListenerArgs);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Warning: Method addPropertyChangeListener not found on the class " + object.getClass() + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " does not take" + " a simple PropertyChangeListener argument" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalAccessException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " is not public" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (InvocationTargetException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " threw an InvocationTargetException" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a" + " addPropertyChangeListener method" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
    }

    protected void removePropertyChangeListener(FactHandle handle) {
        Object object = null;
        try {
            object = ((InternalFactHandle)handle).getObject();
            if (object != null) {
                Method mehod = object.getClass().getMethod("removePropertyChangeListener", AbstractWorkingMemory.ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
                mehod.invoke(object, this.addRemovePropertyChangeListenerArgs);
            }
        }
        catch (NoSuchMethodException mehod) {
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeDroolsException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " does not take a simple PropertyChangeListener argument so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " is not public so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeDroolsException("Warning: The removePropertyChangeL istener method on the class " + object.getClass() + " threw an InvocationTargetException so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new RuntimeDroolsException("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a removePropertyChangeListener method so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
    }

    @Override
    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        return this.wm.getWorkingMemoryEntryPoint(name);
    }

    @Override
    public ObjectTypeConfigurationRegistry getObjectTypeConfigurationRegistry() {
        return this.typeConfReg;
    }

    @Override
    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public FactHandle getFactHandle(Object object) {
        return this.objectStore.getHandleForObject(object);
    }

    @Override
    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public InternalWorkingMemory getInternalWorkingMemory() {
        return this.wm;
    }

    @Override
    public FactHandle getFactHandleByIdentity(Object object) {
        return this.objectStore.getHandleForObjectIdentity(object);
    }

    public Object getObject(org.drools.runtime.rule.FactHandle factHandle) {
        return this.objectStore.getObjectForHandle((InternalFactHandle)factHandle);
    }

    public <T extends org.drools.runtime.rule.FactHandle> Collection<T> getFactHandles() {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, null, 1);
    }

    public <T extends org.drools.runtime.rule.FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, filter, 1);
    }

    public Collection<Object> getObjects() {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, null, 0);
    }

    public Collection<Object> getObjects(ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, filter, 0);
    }

    public String getEntryPointId() {
        return this.entryPoint.getEntryPointId();
    }

    public long getFactCount() {
        return this.objectStore.size();
    }
}

