/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.common.InternalFactHandle;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;

public class ConcurrentHashTable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    private AbstractHashTable.Index index;
    private int startResult = 31;

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public ConcurrentHashTable(AbstractHashTable.FieldIndex[] index, int initialCapacity, float loadFactor, int concurrencyLevel) {
        int c;
        int i = 0;
        int length = index.length;
        while (i < length) {
            this.startResult = 31 * this.startResult + index[i].getExtractor().getIndex();
            ++i;
        }
        switch (index.length) {
            case 0: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            }
            case 1: {
                this.index = new AbstractHashTable.SingleIndex(index, this.startResult);
                break;
            }
            case 2: {
                this.index = new AbstractHashTable.DoubleCompositeIndex(index, this.startResult);
                break;
            }
            case 3: {
                this.index = new AbstractHashTable.TripleCompositeIndex(index, this.startResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
            }
        }
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        int ssize = 1;
        while (ssize < concurrencyLevel) {
            ++sshift;
            ssize <<= 1;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        int cap = 1;
        while (cap < c) {
            cap <<= 1;
        }
        int i2 = 0;
        while (i2 < this.segments.length) {
            this.segments[i2] = new Segment(this.index, cap, loadFactor);
            ++i2;
        }
    }

    public ConcurrentHashTable(AbstractHashTable.FieldIndex[] index, int initialCapacity, float loadFactor) {
        this(index, initialCapacity, loadFactor, 16);
    }

    public ConcurrentHashTable(AbstractHashTable.FieldIndex[] index, int initialCapacity) {
        this(index, initialCapacity, 0.75f, 16);
    }

    public ConcurrentHashTable(AbstractHashTable.FieldIndex[] index) {
        this(index, 16, 0.75f, 16);
    }

    public boolean isEmpty() {
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        int i = 0;
        while (i < segments.length) {
            if (segments[i].tupleCount != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
            ++i;
        }
        if (mcsum != 0) {
            i = 0;
            while (i < segments.length) {
                if (segments[i].tupleCount != 0 || mc[i] != segments[i].modCount) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int size() {
        Segment[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        int k = 0;
        while (k < 2) {
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            int i = 0;
            while (i < segments.length) {
                sum += (long)segments[i].tupleCount;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                ++i;
            }
            if (mcsum != 0) {
                i = 0;
                while (i < segments.length) {
                    check += (long)segments[i].tupleCount;
                    if (mc[i] != segments[i].modCount) {
                        check = -1L;
                        break;
                    }
                    ++i;
                }
            }
            if (check == sum) break;
            ++k;
        }
        if (check != sum) {
            sum = 0L;
            int i = 0;
            while (i < segments.length) {
                segments[i].lock();
                ++i;
            }
            i = 0;
            while (i < segments.length) {
                sum += (long)segments[i].tupleCount;
                ++i;
            }
            i = 0;
            while (i < segments.length) {
                segments[i].unlock();
                ++i;
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public void add(RightTuple rightTuple) {
        Object object = rightTuple.getFactHandle().getObject();
        int hashCode = this.index.hashCodeOf(object);
        this.segmentFor(hashCode).add(rightTuple, hashCode, object);
    }

    public void remove(RightTuple rightTuple) {
        Object object = rightTuple.getFactHandle().getObject();
        int hashCode = this.index.hashCodeOf(object);
        this.segmentFor(hashCode).remove(rightTuple, hashCode, object);
    }

    public RightTupleList get(LeftTuple tuple, InternalFactHandle factHandle) {
        int hashCode = this.index.hashCodeOf(tuple);
        return this.segmentFor(hashCode).get(hashCode, tuple, factHandle);
    }

    public void clear() {
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i].clear();
            ++i;
        }
    }

    static final class Segment
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int tupleCount;
        volatile transient int keyCount;
        transient int modCount;
        transient int threshold;
        volatile transient RightTupleList[] table;
        final float loadFactor;
        private AbstractHashTable.Index index;

        Segment(AbstractHashTable.Index index, int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(new RightTupleList[initialCapacity]);
            this.index = index;
        }

        static final Segment[] newArray(int i) {
            return new Segment[i];
        }

        void setTable(RightTupleList[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        RightTupleList getFirst(int hash) {
            RightTupleList[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        void add(RightTuple rightTuple, int hashCode, Object object) {
            this.lock();
            try {
                RightTupleList entry = this.getOrCreate(hashCode, object);
                rightTuple.setMemory(entry);
                entry.add(rightTuple);
                ++this.tupleCount;
            }
            finally {
                this.unlock();
            }
        }

        void remove(RightTuple rightTuple, int hashCode, Object object) {
            this.lock();
            try {
                RightTupleList first;
                int c = this.keyCount - 1;
                RightTupleList[] tab = this.table;
                int index = hashCode & tab.length - 1;
                RightTupleList e = first = tab[index];
                while (e != null) {
                    if (e.matches(object, hashCode)) break;
                    e = (RightTupleList)e.next;
                }
                e.remove(rightTuple);
                --this.tupleCount;
                if (e.getFirst(null) == null) {
                    RightTupleList newFirst = (RightTupleList)e.getNext();
                    RightTupleList p = first;
                    while (p != e) {
                        newFirst = new RightTupleList(p.getIndex(), hashCode, newFirst);
                        p = (RightTupleList)p.getNext();
                    }
                    this.keyCount = c;
                }
            }
            finally {
                this.unlock();
            }
        }

        RightTupleList get(int hashCode, LeftTuple tuple, InternalFactHandle factHandle) {
            this.lock();
            try {
                RightTupleList first;
                RightTupleList[] tab = this.table;
                int index = hashCode & tab.length - 1;
                RightTupleList entry = first = tab[index];
                while (entry != null) {
                    if (entry.matches(tuple, hashCode, factHandle)) {
                        RightTupleList rightTupleList = entry;
                        return rightTupleList;
                    }
                    entry = (RightTupleList)entry.getNext();
                }
                RightTupleList rightTupleList = entry;
                return rightTupleList;
            }
            finally {
                this.unlock();
            }
        }

        private RightTupleList getOrCreate(int hashCode, Object object) {
            RightTupleList first;
            int c = this.keyCount;
            RightTupleList[] tab = this.table;
            int index = hashCode & tab.length - 1;
            RightTupleList e = first = tab[index];
            while (e != null) {
                if (e.matches(object, hashCode)) {
                    return e;
                }
                e = (RightTupleList)e.next;
            }
            if (e == null) {
                if (c++ > this.threshold) {
                    this.rehash();
                }
                ++this.modCount;
                tab[index] = e = new RightTupleList(this.index, hashCode, first);
                this.keyCount = c;
            }
            return e;
        }

        void rehash() {
            RightTupleList[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            RightTupleList[] newTable = new RightTupleList[oldCapacity << 1];
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            int i = 0;
            while (i < oldCapacity) {
                RightTupleList e = oldTable[i];
                if (e != null) {
                    RightTupleList next = (RightTupleList)e.getNext();
                    int idx = e.hashCode() & sizeMask;
                    if (next == null) {
                        newTable[idx] = e;
                    } else {
                        int k;
                        RightTupleList lastRun = e;
                        int lastIdx = idx;
                        RightTupleList last = next;
                        while (last != null) {
                            k = last.hashCode() & sizeMask;
                            if (k != lastIdx) {
                                lastIdx = k;
                                lastRun = last;
                            }
                            last = (RightTupleList)last.getNext();
                        }
                        newTable[lastIdx] = lastRun;
                        RightTupleList p = e;
                        while (p != lastRun) {
                            k = p.hashCode() & sizeMask;
                            RightTupleList n = newTable[k];
                            newTable[k] = new RightTupleList(p, n);
                            p = (RightTupleList)p.getNext();
                        }
                    }
                }
                ++i;
            }
            this.table = newTable;
        }

        void clear() {
            if (this.tupleCount != 0) {
                this.lock();
                try {
                    RightTupleList[] tab = this.table;
                    int i = 0;
                    while (i < tab.length) {
                        tab[i] = null;
                        ++i;
                    }
                    ++this.modCount;
                    this.tupleCount = 0;
                    this.keyCount = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }
}

