/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;

public class DroolsStreamUtils {
    public static byte[] streamOut(Object object) throws IOException {
        return DroolsStreamUtils.streamOut(object, false);
    }

    public static byte[] streamOut(Object object, boolean compressed) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DroolsStreamUtils.streamOut(bytes, object, compressed);
        bytes.flush();
        bytes.close();
        return bytes.toByteArray();
    }

    public static void streamOut(OutputStream out, Object object) throws IOException {
        DroolsStreamUtils.streamOut(out, object, false);
    }

    public static void streamOut(OutputStream out, Object object, boolean compressed) throws IOException {
        if (compressed) {
            out = new GZIPOutputStream(out);
        }
        DroolsObjectOutputStream doos = null;
        try {
            doos = new DroolsObjectOutputStream(out);
            doos.writeObject(object);
        }
        finally {
            if (doos != null) {
                doos.close();
            }
            if (compressed) {
                out.close();
            }
        }
    }

    public static Object streamIn(byte[] bytes) throws IOException, ClassNotFoundException {
        return DroolsStreamUtils.streamIn(bytes, null);
    }

    public static Object streamIn(byte[] bytes, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        return DroolsStreamUtils.streamIn(bytes, classLoader, false);
    }

    public static Object streamIn(byte[] bytes, boolean compressed) throws IOException, ClassNotFoundException {
        return DroolsStreamUtils.streamIn(new ByteArrayInputStream(bytes), null, compressed);
    }

    public static Object streamIn(byte[] bytes, ClassLoader classLoader, boolean compressed) throws IOException, ClassNotFoundException {
        return DroolsStreamUtils.streamIn(new ByteArrayInputStream(bytes), classLoader, compressed);
    }

    public static Object streamIn(InputStream in) throws IOException, ClassNotFoundException {
        return DroolsStreamUtils.streamIn(in, null, false);
    }

    public static Object streamIn(InputStream in, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        return DroolsStreamUtils.streamIn(in, classLoader, false);
    }

    public static Object streamIn(InputStream in, ClassLoader classLoader, boolean compressed) throws IOException, ClassNotFoundException {
        if (compressed) {
            in = new GZIPInputStream(in);
        }
        return new DroolsObjectInputStream(in, classLoader).readObject();
    }
}

