/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.drools.core.util.CompositeCollection;

public class PrimitiveLongMap
implements Externalizable {
    private static final long serialVersionUID = 400L;
    private static final Object NULL = new Serializable(){
        private static final long serialVersionUID = 400L;
    };
    private int indexIntervals;
    private int intervalShifts;
    private int midIntervalPoint;
    private int tableSize;
    private int shifts;
    private int doubleShifts;
    private Page firstPage;
    private Page lastPage;
    private int lastPageId;
    private long maxKey;
    private Page[] pageIndex;
    private int totalSize;

    public PrimitiveLongMap() {
        this(32, 8);
    }

    public PrimitiveLongMap(int tableSize) {
        this(tableSize, 8);
    }

    public PrimitiveLongMap(int tableSize, int indexIntervals) {
        int i = 1;
        int size = 2;
        while (size < indexIntervals) {
            size <<= 1;
            ++i;
        }
        this.indexIntervals = size;
        this.intervalShifts = i;
        i = 1;
        size = 2;
        while (size < tableSize) {
            size <<= 1;
            ++i;
        }
        this.tableSize = size;
        this.shifts = i;
        this.doubleShifts = this.shifts << 1;
        this.midIntervalPoint = this.tableSize << this.shifts << this.intervalShifts >> 1;
        this.lastPageId = 0;
        this.init();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.indexIntervals = in.readInt();
        this.intervalShifts = in.readInt();
        this.midIntervalPoint = in.readInt();
        this.tableSize = in.readInt();
        this.shifts = in.readInt();
        this.doubleShifts = in.readInt();
        this.firstPage = (Page)in.readObject();
        this.lastPage = (Page)in.readObject();
        this.lastPageId = in.readInt();
        this.maxKey = in.readLong();
        this.pageIndex = (Page[])in.readObject();
        this.totalSize = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.indexIntervals);
        out.writeInt(this.intervalShifts);
        out.writeInt(this.midIntervalPoint);
        out.writeInt(this.tableSize);
        out.writeInt(this.shifts);
        out.writeInt(this.doubleShifts);
        out.writeObject(this.firstPage);
        out.writeObject(this.lastPage);
        out.writeInt(this.lastPageId);
        out.writeLong(this.maxKey);
        out.writeObject(this.pageIndex);
        out.writeInt(this.totalSize);
    }

    private void init() {
        this.firstPage = new Page(null, this.lastPageId, this.tableSize);
        this.maxKey = this.lastPageId + 1 << this.doubleShifts;
        this.pageIndex = new Page[]{this.firstPage};
        this.lastPage = this.firstPage;
    }

    public void clear() {
        this.init();
    }

    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    public Object put(long key, Object value) {
        Page page;
        Object oldValue;
        if (key < 0L) {
            throw new IllegalArgumentException("-ve keys not supported: " + key);
        }
        if (value == null) {
            value = NULL;
        }
        if ((oldValue = (page = this.findPage(key)).put(key, value)) == null) {
            ++this.totalSize;
        }
        return oldValue;
    }

    public Object remove(long key) {
        if (key > this.maxKey || key < 0L) {
            return null;
        }
        Page page = this.findPage(key);
        Object oldValue = page.put(key, null);
        if (this.lastPageId != 0 && this.lastPage.isEmpty()) {
            this.shrinkPages(this.lastPageId);
        }
        if (oldValue != null) {
            --this.totalSize;
        }
        return oldValue;
    }

    public Object get(long key) {
        if (key > this.maxKey || key < 0L) {
            return null;
        }
        Object value = this.findPage(key).get(key);
        if (value == NULL) {
            value = null;
        }
        return value;
    }

    public long getNext(long key) {
        int currentPageId = (int)key >> this.doubleShifts;
        int nextPageId = (int)(key + 1L) >> this.doubleShifts;
        if (currentPageId != nextPageId) {
            Page page = this.findPage(key + 1L);
            while (page.isEmpty()) {
                page = page.getNextSibling();
            }
            key = this.doubleShifts << page.getPageId();
        } else {
            ++key;
        }
        while (!this.containsKey(key) && key <= this.maxKey) {
            ++key;
        }
        if (key > this.maxKey) {
            --key;
        }
        return key;
    }

    public int size() {
        return this.totalSize;
    }

    public Collection values() {
        CompositeCollection collection = new CompositeCollection();
        Page page = this.firstPage;
        while (page != null && page.getPageId() <= this.lastPageId) {
            collection.addComposited(Arrays.asList(page.getValues()));
            page = page.getNextSibling();
        }
        return collection;
    }

    public boolean containsKey(long key) {
        if (key < 0L) {
            return false;
        }
        return this.get(key) != null;
    }

    public Page expandPages(int toPageId) {
        int x = this.lastPageId;
        while (x < toPageId) {
            this.lastPage = new Page(this.lastPage, ++this.lastPageId, this.tableSize);
            if (this.lastPage.getPageId() % this.indexIntervals == 0) {
                int newSize = this.pageIndex.length + 1;
                this.resizeIndex(newSize);
                this.pageIndex[newSize - 1] = this.lastPage;
            }
            ++x;
        }
        this.maxKey = (this.lastPageId + 1 << this.doubleShifts) - 1;
        return this.lastPage;
    }

    public void shrinkPages(int toPageId) {
        int x = this.lastPageId;
        while (x >= toPageId) {
            if (this.lastPageId % this.indexIntervals == 0 && this.lastPageId != 0) {
                this.resizeIndex(this.pageIndex.length - 1);
            }
            Page page = this.lastPage.getPreviousSibling();
            page.setNextSibling(null);
            this.lastPage.clear();
            this.lastPage = page;
            this.lastPageId = page.getPageId();
            --x;
        }
    }

    public void resizeIndex(int newSize) {
        Page[] newIndex = new Page[newSize];
        System.arraycopy(this.pageIndex, 0, newIndex, 0, newSize > this.pageIndex.length ? this.pageIndex.length : newSize);
        this.pageIndex = newIndex;
    }

    private Page findPage(long key) {
        Page page;
        int pageId = (int)key >> this.doubleShifts;
        if (pageId == this.lastPageId) {
            page = this.lastPage;
        } else if (pageId == 0) {
            page = this.firstPage;
        } else if (pageId > this.lastPageId) {
            page = this.expandPages(pageId);
        } else {
            int offset = pageId >> this.intervalShifts;
            if (offset != this.pageIndex.length - 1 && key - (long)(offset << this.intervalShifts << this.doubleShifts) > (long)this.midIntervalPoint) {
                page = this.pageIndex[offset + 1];
                while (page.getPageId() != pageId) {
                    page = page.getPreviousSibling();
                }
            } else {
                page = this.pageIndex[offset];
                while (page.getPageId() != pageId) {
                    page = page.getNextSibling();
                }
            }
        }
        return page;
    }

    public static class Page
    implements Externalizable {
        private static final long serialVersionUID = 400L;
        private int pageSize;
        private int pageId;
        private int shifts;
        private int tableSize;
        private Page nextSibling;
        private Page previousSibling;
        private Object[][] tables;
        private int filledSlots;

        public Page() {
        }

        Page(Page previousSibling, int pageId, int tableSize) {
            int i = 1;
            int size = 2;
            while (size < tableSize) {
                size <<= 1;
                ++i;
            }
            this.tableSize = size;
            this.shifts = i;
            this.previousSibling = previousSibling;
            if (this.previousSibling != null) {
                this.previousSibling.setNextSibling(this);
            }
            this.pageId = pageId;
            this.pageSize = tableSize << this.shifts;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.pageSize = in.readInt();
            this.pageId = in.readInt();
            this.shifts = in.readInt();
            this.tableSize = in.readInt();
            this.nextSibling = (Page)in.readObject();
            this.previousSibling = (Page)in.readObject();
            this.tables = (Object[][])in.readObject();
            this.filledSlots = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.pageSize);
            out.writeInt(this.pageId);
            out.writeInt(this.shifts);
            out.writeInt(this.tableSize);
            out.writeObject(this.nextSibling);
            out.writeObject(this.previousSibling);
            out.writeObject(this.tables);
            out.writeInt(this.filledSlots);
        }

        public int getPageId() {
            return this.pageId;
        }

        void setNextSibling(Page nextSibling) {
            this.nextSibling = nextSibling;
        }

        public Page getNextSibling() {
            return this.nextSibling;
        }

        void setPreviousSibling(Page previousSibling) {
            this.previousSibling = previousSibling;
        }

        public Page getPreviousSibling() {
            return this.previousSibling;
        }

        public Object get(long key) {
            if (this.tables == null) {
                return null;
            }
            int table = (int)(key -= (long)(this.pageSize * this.pageId)) >> this.shifts;
            int offset = table << this.shifts;
            return this.tables[table][(int)key - offset];
        }

        public Object put(long key, Object newValue) {
            if (this.tables == null) {
                this.tables = new Object[this.tableSize][this.tableSize];
            }
            int table = (int)(key -= (long)(this.pageSize * this.pageId)) >> this.shifts;
            int offset = table << this.shifts;
            int slot = (int)key - offset;
            Object oldValue = this.tables[table][slot];
            this.tables[table][slot] = newValue;
            if (oldValue == null && newValue != null) {
                ++this.filledSlots;
            } else if (oldValue != null && newValue == null) {
                --this.filledSlots;
            }
            if (this.filledSlots == 0) {
                this.tables = null;
            }
            return oldValue;
        }

        Object[][] getTables() {
            return this.tables;
        }

        Object[] getValues() {
            Object[] values = new Object[this.filledSlots];
            if (values.length == 0) {
                return values;
            }
            int x = 0;
            int i = 0;
            while (i < this.tableSize) {
                int j = 0;
                while (j < this.tableSize) {
                    Object value = this.tables[i][j];
                    if (value != null) {
                        if (value == NULL) {
                            value = null;
                        }
                        values[x] = value;
                        ++x;
                    }
                    ++j;
                }
                ++i;
            }
            return values;
        }

        public boolean isEmpty() {
            return this.filledSlots == 0;
        }

        void clear() {
            this.previousSibling = null;
            this.nextSibling = null;
            this.tables = null;
        }
    }
}

