/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.InternalFactHandle;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;

public class RightTupleIndexHashTable
extends AbstractHashTable
implements RightTupleMemory {
    private static final long serialVersionUID = 400L;
    public static final int PRIME = 31;
    private transient FieldIndexHashTableFullIterator tupleValueFullIterator;
    private int startResult;
    private int factSize;
    private AbstractHashTable.Index index;

    public RightTupleIndexHashTable() {
    }

    public RightTupleIndexHashTable(AbstractHashTable.FieldIndex[] index) {
        this(128, 0.75f, index);
    }

    public RightTupleIndexHashTable(int capacity, float loadFactor, AbstractHashTable.FieldIndex[] index) {
        super(capacity, loadFactor);
        this.startResult = 31;
        int i = 0;
        int length = index.length;
        while (i < length) {
            this.startResult += 31 * this.startResult + index[i].getExtractor().getIndex();
            ++i;
        }
        switch (index.length) {
            case 0: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            }
            case 1: {
                this.index = new AbstractHashTable.SingleIndex(index, this.startResult);
                break;
            }
            case 2: {
                this.index = new AbstractHashTable.DoubleCompositeIndex(index, this.startResult);
                break;
            }
            case 3: {
                this.index = new AbstractHashTable.TripleCompositeIndex(index, this.startResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.startResult = in.readInt();
        this.factSize = in.readInt();
        this.index = (AbstractHashTable.Index)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.startResult);
        out.writeInt(this.factSize);
        out.writeObject(this.index);
    }

    public RightTuple getFirst(LeftTuple leftTuple, InternalFactHandle factHandle) {
        RightTupleList bucket = this.get(leftTuple, factHandle);
        if (bucket != null) {
            return bucket.first;
        }
        return null;
    }

    public RightTuple getFirst(RightTuple rightTuple) {
        RightTupleList bucket = this.get(rightTuple.getFactHandle().getObject());
        if (bucket != null) {
            return bucket.getFirst(null);
        }
        return null;
    }

    public RightTuple getLast(LeftTuple leftTuple) {
        RightTupleList bucket = this.get(leftTuple);
        if (bucket != null) {
            return bucket.last;
        }
        return null;
    }

    public boolean isIndexed() {
        return true;
    }

    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    public Entry getBucket(Object object) {
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        return this.table[index];
    }

    public Iterator iterator() {
        if (this.tupleValueFullIterator == null) {
            this.tupleValueFullIterator = new FieldIndexHashTableFullIterator(this);
        }
        this.tupleValueFullIterator.reset();
        return this.tupleValueFullIterator;
    }

    public Entry[] toArray() {
        Entry[] result = new Entry[this.factSize];
        int index = 0;
        int i = 0;
        while (i < this.table.length) {
            RightTupleList bucket = (RightTupleList)this.table[i];
            while (bucket != null) {
                Entry entry = bucket.first;
                while (entry != null) {
                    result[index++] = entry;
                    entry = entry.getNext();
                }
                bucket = (RightTupleList)bucket.next;
            }
            ++i;
        }
        return result;
    }

    public void add(RightTuple rightTuple) {
        RightTupleList entry = this.getOrCreate(rightTuple.getFactHandle().getObject());
        rightTuple.setMemory(entry);
        entry.add(rightTuple);
        ++this.factSize;
    }

    public void remove(RightTuple rightTuple) {
        if (rightTuple.getMemory() != null) {
            RightTupleList memory = rightTuple.getMemory();
            memory.remove(rightTuple);
            --this.factSize;
            if (memory.first == null) {
                int index = this.indexOf(memory.hashCode(), this.table.length);
                RightTupleList previous = null;
                RightTupleList current = (RightTupleList)this.table[index];
                while (current != memory) {
                    previous = current;
                    current = (RightTupleList)current.getNext();
                }
                if (previous != null) {
                    previous.next = current.next;
                } else {
                    this.table[index] = current.next;
                }
                --this.size;
            }
            return;
        }
        Object object = rightTuple.getFactHandle().getObject();
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        RightTupleList previous = null;
        RightTupleList current = (RightTupleList)this.table[index];
        while (current != null) {
            if (current.matches(object, hashCode)) {
                current.remove(rightTuple);
                --this.factSize;
                if (current.first != null) break;
                if (previous != null) {
                    previous.next = current.next;
                } else {
                    this.table[index] = current.next;
                }
                --this.size;
                break;
            }
            previous = current;
            current = (RightTupleList)current.next;
        }
        rightTuple.setNext(null);
        rightTuple.setPrevious(null);
    }

    public boolean contains(RightTuple rightTuple) {
        Object object = rightTuple.getFactHandle().getObject();
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        RightTupleList current = (RightTupleList)this.table[index];
        while (current != null) {
            if (current.matches(object, hashCode)) {
                return true;
            }
            current = (RightTupleList)current.next;
        }
        return false;
    }

    public RightTupleList get(LeftTuple tuple, InternalFactHandle factHandle) {
        int hashCode = this.index.hashCodeOf(tuple);
        int index = this.indexOf(hashCode, this.table.length);
        RightTupleList entry = (RightTupleList)this.table[index];
        while (entry != null) {
            if (entry.matches(tuple, hashCode, factHandle)) {
                return entry;
            }
            entry = (RightTupleList)entry.getNext();
        }
        return entry;
    }

    private RightTupleList getOrCreate(Object object) {
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        RightTupleList entry = (RightTupleList)this.table[index];
        while (entry != null) {
            if (entry.matches(object, hashCode)) {
                return entry;
            }
            entry = (RightTupleList)entry.next;
        }
        if (entry == null) {
            entry = new RightTupleList(this.index, hashCode);
            entry.next = this.table[index];
            this.table[index] = entry;
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length);
            }
        }
        return entry;
    }

    private RightTupleList get(Object object) {
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        RightTupleList entry = (RightTupleList)this.table[index];
        while (entry != null) {
            if (entry.matches(object, hashCode)) {
                return entry;
            }
            entry = (RightTupleList)entry.next;
        }
        return entry;
    }

    public int size() {
        return this.factSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Entry[] entryArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                RightTupleList bucket = (RightTupleList)entry;
                RightTuple rightTuple = bucket.getFirst(null);
                while (rightTuple != null) {
                    builder.append(rightTuple);
                    rightTuple = (RightTuple)rightTuple.getNext();
                }
                entry = entry.getNext();
            }
            ++n2;
        }
        return builder.toString();
    }

    public static class FieldIndexHashTableFullIterator
    implements Iterator {
        private AbstractHashTable hashTable;
        private Entry[] table;
        private int row;
        private int length;
        private RightTupleList list;
        private RightTuple rightTuple;

        public FieldIndexHashTableFullIterator(AbstractHashTable hashTable) {
            this.hashTable = hashTable;
        }

        public Object next() {
            do {
                if (this.list == null) {
                    while (this.list == null) {
                        this.list = (RightTupleList)this.table[this.row];
                        ++this.row;
                        if (this.list != null) {
                            this.rightTuple = this.list.getFirst(null);
                            return this.rightTuple;
                        }
                        if (this.row != this.length) continue;
                        return null;
                    }
                }
                this.rightTuple = (RightTuple)this.rightTuple.getNext();
                if (this.rightTuple != null) {
                    return this.rightTuple;
                }
                this.list = (RightTupleList)this.list.getNext();
            } while (this.list == null);
            this.rightTuple = this.list.getFirst(null);
            return this.rightTuple;
        }

        public void remove() {
            throw new UnsupportedOperationException("FieldIndexHashTableFullIterator does not support remove().");
        }

        public void reset() {
            this.table = this.hashTable.getTable();
            this.length = this.table.length;
            this.row = 0;
            this.list = null;
            this.rightTuple = null;
        }
    }
}

