/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.asm;

import java.util.List;
import org.mvel2.asm.AnnotationVisitor;
import org.mvel2.asm.Attribute;
import org.mvel2.asm.ClassReader;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.util.TraceMethodVisitor;

public class MethodComparator {
    public boolean equivalent(String method1, ClassReader class1, String method2, ClassReader class2) {
        List list1 = this.getMethodBytecode(method1, class1);
        List list2 = this.getMethodBytecode(method2, class2);
        return MethodComparator.compareBytecode(list1, list2);
    }

    public List getMethodBytecode(String methodName, ClassReader classReader) {
        Tracer visit = new Tracer(methodName);
        classReader.accept((ClassVisitor)visit, 2);
        TraceMethodVisitor trace = visit.getTrace();
        return trace.getText();
    }

    public static List getMethodBytecode(String methodName, byte[] bytes) {
        Tracer visit = new Tracer(methodName);
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)visit, 2);
        TraceMethodVisitor trace = visit.getTrace();
        return trace.getText();
    }

    public static boolean compareBytecode(List b1, List b2) {
        if (b1.size() != b2.size()) {
            return false;
        }
        int i = 0;
        while (i < b1.size()) {
            if (!b1.get(i).equals(b2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static class DummyAnnotationVisitor
    implements AnnotationVisitor {
        DummyAnnotationVisitor() {
        }

        public void visit(String name, Object value) {
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new DummyAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String name) {
            return new DummyAnnotationVisitor();
        }

        public void visitEnd() {
        }

        public void visitEnum(String name, String desc, String value) {
        }
    }

    public static class Tracer
    implements ClassVisitor {
        private TraceMethodVisitor trace;
        private String methodName;

        public Tracer(String methodName) {
            this.methodName = methodName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new DummyAnnotationVisitor();
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.methodName.equals(name)) {
                this.trace = new TraceMethodVisitor();
                return this.trace;
            }
            return null;
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public void visitSource(String source, String debug) {
        }

        public TraceMethodVisitor getTrace() {
            return this.trace;
        }
    }
}

