/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.drools.common.NetworkNode;
import org.drools.common.RuleBasePartitionId;
import org.drools.core.util.debug.NodeInfo;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.Rete;
import org.drools.rule.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNodeInfo
implements NodeInfo {
    private NetworkNode node;
    private Set<Rule> rules;
    private boolean memoryEnabled = false;
    private long tupleMemorySize = -1L;
    private long factMemorySize = -1L;
    private long createdFactHandles = -1L;
    private long actionQueueSize = -1L;

    public DefaultNodeInfo(NetworkNode node) {
        this.node = node;
        this.rules = new HashSet<Rule>();
    }

    public void assign(Rule rule) {
        this.rules.add(rule);
    }

    @Override
    public Set<Rule> getRules() {
        return this.rules;
    }

    @Override
    public int getId() {
        return this.node.getId();
    }

    @Override
    public RuleBasePartitionId getPartitionId() {
        return this.node.getPartitionId();
    }

    @Override
    public long getTupleMemorySize() {
        return this.tupleMemorySize;
    }

    public void setTupleMemorySize(long leftMemorySize) {
        this.tupleMemorySize = leftMemorySize;
    }

    @Override
    public long getFactMemorySize() {
        return this.factMemorySize;
    }

    public void setFactMemorySize(long rightMemorySize) {
        this.factMemorySize = rightMemorySize;
    }

    @Override
    public long getCreatedFactHandles() {
        return this.createdFactHandles;
    }

    public void setCreatedFactHandles(long createdFactHandles) {
        this.createdFactHandles = createdFactHandles;
    }

    public long getActionQueueSize() {
        return this.actionQueueSize;
    }

    public void setActionQueueSize(long size) {
        this.actionQueueSize = size;
    }

    @Override
    public NetworkNode getNode() {
        return this.node;
    }

    @Override
    public boolean isMemoryEnabled() {
        return this.memoryEnabled;
    }

    public void setMemoryEnabled(boolean memoryEnabled) {
        this.memoryEnabled = memoryEnabled;
    }

    @Override
    public Collection<? extends NetworkNode> getSinkList() {
        if (this.node instanceof Rete) {
            Rete rete = (Rete)this.node;
            return rete.getEntryPointNodes().values();
        }
        if (this.node instanceof EntryPointNode) {
            EntryPointNode epn = (EntryPointNode)this.node;
            return epn.getObjectTypeNodes().values();
        }
        if (this.node instanceof ObjectSource) {
            ArrayList<ObjectSink> result = new ArrayList<ObjectSink>();
            ObjectSink[] objectSinkArray = ((ObjectSource)this.node).getSinkPropagator().getSinks();
            int n = objectSinkArray.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectSink sink = objectSinkArray[n2];
                result.add(sink);
                ++n2;
            }
            return result;
        }
        if (this.node instanceof LeftTupleSource) {
            ArrayList<LeftTupleSink> result = new ArrayList<LeftTupleSink>();
            LeftTupleSource source = (LeftTupleSource)this.node;
            LeftTupleSink[] leftTupleSinkArray = source.getSinkPropagator().getSinks();
            int n = leftTupleSinkArray.length;
            int n3 = 0;
            while (n3 < n) {
                LeftTupleSink sink = leftTupleSinkArray[n3];
                result.add(sink);
                ++n3;
            }
            return result;
        }
        return Collections.emptyList();
    }
}

