/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.InitialFact;
import org.drools.base.ClassObjectType;
import org.drools.common.AgendaItem;
import org.drools.common.DefaultAgenda;
import org.drools.common.EqualityKey;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.LogicalDependency;
import org.drools.common.NodeMemory;
import org.drools.common.ObjectStore;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.common.WorkingMemoryAction;
import org.drools.core.util.LinkedList;
import org.drools.core.util.ObjectHashMap;
import org.drools.core.util.ObjectHashSet;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ObjectMarshallingStrategyStore;
import org.drools.marshalling.impl.ProcessMarshallerRegistry;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.impl.ProcessInstanceImpl;
import org.drools.process.instance.timer.TimerInstance;
import org.drools.process.instance.timer.TimerManager;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.EntryPoint;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaGroup;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleFlowGroup;

public class OutputMarshaller {
    public static void writeSession(MarshallerWriteContext context) throws IOException {
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        boolean multithread = wm.isPartitionManagersActive();
        if (multithread) {
            context.writeBoolean(true);
            wm.stopPartitionManagers();
        } else {
            context.writeBoolean(false);
        }
        context.writeInt(wm.getFactHandleFactory().getId());
        context.writeLong(wm.getFactHandleFactory().getRecency());
        InternalFactHandle handle = context.wm.getInitialFactHandle();
        context.writeInt(handle.getId());
        context.writeLong(handle.getRecency());
        context.writeLong(wm.getPropagationIdCounter());
        OutputMarshaller.writeAgenda(context);
        OutputMarshaller.writeFactHandles(context);
        OutputMarshaller.writeActionQueue(context);
        if (wm.getTruthMaintenanceSystem() != null) {
            context.writeBoolean(true);
            OutputMarshaller.writeTruthMaintenanceSystem(context);
        } else {
            context.writeBoolean(false);
        }
        if (context.marshalProcessInstances) {
            OutputMarshaller.writeProcessInstances(context);
        }
        if (context.marshalWorkItems) {
            OutputMarshaller.writeWorkItems(context);
        }
        OutputMarshaller.writeTimers(context);
        if (multithread) {
            wm.startPartitionManagers();
        }
    }

    public static void writeAgenda(MarshallerWriteContext context) throws IOException {
        InternalWorkingMemory wm = context.wm;
        DefaultAgenda agenda = (DefaultAgenda)wm.getAgenda();
        Map<String, ActivationGroup> activationGroups = agenda.getActivationGroupsMap();
        AgendaGroup[] agendaGroups = agenda.getAgendaGroupsMap().values().toArray(new AgendaGroup[agenda.getAgendaGroupsMap().size()]);
        Arrays.sort(agendaGroups, AgendaGroupSorter.instance);
        AgendaGroup[] agendaGroupArray = agendaGroups;
        int n = agendaGroups.length;
        int n2 = 0;
        while (n2 < n) {
            AgendaGroup group = agendaGroupArray[n2];
            context.writeShort(13);
            context.writeUTF(group.getName());
            context.writeBoolean(group.isActive());
            ++n2;
        }
        context.writeShort(1);
        java.util.LinkedList<AgendaGroup> focusStack = agenda.getStackList();
        for (AgendaGroup group : focusStack) {
            context.writeShort(13);
            context.writeUTF(group.getName());
        }
        context.writeShort(1);
        RuleFlowGroupImpl[] ruleFlowGroups = agenda.getRuleFlowGroupsMap().values().toArray(new RuleFlowGroupImpl[agenda.getRuleFlowGroupsMap().size()]);
        Arrays.sort(ruleFlowGroups, RuleFlowGroupSorter.instance);
        RuleFlowGroupImpl[] ruleFlowGroupImplArray = ruleFlowGroups;
        int n3 = ruleFlowGroups.length;
        int n4 = 0;
        while (n4 < n3) {
            RuleFlowGroupImpl group = ruleFlowGroupImplArray[n4];
            context.writeShort(15);
            context.writeUTF(group.getName());
            context.writeBoolean(group.isActive());
            context.writeBoolean(group.isAutoDeactivate());
            Map<Long, String> nodeInstances = group.getNodeInstances();
            context.writeInt(nodeInstances.size());
            for (Map.Entry<Long, String> entry : nodeInstances.entrySet()) {
                context.writeLong(entry.getKey());
                context.writeUTF(entry.getValue());
            }
            ++n4;
        }
        context.writeShort(1);
    }

    public static void writeActionQueue(MarshallerWriteContext context) throws IOException {
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        WorkingMemoryAction[] queue = wm.getActionQueue().toArray(new WorkingMemoryAction[wm.getActionQueue().size()]);
        int i = queue.length - 1;
        while (i >= 0) {
            context.writeShort(10);
            queue[i].write(context);
            --i;
        }
        context.writeShort(1);
    }

    public static void writeTruthMaintenanceSystem(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        ObjectHashMap assertMap = context.wm.getTruthMaintenanceSystem().getAssertMap();
        EqualityKey[] keys = new EqualityKey[assertMap.size()];
        org.drools.core.util.Iterator it = assertMap.iterator();
        int i = 0;
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            EqualityKey key = (EqualityKey)entry.getKey();
            keys[i++] = key;
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
        Arrays.sort(keys, EqualityKeySorter.instance);
        EqualityKey[] equalityKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            EqualityKey key = equalityKeyArray[n2];
            stream.writeShort(11);
            stream.writeInt(key.getStatus());
            InternalFactHandle handle = key.getFactHandle();
            stream.writeInt(handle.getId());
            if (key.getOtherFactHandle() != null && !key.getOtherFactHandle().isEmpty()) {
                for (InternalFactHandle handle2 : key.getOtherFactHandle()) {
                    stream.writeShort(2);
                    stream.writeInt(handle2.getId());
                }
            }
            stream.writeShort(1);
            ++n2;
        }
        stream.writeShort(1);
    }

    public static void writeFactHandles(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        ObjectMarshallingStrategyStore objectMarshallingStrategyStore = context.objectMarshallingStrategyStore;
        OutputMarshaller.writeInitialFactHandleRightTuples(context);
        stream.writeInt(wm.getObjectStore().size());
        InternalFactHandle[] internalFactHandleArray = OutputMarshaller.orderFacts(wm.getObjectStore());
        int n = internalFactHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalFactHandle handle = internalFactHandleArray[n2];
            OutputMarshaller.writeFactHandle(context, stream, objectMarshallingStrategyStore, handle);
            OutputMarshaller.writeRightTuples(handle, context);
            ++n2;
        }
        OutputMarshaller.writeInitialFactHandleLeftTuples(context);
        OutputMarshaller.writeLeftTuples(context);
        OutputMarshaller.writePropagationContexts(context);
        OutputMarshaller.writeActivations(context);
    }

    private static void writeFactHandle(MarshallerWriteContext context, ObjectOutputStream stream, ObjectMarshallingStrategyStore objectMarshallingStrategyStore, InternalFactHandle handle) throws IOException {
        stream.writeInt(handle.getId());
        stream.writeLong(handle.getRecency());
        Object object = handle.getObject();
        int index = objectMarshallingStrategyStore.getStrategy(object);
        ObjectMarshallingStrategy strategy = objectMarshallingStrategyStore.getStrategy(index);
        stream.writeInt(index);
        strategy.write(stream, object);
        if (handle.getEntryPoint() instanceof InternalWorkingMemoryEntryPoint) {
            String entryPoint = ((InternalWorkingMemoryEntryPoint)handle.getEntryPoint()).getEntryPoint().getEntryPointId();
            if (entryPoint != null && !entryPoint.equals("")) {
                stream.writeBoolean(true);
                stream.writeUTF(entryPoint);
            } else {
                stream.writeBoolean(false);
            }
        } else {
            stream.writeBoolean(false);
        }
    }

    public static InternalFactHandle[] orderFacts(ObjectStore objectStore) {
        int size = objectStore.size();
        InternalFactHandle[] handles = new InternalFactHandle[size];
        int i = 0;
        Iterator it = objectStore.iterateFactHandles();
        while (it.hasNext()) {
            handles[i++] = (InternalFactHandle)it.next();
        }
        Arrays.sort(handles, new HandleSorter());
        return handles;
    }

    public static void writeInitialFactHandleRightTuples(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        ObjectTypeNode initialFactNode = ruleBase.getRete().getEntryPointNode(EntryPoint.DEFAULT).getObjectTypeNodes().get(new ClassObjectType(InitialFact.class));
        if (initialFactNode != null) {
            ObjectHashSet initialFactMemory = (ObjectHashSet)context.wm.getNodeMemory(initialFactNode);
            if (initialFactMemory != null && !initialFactMemory.isEmpty()) {
                stream.writeBoolean(true);
                stream.writeInt(initialFactNode.getId());
                OutputMarshaller.writeRightTuples(context.wm.getInitialFactHandle(), context);
            } else {
                stream.writeBoolean(false);
            }
        } else {
            stream.writeBoolean(false);
        }
    }

    public static void writeInitialFactHandleLeftTuples(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalFactHandle handle = context.wm.getInitialFactHandle();
        LeftTuple leftTuple = handle.getFirstLeftTuple();
        while (leftTuple != null) {
            stream.writeShort(3);
            stream.writeInt(leftTuple.getLeftTupleSink().getId());
            OutputMarshaller.writeLeftTuple(leftTuple, context, true);
            leftTuple = leftTuple.getLeftParentNext();
        }
        stream.writeShort(1);
    }

    public static void writeRightTuples(InternalFactHandle handle, MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        RightTuple rightTuple = handle.getFirstRightTuple();
        while (rightTuple != null) {
            stream.writeShort(4);
            OutputMarshaller.writeRightTuple(rightTuple, context);
            rightTuple = rightTuple.getHandleNext();
        }
        stream.writeShort(1);
    }

    public static void writeRightTuple(RightTuple rightTuple, MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        stream.writeInt(rightTuple.getRightTupleSink().getId());
    }

    public static void writeLeftTuples(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        InternalFactHandle[] internalFactHandleArray = OutputMarshaller.orderFacts(wm.getObjectStore());
        int n = internalFactHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalFactHandle handle = internalFactHandleArray[n2];
            LeftTuple leftTuple = handle.getFirstLeftTuple();
            while (leftTuple != null) {
                stream.writeShort(3);
                stream.writeInt(leftTuple.getLeftTupleSink().getId());
                stream.writeInt(handle.getId());
                OutputMarshaller.writeLeftTuple(leftTuple, context, true);
                leftTuple = leftTuple.getLeftParentNext();
            }
            ++n2;
        }
        stream.writeShort(1);
    }

    public static void writeLeftTuple(LeftTuple leftTuple, MarshallerWriteContext context, boolean recurse) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        InternalWorkingMemory wm = context.wm;
        LeftTupleSink sink = leftTuple.getLeftTupleSink();
        switch (sink.getType()) {
            case 0: {
                LeftTuple childLeftTuple = leftTuple.firstChild;
                while (childLeftTuple != null) {
                    stream.writeShort(4);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    stream.writeInt(childLeftTuple.getRightParent().getFactHandle().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
                stream.writeShort(1);
                break;
            }
            case 3: {
                LeftTuple childLeftTuple = leftTuple.firstChild;
                while (childLeftTuple != null) {
                    stream.writeShort(3);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
                stream.writeShort(1);
                break;
            }
            case 1: 
            case 10: {
                if (leftTuple.getBlocker() == null) {
                    stream.writeShort(7);
                    LeftTuple childLeftTuple = leftTuple.firstChild;
                    while (childLeftTuple != null) {
                        stream.writeShort(3);
                        stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                        OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                        childLeftTuple = leftTuple.getLeftParentNext();
                    }
                    stream.writeShort(1);
                    break;
                }
                stream.writeShort(6);
                stream.writeInt(leftTuple.getBlocker().getFactHandle().getId());
                break;
            }
            case 2: {
                if (leftTuple.getBlocker() == null) {
                    stream.writeShort(7);
                    break;
                }
                stream.writeShort(6);
                stream.writeInt(leftTuple.getBlocker().getFactHandle().getId());
                LeftTuple childLeftTuple = leftTuple.firstChild;
                while (childLeftTuple != null) {
                    stream.writeShort(3);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                    childLeftTuple = leftTuple.getLeftParentNext();
                }
                stream.writeShort(1);
                break;
            }
            case 6: {
                AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)context.wm.getNodeMemory((BetaNode)sink);
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
                OutputMarshaller.writeFactHandle(context, stream, context.objectMarshallingStrategyStore, accctx.result.getFactHandle());
                stream.writeObject(accctx.context);
                stream.writeBoolean(accctx.propagated);
                LeftTuple childLeftTuple = leftTuple.firstChild;
                while (childLeftTuple != null) {
                    if (leftTuple.getLeftTupleSink().getId() == childLeftTuple.getLeftTupleSink().getId()) {
                        stream.writeShort(4);
                        stream.writeInt(childLeftTuple.getRightParent().getFactHandle().getId());
                    } else {
                        stream.writeShort(3);
                        stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                        OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                    }
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
                stream.writeShort(1);
                break;
            }
            case 7: {
                ObjectHashMap memory = (ObjectHashMap)context.wm.getNodeMemory((NodeMemory)((Object)sink));
                InternalFactHandle ifh = (InternalFactHandle)memory.get(leftTuple);
                stream.writeInt(ifh.getId());
                stream.writeLong(ifh.getRecency());
                OutputMarshaller.writeRightTuples(ifh, context);
                stream.writeShort(1);
                break;
            }
            case 9: {
                int pos = context.terminalTupleMap.size();
                context.terminalTupleMap.put(leftTuple, pos);
            }
        }
    }

    public static void writeActivations(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        Map.Entry[] entries = context.terminalTupleMap.entrySet().toArray(new Map.Entry[context.terminalTupleMap.size()]);
        Arrays.sort(entries, TupleSorter.instance);
        if (entries.length != 0) {
            Map.Entry[] entryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                Map.Entry entry = entryArray[n2];
                if (((LeftTuple)entry.getKey()).getObject() != null) {
                    LeftTuple leftTuple = (LeftTuple)entry.getKey();
                    stream.writeShort(8);
                    OutputMarshaller.writeActivation(context, leftTuple, (AgendaItem)leftTuple.getObject(), (RuleTerminalNode)leftTuple.getLeftTupleSink());
                }
                ++n2;
            }
        }
        stream.writeShort(1);
    }

    public static void writeActivation(MarshallerWriteContext context, LeftTuple leftTuple, AgendaItem agendaItem, RuleTerminalNode ruleTerminalNode) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(agendaItem.getActivationNumber());
        stream.writeInt(context.terminalTupleMap.get(leftTuple));
        stream.writeInt(agendaItem.getSalience());
        Rule rule = agendaItem.getRule();
        stream.writeUTF(rule.getPackage());
        stream.writeUTF(rule.getName());
        stream.writeLong(agendaItem.getPropagationContext().getPropagationNumber());
        if (agendaItem.getActivationGroupNode() != null) {
            stream.writeBoolean(true);
            stream.writeUTF(agendaItem.getActivationGroupNode().getActivationGroup().getName());
        } else {
            stream.writeBoolean(false);
        }
        stream.writeBoolean(agendaItem.isActivated());
        LinkedList list = agendaItem.getLogicalDependencies();
        if (list != null && !list.isEmpty()) {
            LogicalDependency node = (LogicalDependency)list.getFirst();
            while (node != null) {
                stream.writeShort(12);
                stream.writeInt(((InternalFactHandle)node.getFactHandle()).getId());
                node = (LogicalDependency)node.getNext();
            }
        }
        stream.writeShort(1);
    }

    public static void writePropagationContexts(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        Map.Entry[] entries = context.terminalTupleMap.entrySet().toArray(new Map.Entry[context.terminalTupleMap.size()]);
        Arrays.sort(entries, TupleSorter.instance);
        if (entries.length != 0) {
            HashMap<Long, PropagationContext> pcMap = new HashMap<Long, PropagationContext>();
            Map.Entry[] entryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                PropagationContext pc;
                Map.Entry entry = entryArray[n2];
                LeftTuple leftTuple = (LeftTuple)entry.getKey();
                if (leftTuple.getObject() != null && !pcMap.containsKey((pc = ((Activation)leftTuple.getObject()).getPropagationContext()).getPropagationNumber())) {
                    stream.writeShort(9);
                    OutputMarshaller.writePropagationContext(context, pc);
                    pcMap.put(pc.getPropagationNumber(), pc);
                }
                ++n2;
            }
        }
        stream.writeShort(1);
    }

    public static void writePropagationContext(MarshallerWriteContext context, PropagationContext pc) throws IOException {
        MarshallerWriteContext stream = context.stream;
        Map<LeftTuple, Integer> tuples = context.terminalTupleMap;
        stream.writeInt(pc.getType());
        Rule ruleOrigin = pc.getRuleOrigin();
        if (ruleOrigin != null) {
            stream.writeBoolean(true);
            stream.writeUTF(ruleOrigin.getPackage());
            stream.writeUTF(ruleOrigin.getName());
        } else {
            stream.writeBoolean(false);
        }
        LeftTuple tupleOrigin = pc.getLeftTupleOrigin();
        if (tupleOrigin != null && tuples.containsKey(tupleOrigin)) {
            stream.writeBoolean(true);
            stream.writeInt(tuples.get(tupleOrigin));
        } else {
            stream.writeBoolean(false);
        }
        stream.writeLong(pc.getPropagationNumber());
        if (pc.getFactHandleOrigin() != null) {
            stream.writeInt(((InternalFactHandle)pc.getFactHandleOrigin()).getId());
        } else {
            stream.writeInt(-1);
        }
        stream.writeInt(pc.getActiveActivations());
        stream.writeInt(pc.getDormantActivations());
        stream.writeUTF(pc.getEntryPoint().getEntryPointId());
    }

    public static void writeProcessInstances(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>(context.wm.getProcessInstances());
        Collections.sort(processInstances, new Comparator<org.drools.runtime.process.ProcessInstance>(){

            @Override
            public int compare(org.drools.runtime.process.ProcessInstance o1, org.drools.runtime.process.ProcessInstance o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        for (org.drools.runtime.process.ProcessInstance processInstance : processInstances) {
            stream.writeShort(17);
            String processType = ((ProcessInstanceImpl)processInstance).getProcess().getType();
            stream.writeUTF(processType);
            ProcessMarshallerRegistry.INSTANCE.getMarshaller(processType).writeProcessInstance(context, processInstance);
        }
        stream.writeShort(1);
    }

    public static void writeWorkItems(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(context.wm.getWorkItemManager().getWorkItems());
        Collections.sort(workItems, new Comparator<org.drools.runtime.process.WorkItem>(){

            @Override
            public int compare(org.drools.runtime.process.WorkItem o1, org.drools.runtime.process.WorkItem o2) {
                return (int)(o2.getId() - o1.getId());
            }
        });
        for (org.drools.runtime.process.WorkItem workItem : workItems) {
            stream.writeShort(19);
            OutputMarshaller.writeWorkItem(context, workItem);
        }
        stream.writeShort(1);
    }

    public static void writeWorkItem(MarshallerWriteContext context, org.drools.runtime.process.WorkItem workItem) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(workItem.getId());
        stream.writeLong(workItem.getProcessInstanceId());
        stream.writeUTF(workItem.getName());
        stream.writeInt(workItem.getState());
        Map parameters = workItem.getParameters();
        stream.writeInt(parameters.size());
        for (Map.Entry entry : parameters.entrySet()) {
            stream.writeUTF((String)entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    public static void writeTimers(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        TimerManager timerManager = context.wm.getTimerManager();
        long timerId = timerManager.internalGetTimerId();
        stream.writeLong(timerId);
        ArrayList<TimerInstance> timers = new ArrayList<TimerInstance>(timerManager.getTimers());
        Collections.sort(timers, new Comparator<TimerInstance>(){

            @Override
            public int compare(TimerInstance o1, TimerInstance o2) {
                return (int)(o2.getId() - o1.getId());
            }
        });
        for (TimerInstance timer : timers) {
            stream.writeShort(29);
            OutputMarshaller.writeTimer(context, timer);
        }
        stream.writeShort(1);
    }

    public static void writeTimer(MarshallerWriteContext context, TimerInstance timer) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(timer.getId());
        stream.writeLong(timer.getTimerId());
        stream.writeLong(timer.getDelay());
        stream.writeLong(timer.getPeriod());
        stream.writeLong(timer.getProcessInstanceId());
        stream.writeLong(timer.getActivated().getTime());
        Date lastTriggered = timer.getLastTriggered();
        if (lastTriggered != null) {
            stream.writeBoolean(true);
            stream.writeLong(timer.getLastTriggered().getTime());
        } else {
            stream.writeBoolean(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AgendaGroupSorter
    implements Comparator<AgendaGroup> {
        public static final AgendaGroupSorter instance = new AgendaGroupSorter();

        @Override
        public int compare(AgendaGroup group1, AgendaGroup group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EqualityKeySorter
    implements Comparator<EqualityKey> {
        public static final EqualityKeySorter instance = new EqualityKeySorter();

        @Override
        public int compare(EqualityKey key1, EqualityKey key2) {
            return key1.getFactHandle().getId() - key2.getFactHandle().getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandleSorter
    implements Comparator<InternalFactHandle> {
        @Override
        public int compare(InternalFactHandle h1, InternalFactHandle h2) {
            return h1.getId() - h2.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleFlowGroupSorter
    implements Comparator<RuleFlowGroup> {
        public static final RuleFlowGroupSorter instance = new RuleFlowGroupSorter();

        @Override
        public int compare(RuleFlowGroup group1, RuleFlowGroup group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TupleSorter
    implements Comparator<Map.Entry<LeftTuple, Integer>> {
        public static final TupleSorter instance = new TupleSorter();

        @Override
        public int compare(Map.Entry<LeftTuple, Integer> e1, Map.Entry<LeftTuple, Integer> e2) {
            return e1.getValue() - e2.getValue();
        }
    }
}

