/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.instance.impl.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.drools.process.instance.impl.demo.UIWorkItemHandlerDialog;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIWorkItemHandler
extends JFrame
implements WorkItemHandler {
    private static final long serialVersionUID = 400L;
    private Map<WorkItem, WorkItemManager> workItems = new HashMap<WorkItem, WorkItemManager>();
    private JList workItemsList;
    private JButton selectButton;

    public UIWorkItemHandler() {
        this.setSize(new Dimension(400, 300));
        this.setTitle("Work Items");
        this.setDefaultCloseOperation(2);
        this.initializeComponent();
    }

    private void initializeComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.getRootPane().setLayout(new BorderLayout());
        this.getRootPane().add((Component)panel, "Center");
        this.workItemsList = new JList();
        this.workItemsList.setSelectionMode(0);
        this.workItemsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UIWorkItemHandler.this.select();
                }
            }
        });
        this.workItemsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                UIWorkItemHandler.this.selectButton.setEnabled(UIWorkItemHandler.this.getSelectedWorkItem() != null);
            }
        });
        this.reloadWorkItemsList();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.workItemsList, c);
        this.selectButton = new JButton("Select");
        this.selectButton.setEnabled(false);
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                UIWorkItemHandler.this.select();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.selectButton, c);
    }

    private void select() {
        WorkItem workItem = this.getSelectedWorkItem();
        if (workItem != null) {
            UIWorkItemHandlerDialog dialog = new UIWorkItemHandlerDialog(this, workItem);
            dialog.setVisible(true);
        }
    }

    public WorkItem getSelectedWorkItem() {
        Object selected;
        int index = this.workItemsList.getSelectedIndex();
        if (index != -1 && (selected = this.workItemsList.getModel().getElementAt(index)) instanceof WorkItemWrapper) {
            return ((WorkItemWrapper)selected).getWorkItem();
        }
        return null;
    }

    private void reloadWorkItemsList() {
        ArrayList<WorkItemWrapper> result = new ArrayList<WorkItemWrapper>();
        for (WorkItem workItem : this.workItems.keySet()) {
            result.add(new WorkItemWrapper(workItem));
        }
        this.workItemsList.setListData(result.toArray());
    }

    public void complete(WorkItem workItem, Map<String, Object> results) {
        WorkItemManager manager = this.workItems.get(workItem);
        if (manager != null) {
            manager.completeWorkItem(workItem.getId(), results);
            this.workItems.remove(workItem);
            this.reloadWorkItemsList();
        }
        this.selectButton.setEnabled(this.getSelectedWorkItem() != null);
    }

    public void abort(WorkItem workItem) {
        WorkItemManager manager = this.workItems.get(workItem);
        if (manager != null) {
            manager.abortWorkItem(workItem.getId());
            this.workItems.remove(workItem);
            this.reloadWorkItemsList();
        }
        this.selectButton.setEnabled(this.getSelectedWorkItem() != null);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.workItems.remove(workItem);
        this.reloadWorkItemsList();
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.workItems.put(workItem, manager);
        this.reloadWorkItemsList();
    }

    private class WorkItemWrapper {
        private WorkItem workItem;

        public WorkItemWrapper(WorkItem workItem) {
            this.workItem = workItem;
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }

        public String toString() {
            return String.valueOf(this.workItem.getName()) + " [" + this.workItem.getId() + "]";
        }
    }
}

