/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.base.DroolsQuery;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.Iterator;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.spi.PropagationContext;

public class ExistsNode
extends BetaNode {
    private static final long serialVersionUID = 400L;
    static int notAssertObject = 0;
    static int notAssertTuple = 0;

    public ExistsNode() {
    }

    public ExistsNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, Behavior[] behaviors, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, joinNodeBinder, behaviors);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        boolean useLeftMemory = true;
        if (!this.tupleMemoryEnabled) {
            Object object = ((InternalFactHandle)context.getFactHandle()).getObject();
            if (memory.getLeftTupleMemory() == null || object instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
                useLeftMemory = false;
            }
        }
        RightTuple rightTuple = memory.getRightTupleMemory().getFirst(leftTuple, (InternalFactHandle)context.getFactHandle());
        while (rightTuple != null) {
            if (this.constraints.isAllowedCachedLeft(memory.getContext(), rightTuple.getFactHandle())) {
                leftTuple.setBlocker(rightTuple);
                if (!useLeftMemory) break;
                rightTuple.addBlocked(leftTuple);
                break;
            }
            rightTuple = (RightTuple)rightTuple.getNext();
        }
        this.constraints.resetTuple(memory.getContext());
        if (leftTuple.getBlocker() != null) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, useLeftMemory);
        } else if (useLeftMemory) {
            memory.getLeftTupleMemory().add(leftTuple);
        }
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple rightTuple = new RightTuple(factHandle, this);
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!this.behavior.assertRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory)) {
            rightTuple.unlinkFromRightParent();
            return;
        }
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, factHandle);
        LeftTuple leftTuple = memory.getLeftTupleMemory().getFirst(rightTuple);
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)leftTuple.getNext();
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                memory.getLeftTupleMemory().remove(leftTuple);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
            }
            leftTuple = temp;
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple rootBlocker = (RightTuple)rightTuple.getNext();
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        this.behavior.retractRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory);
        memory.getRightTupleMemory().remove(rightTuple);
        if (rightTuple.getBlocked() == null) {
            return;
        }
        LeftTuple leftTuple = rightTuple.getBlocked();
        while (leftTuple != null) {
            LeftTuple temp = leftTuple.getBlockedNext();
            leftTuple.setBlocker(null);
            leftTuple.setBlockedPrevious(null);
            leftTuple.setBlockedNext(null);
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            RightTuple newBlocker = rootBlocker;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)newBlocker.getNext();
            }
            if (leftTuple.getBlocker() == null) {
                memory.getLeftTupleMemory().add(leftTuple);
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
            leftTuple = temp;
        }
        rightTuple.nullBlocked();
        this.constraints.resetTuple(memory.getContext());
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple blocker = leftTuple.getBlocker();
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (blocker != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            blocker.removeBlocked(leftTuple);
        } else {
            memory.getLeftTupleMemory().remove(leftTuple);
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            memory.getLeftTupleMemory().remove(leftTuple);
        } else if (rightMemory.isIndexed() && rightMemory.getFirst(blocker) != rightMemory.getFirst(leftTuple, (InternalFactHandle)context.getFactHandle())) {
            blocker.removeBlocked(leftTuple);
            leftTuple.setBlocker(null);
            leftTuple.setBlockedPrevious(null);
            leftTuple.setBlockedNext(null);
            blocker = null;
        }
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        if (blocker == null || !this.constraints.isAllowedCachedLeft(memory.getContext(), blocker.getFactHandle())) {
            RightTuple rightTuple;
            if (blocker != null) {
                blocker.removeBlocked(leftTuple);
                leftTuple.setBlocker(null);
                leftTuple.setBlockedPrevious(null);
                leftTuple.setBlockedNext(null);
            }
            RightTuple newBlocker = rightTuple = rightMemory.getFirst(leftTuple, (InternalFactHandle)context.getFactHandle());
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)newBlocker.getNext();
            }
            if (leftTuple.getBlocker() == null) {
                memory.getLeftTupleMemory().add(leftTuple);
                if (leftTuple.firstChild != null) {
                    this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
                }
            } else if (leftTuple.firstChild == null) {
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
            } else {
                this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, true);
            }
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0 && rightTuple.getBlocked() == null) {
            memory.getRightTupleMemory().remove(rightTuple);
            memory.getRightTupleMemory().add(rightTuple);
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        LeftTuple firstLeftTuple = leftMemory.getFirst(rightTuple);
        LeftTuple firstBlocked = rightTuple.getBlocked();
        rightTuple.nullBlocked();
        LeftTuple leftTuple = firstLeftTuple;
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)leftTuple.getNext();
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                leftMemory.remove(leftTuple);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
            }
            leftTuple = temp;
        }
        if (firstBlocked != null) {
            RightTuple rootBlocker = (RightTuple)rightTuple.getNext();
            LeftTuple leftTuple2 = firstBlocked;
            while (leftTuple2 != null) {
                LeftTuple temp = leftTuple2.getBlockedNext();
                leftTuple2.setBlockedPrevious(null);
                leftTuple2.setBlockedNext(null);
                if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple2)) {
                    rightTuple.addBlocked(leftTuple2);
                    leftTuple2 = temp;
                    continue;
                }
                leftTuple2.setBlocker(null);
                this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple2);
                RightTuple newBlocker = rootBlocker;
                while (newBlocker != null) {
                    if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                        leftTuple2.setBlocker(newBlocker);
                        newBlocker.addBlocked(leftTuple2);
                        break;
                    }
                    newBlocker = (RightTuple)newBlocker.getNext();
                }
                if (leftTuple2.getBlocker() == null) {
                    memory.getLeftTupleMemory().add(leftTuple2);
                    this.sink.propagateRetractLeftTuple(leftTuple2, context, workingMemory);
                }
                leftTuple2 = temp;
            }
        }
        this.constraints.resetFactHandle(memory.getContext());
        this.constraints.resetTuple(memory.getContext());
        memory.getRightTupleMemory().remove(rightTuple);
        memory.getRightTupleMemory().add(rightTuple);
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.getRightTupleMemory().iterator();
        RightTuple rightTuple = (RightTuple)it.next();
        while (rightTuple != null) {
            LeftTuple leftTuple = rightTuple.getBlocked();
            while (leftTuple != null) {
                sink.assertLeftTuple(new LeftTuple(leftTuple, sink, true), context, workingMemory);
                leftTuple = leftTuple.getBlockedNext();
            }
            rightTuple = (RightTuple)it.next();
        }
    }

    public String toString() {
        ObjectSource source = this.rightInput;
        while (source != null && source.getClass() != ObjectTypeNode.class) {
            source = source.source;
        }
        return "[ExistsNode(" + this.getId() + ") - " + (source != null ? ((ObjectTypeNode)source).getObjectType() : "<source from a subnetwork>") + "]";
    }

    public short getType() {
        return 2;
    }
}

