/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.WorkingMemoryAction;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;

public class PropagationQueuingNode
extends ObjectSource
implements ObjectSinkNode,
NodeMemory {
    private static final long serialVersionUID = -615639068150958767L;
    private static final int PROPAGATION_SLICE_LIMIT = 1000;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    private PropagateAction action;

    public PropagationQueuingNode() {
    }

    public PropagationQueuingNode(int id, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.action = new PropagateAction(this);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.previousObjectSinkNode = (ObjectSinkNode)in.readObject();
        this.nextObjectSinkNode = (ObjectSinkNode)in.readObject();
        this.action = (PropagateAction)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.previousObjectSinkNode);
        out.writeObject(this.nextObjectSinkNode);
        out.writeObject(this.action);
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        if (!memory.isEmpty()) {
            throw new RuntimeDroolsException("Error updating sink. Not safe to update sink as the PropagatingQueueingNode memory is not for node: " + this.toString());
        }
        this.source.updateSink(sink, context, workingMemory);
    }

    public void attach() {
        this.source.addObjectSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
    }

    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public boolean isObjectMemoryEnabled() {
        return true;
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        memory.addAction(new AssertAction(factHandle, context));
        if (memory.isQueued().compareAndSet(false, true)) {
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        memory.addAction(new RetractAction(handle, context));
        if (memory.isQueued().compareAndSet(false, true)) {
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        memory.addAction(new ModifyAction(factHandle, modifyPreviousTuples, context));
        if (memory.isQueued().compareAndSet(false, true)) {
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    public void propagateActions(InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        memory.isQueued().compareAndSet(true, false);
        Action next = memory.getNext();
        int counter = 0;
        while (next != null && counter < 1000) {
            next.execute(this.sink, workingMemory);
            next = memory.getNext();
            ++counter;
        }
        if (memory.hasNext() && memory.isQueued().compareAndSet(false, true)) {
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    public void setObjectMemoryEnabled(boolean objectMemoryOn) {
        throw new UnsupportedOperationException("PropagationQueueingNode must have its node memory enabled.");
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new PropagationQueueingNodeMemory();
    }

    private static abstract class Action
    implements Externalizable {
        protected InternalFactHandle handle;
        protected PropagationContext context;

        public Action(InternalFactHandle handle, PropagationContext context) {
            this.handle = handle;
            this.context = context;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.handle);
            out.writeObject(this.context);
        }

        public abstract void execute(ObjectSinkPropagator var1, InternalWorkingMemory var2);
    }

    private static class AssertAction
    extends Action {
        private static final long serialVersionUID = -8478488926430845209L;

        public AssertAction(InternalFactHandle handle, PropagationContext context) {
            super(handle, context);
        }

        public void execute(ObjectSinkPropagator sink, InternalWorkingMemory workingMemory) {
            sink.propagateAssertObject(this.handle, this.context, workingMemory);
        }
    }

    private static class ModifyAction
    extends Action {
        private static final long serialVersionUID = -8478488926430845209L;
        private ModifyPreviousTuples modifyPreviousTuples;

        public ModifyAction(InternalFactHandle handle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context) {
            super(handle, context);
            this.modifyPreviousTuples = modifyPreviousTuples;
        }

        public void execute(ObjectSinkPropagator sink, InternalWorkingMemory workingMemory) {
            sink.propagateModifyObject(this.handle, this.modifyPreviousTuples, this.context, workingMemory);
        }
    }

    public static class PropagateAction
    implements WorkingMemoryAction {
        private static final long serialVersionUID = 6765029029501617115L;
        private PropagationQueuingNode node;

        public PropagateAction() {
        }

        public PropagateAction(PropagationQueuingNode node) {
            this.node = node;
        }

        public PropagateAction(MarshallerReaderContext context) throws IOException {
            this.node = (PropagationQueuingNode)context.sinks.get(context.readInt());
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeInt(3);
            context.write(this.node.getId());
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.node = (PropagationQueuingNode)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.node);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.node.propagateActions(workingMemory);
        }
    }

    public static class PropagationQueueingNodeMemory
    implements Externalizable {
        private static final long serialVersionUID = 7372028632974484023L;
        private ConcurrentLinkedQueue<Action> queue = new ConcurrentLinkedQueue();
        private AtomicBoolean isQueued = new AtomicBoolean(false);

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.queue = (ConcurrentLinkedQueue)in.readObject();
            this.isQueued = (AtomicBoolean)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.queue);
            out.writeObject(this.isQueued);
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void addAction(Action action) {
            this.queue.add(action);
        }

        public Action getNext() {
            return this.queue.poll();
        }

        public boolean hasNext() {
            return this.queue.peek() != null;
        }

        public AtomicBoolean isQueued() {
            return this.isQueued;
        }

        public long getSize() {
            return this.queue.size();
        }
    }

    private static class RetractAction
    extends Action {
        private static final long serialVersionUID = -84784886430845209L;

        public RetractAction(InternalFactHandle handle, PropagationContext context) {
            super(handle, context);
        }

        public void execute(ObjectSinkPropagator sink, InternalWorkingMemory workingMemory) {
            RightTuple rightTuple = this.handle.getFirstRightTuple();
            while (rightTuple != null) {
                rightTuple.getRightTupleSink().retractRightTuple(rightTuple, this.context, workingMemory);
                rightTuple = rightTuple.getHandleNext();
            }
            this.handle.setFirstRightTuple(null);
            LeftTuple leftTuple = this.handle.getLastLeftTuple();
            while (leftTuple != null) {
                leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, this.context, workingMemory);
                leftTuple = leftTuple.getLeftParentNext();
            }
            this.handle.setFirstLeftTuple(null);
        }
    }
}

