/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.compiled;

import org.drools.base.ClassFieldReader;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashMap;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.CompositeLeftTupleSinkAdapter;
import org.drools.reteoo.CompositeObjectSinkAdapter;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkPropagator;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSinkNodeList;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.SingleLeftTupleSinkAdapter;
import org.drools.reteoo.SingleObjectSinkAdapter;
import org.drools.reteoo.compiled.NetworkHandler;
import org.drools.rule.LiteralConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;

public class ObjectTypeNodeParser {
    private final ObjectTypeNode objectTypeNode;

    public ObjectTypeNodeParser(ObjectTypeNode objectTypeNode) {
        this.objectTypeNode = objectTypeNode;
    }

    public void accept(NetworkHandler handler) {
        ObjectSinkPropagator propagator = this.objectTypeNode.getSinkPropagator();
        handler.startObjectTypeNode(this.objectTypeNode);
        this.traversePropagator(propagator, handler);
        handler.endObjectTypeNode(this.objectTypeNode);
    }

    private void traversePropagator(ObjectSinkPropagator propagator, NetworkHandler handler) {
        if (propagator instanceof SingleObjectSinkAdapter) {
            ObjectSink sink = propagator.getSinks()[0];
            this.traverseSink(sink, handler);
        } else if (propagator instanceof CompositeObjectSinkAdapter) {
            CompositeObjectSinkAdapter composite = (CompositeObjectSinkAdapter)propagator;
            this.traverseSinkLisk(composite.getHashableSinks(), handler);
            this.traverseSinkLisk(composite.getOthers(), handler);
            this.traverseHashedAlphaNodes(composite.getHashedSinkMap(), handler);
        }
    }

    private void traversePropagator(LeftTupleSinkPropagator propagator, NetworkHandler handler) {
        if (propagator instanceof SingleLeftTupleSinkAdapter) {
            LeftTupleSink sink = propagator.getSinks()[0];
            this.traverseSink(sink, handler);
        } else if (propagator instanceof CompositeLeftTupleSinkAdapter) {
            CompositeLeftTupleSinkAdapter composite = (CompositeLeftTupleSinkAdapter)propagator;
            LeftTupleSink[] sinks = composite.getSinks();
            this.traverseSinkLisk(sinks, handler);
        }
    }

    private void traverseSinkLisk(ObjectSinkNodeList sinks, NetworkHandler handler) {
        if (sinks != null) {
            ObjectSinkNode sink = sinks.getFirst();
            while (sink != null) {
                this.traverseSink(sink, handler);
                sink = sink.getNextObjectSinkNode();
            }
        }
    }

    private void traverseSinkLisk(LeftTupleSink[] sinks, NetworkHandler handler) {
        if (sinks != null) {
            int sinkIndex = 0;
            while (sinkIndex < sinks.length) {
                this.traverseSink(sinks[sinkIndex], handler);
                ++sinkIndex;
            }
        }
    }

    private void traverseHashedAlphaNodes(ObjectHashMap hashedAlphaNodes, NetworkHandler handler) {
        if (hashedAlphaNodes != null && hashedAlphaNodes.size() > 0) {
            AlphaNode firstAlpha = this.getFirstAlphaNode(hashedAlphaNodes);
            ClassFieldReader hashedFieldReader = this.getClassFieldReaderForHashedAlpha(firstAlpha);
            handler.startHashedAlphaNodes(hashedFieldReader);
            Iterator iter = hashedAlphaNodes.iterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)iter.next();
            while (entry != null) {
                CompositeObjectSinkAdapter.HashKey hashKey = (CompositeObjectSinkAdapter.HashKey)entry.getKey();
                AlphaNode alphaNode = (AlphaNode)entry.getValue();
                handler.startHashedAlphaNode(alphaNode, hashKey.getObjectValue());
                this.traversePropagator(alphaNode.getSinkPropagator(), handler);
                handler.endHashedAlphaNode(alphaNode, hashKey.getObjectValue());
                entry = (ObjectHashMap.ObjectEntry)iter.next();
            }
            handler.endHashedAlphaNodes(hashedFieldReader);
        }
    }

    private void traverseSink(ObjectSink sink, NetworkHandler handler) {
        if (sink instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)sink;
            handler.startNonHashedAlphaNode(alphaNode);
            this.traversePropagator(alphaNode.getSinkPropagator(), handler);
            handler.endNonHashedAlphaNode(alphaNode);
        } else if (sink instanceof BetaNode) {
            BetaNode betaNode = (BetaNode)sink;
            handler.startBetaNode(betaNode);
            handler.endBetaNode(betaNode);
        } else if (sink instanceof LeftInputAdapterNode) {
            LeftInputAdapterNode leftInputAdapterNode = (LeftInputAdapterNode)sink;
            handler.startLeftInputAdapterNode(leftInputAdapterNode);
            handler.endLeftInputAdapterNode(leftInputAdapterNode);
        }
    }

    private void traverseSink(LeftTupleSink sink, NetworkHandler handler) {
    }

    private AlphaNode getFirstAlphaNode(ObjectHashMap hashedAlphaNodes) throws IllegalArgumentException {
        Iterator iter = hashedAlphaNodes.iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)iter.next();
        if (entry == null) {
            throw new IllegalArgumentException("ObjectHashMap does not contain any hashed AlphaNodes!");
        }
        AlphaNode firstAlphaNode = (AlphaNode)entry.getValue();
        return firstAlphaNode;
    }

    private ClassFieldReader getClassFieldReaderForHashedAlpha(AlphaNode alphaNode) throws IllegalArgumentException {
        AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
        if (!(fieldConstraint instanceof LiteralConstraint)) {
            throw new IllegalArgumentException("Only support LiteralConstraint hashed AlphaNodes, not " + fieldConstraint.getClass());
        }
        LiteralConstraint literalConstraint = (LiteralConstraint)alphaNode.getConstraint();
        return (ClassFieldReader)literalConstraint.getFieldExtractor();
    }
}

