/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.compiled;

import org.drools.common.NetworkNode;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Sink;
import org.drools.reteoo.compiled.AbstractCompilerHandler;

class SetNodeReferenceHandler
extends AbstractCompilerHandler {
    private static final String PARAM_TYPE = NetworkNode.class.getName();
    private static final String PARAM_NAME = "node";
    private static final String SET_NETWORK_NODE_REFERENCE_SIGNATURE = "protected void setNetworkNodeReference(" + PARAM_TYPE + " " + "node" + "){";
    private final StringBuilder builder;

    SetNodeReferenceHandler(StringBuilder builder) {
        this.builder = builder;
    }

    private String getVariableAssignmentStatement(Sink sink, String nodeVariableName) {
        Class<?> variableType = this.getVariableType(sink);
        String assignmentStatement = String.valueOf(this.getVariableName(sink)) + " = (" + variableType.getName() + ")" + nodeVariableName + ";";
        return assignmentStatement;
    }

    private String getVariableAssignmentStatement(AlphaNode alphaNode, String nodeVariableName) {
        Class<?> variableType = this.getVariableType(alphaNode);
        String assignmentStatement = String.valueOf(this.getVariableName(alphaNode)) + " = (" + variableType.getName() + ") ((" + AlphaNode.class.getName() + ")" + nodeVariableName + ").getConstraint();";
        return assignmentStatement;
    }

    private String getContextVariableAssignmentStatement(AlphaNode alphaNode) {
        String contextVariableName = this.getContextVariableName(alphaNode);
        String alphaVariableName = this.getVariableName(alphaNode);
        String assignmentStatement = String.valueOf(contextVariableName) + " = " + alphaVariableName + ".createContextEntry();";
        return assignmentStatement;
    }

    public void startObjectTypeNode(ObjectTypeNode objectTypeNode) {
        this.builder.append(SET_NETWORK_NODE_REFERENCE_SIGNATURE).append("\n");
        this.builder.append("switch (").append(PARAM_NAME).append(".getId()) {").append("\n");
    }

    public void endObjectTypeNode(ObjectTypeNode objectTypeNode) {
        this.builder.append("}").append("\n");
        this.builder.append("}").append("\n");
    }

    public void startNonHashedAlphaNode(AlphaNode alphaNode) {
        this.builder.append("case ").append(alphaNode.getId()).append(": ").append("\n");
        this.builder.append(this.getVariableAssignmentStatement(alphaNode, PARAM_NAME)).append("\n");
        this.builder.append(this.getContextVariableAssignmentStatement(alphaNode)).append("\n");
        this.builder.append("break;").append("\n");
    }

    public void startBetaNode(BetaNode betaNode) {
        this.builder.append("case ").append(betaNode.getId()).append(": ").append("\n");
        this.builder.append(this.getVariableAssignmentStatement(betaNode, PARAM_NAME)).append("\n");
        this.builder.append("break;").append("\n");
    }

    public void startLeftInputAdapterNode(LeftInputAdapterNode leftInputAdapterNode) {
        this.builder.append("case ").append(leftInputAdapterNode.getId()).append(": ").append("\n");
        this.builder.append(this.getVariableAssignmentStatement(leftInputAdapterNode, PARAM_NAME)).append("\n");
        this.builder.append("break;").append("\n");
    }
}

