/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashSet;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.spi.Restriction;

public abstract class AbstractCompositeRestriction
implements Restriction {
    private static final long serialVersionUID = 400L;
    protected Restriction[] restrictions;

    public AbstractCompositeRestriction() {
    }

    public AbstractCompositeRestriction(Restriction[] restriction) {
        this.restrictions = restriction;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.restrictions = (Restriction[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.restrictions);
    }

    public Declaration[] getRequiredDeclarations() {
        HashSet<Declaration> set = new HashSet<Declaration>();
        int i = 0;
        int ilength = this.restrictions.length;
        while (i < ilength) {
            Declaration[] declarations = this.restrictions[i].getRequiredDeclarations();
            int j = 0;
            int jlength = declarations.length;
            while (j < jlength) {
                set.add(declarations[j]);
                ++j;
            }
            ++i;
        }
        return set.toArray(new Declaration[set.size()]);
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        int i = 0;
        while (i < this.restrictions.length) {
            this.restrictions[i].replaceDeclaration(oldDecl, newDecl);
            ++i;
        }
    }

    public boolean isTemporal() {
        boolean temporal = false;
        Restriction[] restrictionArray = this.restrictions;
        int n = this.restrictions.length;
        int n2 = 0;
        while (n2 < n) {
            Restriction r = restrictionArray[n2];
            if (r.isTemporal()) {
                temporal = true;
                break;
            }
            ++n2;
        }
        return temporal;
    }

    private static int hashCode(Object[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + AbstractCompositeRestriction.hashCode(this.restrictions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj instanceof AbstractCompositeRestriction) {
            return false;
        }
        AbstractCompositeRestriction other = (AbstractCompositeRestriction)obj;
        return Arrays.equals(this.restrictions, other.restrictions);
    }

    public ContextEntry createContextEntry() {
        return new CompositeContextEntry(this.restrictions);
    }

    public abstract Object clone();

    public static class CompositeContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = -1773986268630111227L;
        public ContextEntry[] contextEntries;
        private ContextEntry entry;

        public CompositeContextEntry() {
        }

        public CompositeContextEntry(Restriction[] restrictions) {
            this.contextEntries = new ContextEntry[restrictions.length];
            int i = 0;
            while (i < restrictions.length) {
                this.contextEntries[i] = restrictions[i].createContextEntry();
                ++i;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.contextEntries = (ContextEntry[])in.readObject();
            this.entry = (ContextEntry)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.contextEntries);
            out.writeObject(this.entry);
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            int i = 0;
            int length = this.contextEntries.length;
            while (i < length) {
                this.contextEntries[i].updateFromFactHandle(workingMemory, handle);
                ++i;
            }
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            int i = 0;
            int length = this.contextEntries.length;
            while (i < length) {
                this.contextEntries[i].updateFromTuple(workingMemory, tuple);
                ++i;
            }
        }

        public void resetTuple() {
            int i = 0;
            int length = this.contextEntries.length;
            while (i < length) {
                this.contextEntries[i].resetTuple();
                ++i;
            }
        }

        public void resetFactHandle() {
            int i = 0;
            int length = this.contextEntries.length;
            while (i < length) {
                this.contextEntries[i].resetFactHandle();
                ++i;
            }
        }
    }
}

