/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.common.DroolsObjectInput;
import org.drools.core.util.DroolsClassLoader;
import org.drools.core.util.StringUtils;
import org.drools.rule.ConditionalElement;
import org.drools.rule.DialectRuntimeData;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.DroolsCompositeClassLoader;
import org.drools.rule.EvalCondition;
import org.drools.rule.Function;
import org.drools.rule.GroupElement;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.spi.Wireable;

public class JavaDialectRuntimeData
implements DialectRuntimeData,
Externalizable {
    private static final long serialVersionUID = 400L;
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JavaDialectRuntimeData.class.getProtectionDomain();
        }
    });
    private Map invokerLookups;
    private Map store;
    private DialectRuntimeRegistry registry;
    private transient PackageClassLoader classLoader;
    private transient DroolsCompositeClassLoader rootClassLoader;
    private boolean dirty = false;
    private List<String> wireList = Collections.emptyList();

    public JavaDialectRuntimeData() {
        this.invokerLookups = new HashMap();
        this.store = new HashMap();
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeInt(this.store.size());
        for (Map.Entry entry : this.store.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
        stream.writeInt(this.invokerLookups.size());
        for (Map.Entry entry : this.invokerLookups.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        DroolsObjectInput droolsStream = (DroolsObjectInput)stream;
        int i = 0;
        int length = stream.readInt();
        while (i < length) {
            this.store.put(stream.readObject(), stream.readObject());
            ++i;
        }
        i = 0;
        length = stream.readInt();
        while (i < length) {
            this.invokerLookups.put(stream.readObject(), stream.readObject());
            ++i;
        }
        this.dirty = true;
    }

    public void onAdd(DialectRuntimeRegistry registry, DroolsCompositeClassLoader rootClassLoader) {
        this.registry = registry;
        this.rootClassLoader = rootClassLoader;
        this.classLoader = new PackageClassLoader(this, this.rootClassLoader);
        this.rootClassLoader.addClassLoader(this.classLoader);
    }

    public void onRemove() {
        this.rootClassLoader.removeClassLoader(this.classLoader);
    }

    public void onBeforeExecute() {
        if (this.isDirty()) {
            this.reload();
        } else if (!this.wireList.isEmpty()) {
            try {
                for (String resourceName : this.wireList) {
                    this.wire(JavaDialectRuntimeData.convertResourceToClassName(resourceName));
                }
            }
            catch (Exception e) {
                throw new RuntimeDroolsException("Unable to wire up JavaDialect", e);
            }
        }
        this.wireList.clear();
    }

    public DialectRuntimeData clone(DialectRuntimeRegistry registry, DroolsCompositeClassLoader rootClassLoader) {
        JavaDialectRuntimeData cloneOne = new JavaDialectRuntimeData();
        cloneOne.merge(registry, this);
        cloneOne.onAdd(registry, rootClassLoader);
        return cloneOne;
    }

    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData) {
        this.registry = registry;
        JavaDialectRuntimeData newJavaData = (JavaDialectRuntimeData)newData;
        String[] stringArray = newJavaData.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String resourceName = stringArray[n2];
            this.write(resourceName, newJavaData.read(resourceName));
            ++n2;
        }
        this.putAllInvokers(newJavaData.getInvokers());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected Map getStore() {
        if (this.store == null) {
            this.store = new HashMap();
        }
        return this.store;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void removeRule(Package pkg, Rule rule) {
        String consequenceName = rule.getConsequence().getClass().getName();
        if (this.remove(consequenceName)) {
            this.removeClasses(rule.getLhs());
            String sufix = String.valueOf(StringUtils.ucFirst(rule.getConsequence().getName())) + "ConsequenceInvoker";
            this.remove(consequenceName.substring(0, consequenceName.indexOf(sufix)));
        }
    }

    public void removeFunction(Package pkg, Function function) {
        this.remove(String.valueOf(pkg.getName()) + "." + StringUtils.ucFirst(function.getName()));
    }

    private void removeClasses(ConditionalElement ce) {
        if (ce instanceof GroupElement) {
            GroupElement group = (GroupElement)ce;
            for (Object object : group.getChildren()) {
                if (object instanceof ConditionalElement) {
                    this.removeClasses((ConditionalElement)object);
                    continue;
                }
                if (!(object instanceof Pattern)) continue;
                this.removeClasses((Pattern)object);
            }
        } else if (ce instanceof EvalCondition) {
            this.remove(((EvalCondition)ce).getEvalExpression().getClass().getName());
        }
    }

    private void removeClasses(Pattern pattern) {
        for (Object object : pattern.getConstraints()) {
            if (object instanceof PredicateConstraint) {
                this.remove(((PredicateConstraint)object).getPredicateExpression().getClass().getName());
                continue;
            }
            if (!(object instanceof ReturnValueConstraint)) continue;
            this.remove(((ReturnValueConstraint)object).getExpression().getClass().getName());
        }
    }

    public byte[] read(String resourceName) {
        byte[] bytes = null;
        if (!this.getStore().isEmpty()) {
            bytes = (byte[])this.getStore().get(resourceName);
        }
        return bytes;
    }

    public void write(String resourceName, byte[] clazzData) throws RuntimeDroolsException {
        if (this.getStore().put(resourceName, clazzData) != null) {
            this.dirty = true;
            if (!this.wireList.isEmpty()) {
                this.wireList.clear();
            }
        } else if (!this.dirty) {
            try {
                if (this.wireList == Collections.emptyList()) {
                    this.wireList = new ArrayList<String>();
                }
                this.wireList.add(resourceName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeDroolsException(e);
            }
        }
    }

    public void wire(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object invoker = this.getInvokers().get(className);
        if (invoker != null) {
            this.wire(className, invoker);
        }
    }

    public void wire(String className, Object invoker) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = this.rootClassLoader.loadClass(className);
        if (clazz != null) {
            if (invoker instanceof Wireable) {
                ((Wireable)invoker).wire(clazz.newInstance());
            }
        } else {
            throw new ClassNotFoundException(className);
        }
    }

    public boolean remove(String resourceName) throws RuntimeDroolsException {
        this.getInvokers().remove(resourceName);
        if (this.getStore().remove(JavaDialectRuntimeData.convertClassToResourcePath(resourceName)) != null) {
            this.wireList.remove(resourceName);
            this.dirty = true;
            return true;
        }
        return false;
    }

    public String[] list() {
        String[] names = new String[this.getStore().size()];
        int i = 0;
        for (Object object : this.getStore().keySet()) {
            names[i++] = (String)object;
        }
        return names;
    }

    public void reload() throws RuntimeDroolsException {
        this.rootClassLoader.removeClassLoader(this.classLoader);
        this.classLoader = new PackageClassLoader(this, this.rootClassLoader);
        this.rootClassLoader.addClassLoader(this.classLoader);
        try {
            Iterator iterator = this.getInvokers().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                this.wire((String)entry.getKey(), entry.getValue());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationError e) {
            throw new RuntimeDroolsException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException(e);
        }
        this.dirty = false;
    }

    public void clear() {
        this.getStore().clear();
        this.getInvokers().clear();
        this.reload();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + this.getStore().toString();
    }

    public void putInvoker(String className, Object invoker) {
        this.getInvokers().put(className, invoker);
    }

    public void putAllInvokers(Map invokers) {
        this.getInvokers().putAll(invokers);
    }

    public Map getInvokers() {
        if (this.invokerLookups == null) {
            this.invokerLookups = new HashMap();
        }
        return this.invokerLookups;
    }

    public void removeInvoker(String className) {
        this.getInvokers().remove(className);
    }

    public static String convertResourceToClassName(String pResourceName) {
        return JavaDialectRuntimeData.stripExtension(pResourceName).replace('/', '.');
    }

    public static String convertClassToResourcePath(String pName) {
        return String.valueOf(pName.replace('.', '/')) + ".class";
    }

    public static String stripExtension(String pResourceName) {
        int i = pResourceName.lastIndexOf(46);
        String withoutExtension = pResourceName.substring(0, i);
        return withoutExtension;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackageClassLoader
    extends ClassLoader
    implements DroolsClassLoader {
        private JavaDialectRuntimeData store;
        DroolsCompositeClassLoader rootClassLoader;
        private Map<String, Object> cache = new HashMap<String, Object>();
        private long successfulCalls = 0L;
        private long failedCalls = 0L;
        private long cacheHits = 0L;

        public PackageClassLoader(JavaDialectRuntimeData store, DroolsCompositeClassLoader rootClassLoader) {
            super(rootClassLoader);
            this.rootClassLoader = rootClassLoader;
            this.store = store;
        }

        @Override
        public Class<?> fastFindClass(String name) {
            byte[] clazzBytes;
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null && (clazzBytes = this.store.read(JavaDialectRuntimeData.convertClassToResourcePath(name))) != null) {
                String pkgName = name.substring(0, name.lastIndexOf(46));
                if (this.getPackage(pkgName) == null) {
                    this.definePackage(pkgName, "", "", "", "", "", "", null);
                }
                cls = this.defineClass(name, clazzBytes, 0, clazzBytes.length, PROTECTION_DOMAIN);
            }
            return cls;
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                ClassLoader parent;
                if (this.cache.containsKey(name)) {
                    ++this.cacheHits;
                    Object result = this.cache.get(name);
                    if (result instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)result;
                    }
                    return (Class)result;
                }
                Class<?> cls = this.fastFindClass(name);
                if (cls == null && (parent = this.getParent()) != null) {
                    cls = Class.forName(name, true, parent);
                }
                if (resolve && cls != null) {
                    this.resolveClass(cls);
                }
                if (cls != null) {
                    ++this.successfulCalls;
                } else {
                    ++this.failedCalls;
                }
                this.cache.put(name, cls);
                return cls;
            }
            catch (ClassNotFoundException e) {
                ++this.failedCalls;
                this.cache.put(name, e);
                throw e;
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return this.fastFindClass(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            byte[] clsBytes = this.store.read(name);
            if (clsBytes != null) {
                return new ByteArrayInputStream(clsBytes);
            }
            return null;
        }

        public void reset() {
            this.successfulCalls = 0L;
            this.failedCalls = 0L;
            this.cacheHits = 0L;
            this.cache.clear();
        }

        public void printStats() {
            System.out.println("CacheHits = " + this.cacheHits + "\nSuccessful=" + this.successfulCalls + "\nFailed=" + this.failedCalls + "\n");
        }
    }
}

