/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.WorkingMemoryAction;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.reteoo.RightTuple;
import org.drools.rule.Behavior;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.impl.PointInTimeTrigger;

public class SlidingTimeWindow
implements Externalizable,
Behavior {
    private long size;
    private final BehaviorJob job = new BehaviorJob();

    public SlidingTimeWindow() {
        this(0L);
    }

    public SlidingTimeWindow(long size) {
        this.size = size;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.size);
    }

    public Behavior.BehaviorType getType() {
        return Behavior.BehaviorType.TIME_WINDOW;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Object createContext() {
        return new SlidingTimeWindowContext();
    }

    public boolean assertRightTuple(Object context, RightTuple rightTuple, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        queue.queue.add(rightTuple);
        if (queue.queue.peek() == rightTuple) {
            this.updateNextExpiration(rightTuple, workingMemory, queue);
        }
        return true;
    }

    public void retractRightTuple(Object context, RightTuple rightTuple, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        if (queue.expiringTuple != rightTuple) {
            if (queue.queue.peek() == rightTuple) {
                queue.queue.poll();
                this.updateNextExpiration(queue.queue.peek(), workingMemory, queue);
            } else {
                queue.queue.remove(rightTuple);
            }
        }
    }

    public void expireTuples(Object context, InternalWorkingMemory workingMemory) {
        TimerService clock = workingMemory.getTimerService();
        long currentTime = clock.getCurrentTime();
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        RightTuple tuple = queue.queue.peek();
        while (tuple != null && this.isExpired(currentTime, tuple)) {
            queue.expiringTuple = tuple;
            queue.queue.remove();
            InternalFactHandle handle = tuple.getFactHandle();
            if (handle.isValid()) {
                PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 5, null, null, handle);
                tuple.getRightTupleSink().retractRightTuple(tuple, propagationContext, workingMemory);
            }
            tuple.unlinkFromRightParent();
            queue.expiringTuple = null;
            tuple = queue.queue.peek();
        }
        this.updateNextExpiration(tuple, workingMemory, queue);
    }

    private boolean isExpired(long currentTime, RightTuple rightTuple) {
        return ((EventFactHandle)rightTuple.getFactHandle()).getStartTimestamp() + this.size <= currentTime;
    }

    private void updateNextExpiration(RightTuple rightTuple, InternalWorkingMemory workingMemory, Object context) {
        TimerService clock = workingMemory.getTimerService();
        if (rightTuple != null) {
            long nextTimestamp = ((EventFactHandle)rightTuple.getFactHandle()).getStartTimestamp() + this.size;
            BehaviorJobContext jobctx = new BehaviorJobContext(workingMemory, this, context);
            JobHandle handle = clock.scheduleJob(this.job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
            jobctx.setJobHandle(handle);
        }
    }

    public long getExpirationOffset() {
        return this.size;
    }

    public String toString() {
        return "SlidingTimeWindow( size=" + this.size + " )";
    }

    private static class BehaviorExpireWMAction
    implements WorkingMemoryAction {
        private final Behavior behavior;
        private final Object context;

        public BehaviorExpireWMAction(Behavior behavior, Object context) {
            this.behavior = behavior;
            this.context = context;
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.behavior.expireTuples(this.context, workingMemory);
        }

        public void write(MarshallerWriteContext context) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    private static class BehaviorJob
    implements Job {
        private BehaviorJob() {
        }

        public void execute(JobContext ctx) {
            BehaviorJobContext context = (BehaviorJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction(new BehaviorExpireWMAction(context.behavior, context.behaviorContext));
        }
    }

    private static class BehaviorJobContext
    implements JobContext,
    Externalizable {
        public InternalWorkingMemory workingMemory;
        public Behavior behavior;
        public Object behaviorContext;
        public JobHandle handle;

        public BehaviorJobContext(InternalWorkingMemory workingMemory, Behavior behavior, Object behaviorContext) {
            this.workingMemory = workingMemory;
            this.behavior = behavior;
            this.behaviorContext = behaviorContext;
        }

        public JobHandle getJobHandle() {
            return this.handle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SlidingTimeWindowComparator
    implements Comparator<RightTuple> {
        private SlidingTimeWindowComparator() {
        }

        @Override
        public int compare(RightTuple t1, RightTuple t2) {
            EventFactHandle e1 = (EventFactHandle)t1.getFactHandle();
            EventFactHandle e2 = (EventFactHandle)t2.getFactHandle();
            return e1.getStartTimestamp() < e2.getStartTimestamp() ? -1 : (e1.getStartTimestamp() == e2.getStartTimestamp() ? 0 : 1);
        }
    }

    private static class SlidingTimeWindowContext
    implements Externalizable {
        public PriorityQueue<RightTuple> queue = new PriorityQueue<RightTuple>(16, new SlidingTimeWindowComparator());
        public RightTuple expiringTuple;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.queue = (PriorityQueue)in.readObject();
            this.expiringTuple = (RightTuple)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.queue);
            out.writeObject(this.expiringTuple);
        }
    }
}

