/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.drools.process.core.context.exception.ActionExceptionHandler;
import org.drools.process.core.context.exception.ExceptionHandler;
import org.drools.process.core.context.swimlane.Swimlane;
import org.drools.process.core.context.variable.Variable;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.validation.ProcessValidationError;
import org.drools.ruleflow.core.RuleFlowNodeContainerFactory;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.ruleflow.core.validation.RuleFlowProcessValidator;
import org.drools.workflow.core.impl.DroolsConsequenceAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleFlowProcessFactory
extends RuleFlowNodeContainerFactory {
    public static RuleFlowProcessFactory createProcess(String id) {
        return new RuleFlowProcessFactory(id);
    }

    protected RuleFlowProcessFactory(String id) {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(id);
        this.setNodeContainer(process);
    }

    protected RuleFlowProcess getRuleFlowProcess() {
        return (RuleFlowProcess)this.getNodeContainer();
    }

    public RuleFlowProcessFactory name(String name) {
        this.getRuleFlowProcess().setName(name);
        return this;
    }

    public RuleFlowProcessFactory version(String version) {
        this.getRuleFlowProcess().setVersion(version);
        return this;
    }

    public RuleFlowProcessFactory packageName(String packageName) {
        this.getRuleFlowProcess().setPackageName(packageName);
        return this;
    }

    public RuleFlowProcessFactory imports(String ... imports) {
        this.getRuleFlowProcess().setImports(Arrays.asList(imports));
        return this;
    }

    public RuleFlowProcessFactory functionImports(String ... functionImports) {
        this.getRuleFlowProcess().setFunctionImports(Arrays.asList(functionImports));
        return this;
    }

    public RuleFlowProcessFactory globals(Map<String, String> globals) {
        this.getRuleFlowProcess().setGlobals(globals);
        return this;
    }

    public RuleFlowProcessFactory global(String name, String type) {
        Map<String, String> globals = this.getRuleFlowProcess().getGlobals();
        if (globals == null) {
            globals = new HashMap<String, String>();
            this.getRuleFlowProcess().setGlobals(globals);
        }
        globals.put(name, type);
        return this;
    }

    public RuleFlowProcessFactory variable(String name, DataType type) {
        return this.variable(name, type, null);
    }

    public RuleFlowProcessFactory variable(String name, DataType type, Object value) {
        Variable variable = new Variable();
        variable.setName(name);
        variable.setType(type);
        variable.setValue(value);
        this.getRuleFlowProcess().getVariableScope().getVariables().add(variable);
        return this;
    }

    public RuleFlowProcessFactory swimlane(String name) {
        Swimlane swimlane = new Swimlane();
        swimlane.setName(name);
        this.getRuleFlowProcess().getSwimlaneContext().addSwimlane(swimlane);
        return this;
    }

    public RuleFlowProcessFactory exceptionHandler(String exception, ExceptionHandler exceptionHandler) {
        this.getRuleFlowProcess().getExceptionScope().setExceptionHandler(exception, exceptionHandler);
        return this;
    }

    public RuleFlowProcessFactory exceptionHandler(String exception, String dialect, String action) {
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        exceptionHandler.setAction(new DroolsConsequenceAction(dialect, action));
        return this.exceptionHandler(exception, exceptionHandler);
    }

    public RuleFlowProcessFactory validate() {
        ProcessValidationError[] errors;
        ProcessValidationError[] processValidationErrorArray = errors = RuleFlowProcessValidator.getInstance().validateProcess(this.getRuleFlowProcess());
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessValidationError error = processValidationErrorArray[n2];
            System.err.println(error);
            ++n2;
        }
        if (errors.length > 0) {
            throw new RuntimeException("Process could not be validated !");
        }
        return this;
    }

    @Override
    public RuleFlowNodeContainerFactory done() {
        throw new IllegalArgumentException("Already on the top-level.");
    }

    public RuleFlowProcess getProcess() {
        return this.getRuleFlowProcess();
    }
}

