/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.drools.base.ClassObjectType;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.GlobalExtractor;
import org.drools.spi.InternalReadAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationScopeResolver {
    private static final Stack<RuleConditionElement> EMPTY_STACK = new Stack();
    private Map<String, Class<?>>[] maps;
    private Stack<RuleConditionElement> buildStack;
    private Package pkg;

    public DeclarationScopeResolver(Map<String, Class<?>>[] maps) {
        this(maps, EMPTY_STACK);
    }

    public DeclarationScopeResolver(Map<String, Class<?>>[] maps, Stack<RuleConditionElement> buildStack) {
        this.maps = maps;
        this.buildStack = buildStack == null ? EMPTY_STACK : buildStack;
    }

    public void setPackage(Package pkg) {
        this.pkg = pkg;
    }

    private Declaration getExtendedDeclaration(Rule rule, String identifier) {
        if (rule.getLhs().getInnerDeclarations().containsKey(identifier)) {
            return (Declaration)rule.getLhs().getInnerDeclarations().get(identifier);
        }
        if (rule.getParent() != null) {
            return this.getExtendedDeclaration(rule.getParent(), identifier);
        }
        return null;
    }

    private HashMap<String, Declaration> getAllExtendedDeclaration(Rule rule, HashMap<String, Declaration> dec) {
        dec.putAll(rule.getLhs().getInnerDeclarations());
        if (rule.getParent() != null) {
            return this.getAllExtendedDeclaration(rule.getParent(), dec);
        }
        return dec;
    }

    public Declaration getDeclaration(Rule rule, String identifier) {
        Declaration parentDeclaration;
        int i = this.buildStack.size() - 1;
        while (i >= 0) {
            Declaration declaration = ((RuleConditionElement)this.buildStack.get(i)).getInnerDeclarations().get(identifier);
            if (declaration != null) {
                return declaration;
            }
            --i;
        }
        if (rule != null && rule.getParent() != null && (parentDeclaration = this.getExtendedDeclaration(rule.getParent(), identifier)) != null) {
            return parentDeclaration;
        }
        i = 0;
        int length = this.maps.length;
        while (i < length) {
            if (this.maps[i].containsKey(identifier)) {
                if (this.pkg != null) {
                    Class<?> cls = this.maps[i].get(identifier);
                    ClassObjectType classObjectType = new ClassObjectType(cls);
                    Declaration declaration = null;
                    Pattern dummy = new Pattern(0, classObjectType);
                    GlobalExtractor globalExtractor = new GlobalExtractor(identifier, classObjectType);
                    declaration = new Declaration(identifier, globalExtractor, dummy);
                    this.pkg.getClassFieldAccessorStore().getClassObjectType(classObjectType, dummy);
                    this.pkg.getClassFieldAccessorStore().getClassObjectType(classObjectType, globalExtractor);
                    return declaration;
                }
                throw new UnsupportedOperationException("This shoudln't happen outside of PackageBuilder");
            }
            ++i;
        }
        return null;
    }

    public boolean available(Rule rule, String name) {
        Declaration parentDeclaration;
        int i = this.buildStack.size() - 1;
        while (i >= 0) {
            Declaration declaration = ((RuleConditionElement)this.buildStack.get(i)).getInnerDeclarations().get(name);
            if (declaration != null) {
                return true;
            }
            --i;
        }
        i = 0;
        int length = this.maps.length;
        while (i < length) {
            if (this.maps[i].containsKey(name)) {
                return true;
            }
            ++i;
        }
        return rule != null && rule.getParent() != null && (parentDeclaration = this.getExtendedDeclaration(rule.getParent(), name)) != null;
    }

    public boolean isDuplicated(Rule rule, String name) {
        Declaration parentDeclaration;
        int i = 0;
        int length = this.maps.length;
        while (i < length) {
            if (this.maps[i].containsKey(name)) {
                return true;
            }
            ++i;
        }
        i = this.buildStack.size() - 1;
        while (i >= 0) {
            RuleConditionElement rce = (RuleConditionElement)this.buildStack.get(i);
            Declaration declaration = rce.getInnerDeclarations().get(name);
            if (declaration != null) {
                return !(rce instanceof GroupElement) || !((GroupElement)rce).isOr();
            }
            --i;
        }
        return rule != null && rule.getParent() != null && (parentDeclaration = this.getExtendedDeclaration(rule.getParent(), name)) != null;
    }

    public Map<String, Declaration> getDeclarations(Rule rule) {
        HashMap<String, Declaration> declarations = new HashMap<String, Declaration>();
        int i = 0;
        while (i < this.buildStack.size()) {
            declarations.putAll(((RuleConditionElement)this.buildStack.get(i)).getInnerDeclarations());
            ++i;
        }
        if (rule.getParent() != null) {
            return this.getAllExtendedDeclaration(rule.getParent(), declarations);
        }
        return declarations;
    }

    public Map<String, Class<?>> getDeclarationClasses(Rule rule) {
        Map<String, Declaration> declarations = this.getDeclarations(rule);
        HashMap classes = new HashMap();
        for (Map.Entry<String, Declaration> decl : declarations.entrySet()) {
            InternalReadAccessor ira = decl.getValue().getExtractor();
            if (ira == null) continue;
            classes.put(decl.getKey(), ira.getExtractToClass());
        }
        return classes;
    }

    public Pattern findPatternByIndex(int index) {
        if (!this.buildStack.isEmpty()) {
            return this.findPatternInNestedElements(index, (RuleConditionElement)this.buildStack.get(0));
        }
        return null;
    }

    private Pattern findPatternInNestedElements(int index, RuleConditionElement rce) {
        for (RuleConditionElement element : rce.getNestedElements()) {
            Pattern p;
            if (!(element instanceof Pattern ? (p = (Pattern)element).getIndex() == index : !element.isPatternScopeDelimiter() && (p = this.findPatternInNestedElements(index, element)) != null)) continue;
            return p;
        }
        return null;
    }
}

