/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.drools.runtime.Calendars;
import org.drools.time.Calendar;
import org.drools.time.Trigger;

public class PointInTimeTrigger
implements Trigger {
    private Date timestamp;

    public PointInTimeTrigger() {
    }

    public PointInTimeTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        boolean included = true;
        if (calendars != null && calendarNames != null && calendarNames.length > 0) {
            String[] stringArray = calendarNames;
            int n = calendarNames.length;
            int n2 = 0;
            while (n2 < n) {
                String calName = stringArray[n2];
                Calendar cal = calendars.get(calName);
                if (cal != null && !cal.isTimeIncluded(timestamp)) {
                    included = false;
                    break;
                }
                ++n2;
            }
        }
        if (included) {
            this.timestamp = new Date(timestamp);
        }
    }

    public Date hasNextFireTime() {
        return this.timestamp;
    }

    public Date nextFireTime() {
        Date next = this.timestamp;
        this.timestamp = null;
        return next;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.timestamp = (Date)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.timestamp);
    }
}

