/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.agent.AgentEventListener;
import org.drools.agent.DirectoryScanner;
import org.drools.agent.MockListener;
import org.drools.agent.PackageChangeInfo;
import org.drools.agent.PackageProvider;
import org.drools.agent.RuleBaseAssemblerTest;
import org.drools.rule.Package;

public class DirectoryScannerTest
extends TestCase {
    public void testScan() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        Package p2 = new Package("p2");
        File p1f = new File(dir, "p1.pkg");
        File p2f = new File(dir, "p2.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        DirectoryScanner scan = new DirectoryScanner();
        scan.listener = new MockListener();
        Properties props = new Properties();
        props.setProperty("dir", dir.getPath());
        scan.configure(props);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)new MockListener());
        DirectoryScannerTest.assertEquals((int)2, (int)rb.getPackages().length);
        Package p3 = new Package("p3");
        File p3f = new File(dir, "p3.pkg");
        RuleBaseAssemblerTest.writePackage(p3, p3f);
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)new MockListener());
        DirectoryScannerTest.assertEquals((int)3, (int)rb.getPackages().length);
    }

    public void testScanDRLFileReplace() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        Package p2 = new Package("p2");
        File p1f = new File(dir, "p1.pkg");
        File p2f = new File(dir, "p2.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        DirectoryScanner scan = new DirectoryScanner();
        scan.listener = new MockListener();
        Properties props = new Properties();
        props.setProperty("dir", dir.getPath());
        scan.configure(props);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        PackageChangeInfo info1 = scan.loadPackageChanges();
        DirectoryScannerTest.assertEquals((int)2, (int)info1.getChangedPackages().size());
        DirectoryScannerTest.assertEquals((int)0, (int)info1.getRemovedPackages().size());
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)info1.getChangedPackages(), (Collection)info1.getRemovedPackages(), (AgentEventListener)new MockListener());
        DirectoryScannerTest.assertEquals((int)2, (int)rb.getPackages().length);
        boolean fileDeleted = p2f.delete();
        DirectoryScannerTest.assertTrue((boolean)fileDeleted);
        Package p3 = new Package("p3");
        File p3f = new File(dir, "p3.pkg");
        RuleBaseAssemblerTest.writePackage(p3, p3f);
        PackageChangeInfo info2 = scan.loadPackageChanges();
        DirectoryScannerTest.assertEquals((int)1, (int)info2.getChangedPackages().size());
        DirectoryScannerTest.assertEquals((int)1, (int)info2.getRemovedPackages().size());
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)info2.getChangedPackages(), (Collection)info2.getRemovedPackages(), (AgentEventListener)new MockListener());
        DirectoryScannerTest.assertEquals((int)2, (int)rb.getPackages().length);
    }
}

