/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Serializable;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.event.ObjectInsertedEvent;
import org.drools.event.ObjectRetractedEvent;
import org.drools.event.ObjectUpdatedEvent;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.event.WorkingMemoryEventSupport;

public class WorkingMemoryEventSupportTest
extends TestCase {
    public void testIsSerializable() {
        WorkingMemoryEventSupportTest.assertTrue((boolean)Serializable.class.isAssignableFrom(WorkingMemoryEventSupport.class));
    }

    public void testWorkingMemoryEventListener() {
        RuleBase rb = RuleBaseFactory.newRuleBase();
        StatefulSession wm = rb.newStatefulSession();
        final ArrayList wmList = new ArrayList();
        WorkingMemoryEventListener workingMemoryListener = new WorkingMemoryEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectRetracted(ObjectRetractedEvent event) {
                wmList.add(event);
            }
        };
        wm.addEventListener(workingMemoryListener);
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        ObjectInsertedEvent oae = (ObjectInsertedEvent)wmList.get(0);
        WorkingMemoryEventSupportTest.assertSame((Object)stiltonHandle, (Object)oae.getFactHandle());
        wm.update((org.drools.runtime.rule.FactHandle)stiltonHandle, (Object)stilton);
        ObjectUpdatedEvent ome = (ObjectUpdatedEvent)wmList.get(1);
        WorkingMemoryEventSupportTest.assertSame((Object)stiltonHandle, (Object)ome.getFactHandle());
        wm.retract((org.drools.runtime.rule.FactHandle)stiltonHandle);
        ObjectRetractedEvent ore = (ObjectRetractedEvent)wmList.get(2);
        WorkingMemoryEventSupportTest.assertSame((Object)stiltonHandle, (Object)ore.getFactHandle());
        FactHandle cheddarHandle = wm.insert((Object)cheddar);
        oae = (ObjectInsertedEvent)wmList.get(3);
        WorkingMemoryEventSupportTest.assertSame((Object)cheddarHandle, (Object)oae.getFactHandle());
    }
}

