/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.ComparableEvaluatorsDefinition;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.base.evaluators.MatchesEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.SetEvaluatorsDefinition;
import org.drools.base.evaluators.SoundslikeEvaluatorsDefinition;
import org.drools.common.InternalFactHandle;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.event.rule.ActivationCancelledCause;
import org.drools.event.rule.ActivationCancelledEvent;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.AgendaGroupPoppedEvent;
import org.drools.event.rule.AgendaGroupPushedEvent;
import org.drools.event.rule.BeforeActivationFiredEvent;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.drools.spi.Consequence;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ObjectType;

public class AgendaEventSupportTest
extends TestCase {
    public static EvaluatorRegistry registry = new EvaluatorRegistry();

    public void testAgendaEventListener() throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Package pkg = new Package("org.drools.test");
        Rule rule = new Rule("test1");
        rule.setAgendaGroup("test group");
        ClassObjectType cheeseObjectType = new ClassObjectType(Cheese.class);
        Pattern pattern = new Pattern(0, (ObjectType)cheeseObjectType);
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        pkg.getClassFieldAccessorStore().setEagerWire(true);
        ClassFieldReader extractor = pkg.getClassFieldAccessorStore().getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        FieldValue field = FieldFactory.getFieldValue((Object)"cheddar");
        Evaluator evaluator = registry.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL, null);
        LiteralConstraint constraint = new LiteralConstraint((InternalReadAccessor)extractor, evaluator, field);
        pattern.addConstraint((Constraint)constraint);
        rule.addPattern((RuleConditionElement)pattern);
        rule.setConsequence(new Consequence(){

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return null;
            }
        });
        pkg.addRule(rule);
        ArrayList<KnowledgePackageImp> pkgs = new ArrayList<KnowledgePackageImp>();
        pkgs.add(new KnowledgePackageImp(pkg));
        kbase.addKnowledgePackages(pkgs);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        final ArrayList agendaList = new ArrayList();
        AgendaEventListener agendaEventListener = new AgendaEventListener(){

            public void activationCancelled(ActivationCancelledEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                agendaList.add(event);
            }

            public void activationCreated(ActivationCreatedEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                agendaList.add(event);
            }

            public void afterActivationFired(AfterActivationFiredEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                agendaList.add(event);
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                agendaList.add(event);
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                agendaList.add(event);
            }

            public void beforeActivationFired(BeforeActivationFiredEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                agendaList.add(event);
            }
        };
        ksession.addEventListener(agendaEventListener);
        Cheese cheddar = new Cheese("cheddar", 15);
        FactHandle cheddarHandle = ksession.insert((Object)cheddar);
        AgendaEventSupportTest.assertEquals((int)1, (int)agendaList.size());
        ActivationCreatedEvent createdEvent = (ActivationCreatedEvent)agendaList.get(0);
        AgendaEventSupportTest.assertSame((Object)cheddarHandle, (Object)createdEvent.getActivation().getFactHandles().toArray()[0]);
        ksession.getAgenda().clear();
        ActivationCancelledEvent cancelledEvent = (ActivationCancelledEvent)agendaList.get(1);
        AgendaEventSupportTest.assertEquals((Object)ActivationCancelledCause.CLEAR, (Object)cancelledEvent.getCause());
        agendaList.clear();
        cheddar.setPrice(14);
        ksession.update(cheddarHandle, (Object)cheddar);
        AgendaEventSupportTest.assertEquals((int)1, (int)agendaList.size());
        createdEvent = (ActivationCreatedEvent)agendaList.get(0);
        AgendaEventSupportTest.assertSame((Object)cheddarHandle, (Object)createdEvent.getActivation().getFactHandles().toArray()[0]);
        agendaList.clear();
        cheddar.setPrice(14);
        ksession.update(cheddarHandle, (Object)cheddar);
        AgendaEventSupportTest.assertEquals((int)0, (int)agendaList.size());
        ksession.retract(cheddarHandle);
        AgendaEventSupportTest.assertEquals((int)1, (int)agendaList.size());
        cancelledEvent = (ActivationCancelledEvent)agendaList.get(0);
        AgendaEventSupportTest.assertNull((Object)((InternalFactHandle)cancelledEvent.getActivation().getFactHandles().toArray()[0]).getObject());
        cheddarHandle = ksession.insert((Object)cheddar);
        agendaList.clear();
        ksession.getAgenda().getAgendaGroup("test group").setFocus();
        AgendaEventSupportTest.assertEquals((int)1, (int)agendaList.size());
        AgendaGroupPushedEvent pushedEvent = (AgendaGroupPushedEvent)agendaList.get(0);
        AgendaEventSupportTest.assertEquals((String)"test group", (String)pushedEvent.getAgendaGroup().getName());
        agendaList.clear();
        ksession.fireAllRules();
        AgendaEventSupportTest.assertEquals((int)3, (int)agendaList.size());
        BeforeActivationFiredEvent beforeEvent = (BeforeActivationFiredEvent)agendaList.get(0);
        AgendaEventSupportTest.assertSame((Object)cheddarHandle, (Object)beforeEvent.getActivation().getFactHandles().toArray()[0]);
        AfterActivationFiredEvent afterEvent = (AfterActivationFiredEvent)agendaList.get(1);
        AgendaEventSupportTest.assertSame((Object)cheddarHandle, (Object)afterEvent.getActivation().getFactHandles().toArray()[0]);
        AgendaGroupPoppedEvent poppedEvent = (AgendaGroupPoppedEvent)agendaList.get(2);
        AgendaEventSupportTest.assertEquals((String)"test group", (String)poppedEvent.getAgendaGroup().getName());
    }

    static {
        registry.addEvaluatorDefinition((EvaluatorDefinition)new EqualityEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new ComparableEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new SetEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new MatchesEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new SoundslikeEvaluatorsDefinition());
    }
}

