/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.base.MapGlobalResolver;
import org.drools.common.EqualityKey;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.common.WorkingMemoryAction;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.spi.GlobalResolver;

public class ReteooWorkingMemoryTest
extends TestCase {
    public void testBasicWorkingMemoryActions() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)RuleBaseFactory.newRuleBase().newStatefulSession();
        TruthMaintenanceSystem tms = workingMemory.getTruthMaintenanceSystem();
        String string = "test";
        FactHandle fd = workingMemory.insert((Object)"test");
        ReteooWorkingMemoryTest.assertEquals((int)1, (int)tms.getAssertMap().size());
        EqualityKey key = tms.get((Object)"test");
        ReteooWorkingMemoryTest.assertSame((Object)fd, (Object)key.getFactHandle());
        ReteooWorkingMemoryTest.assertNull((Object)key.getOtherFactHandle());
        workingMemory.update((org.drools.runtime.rule.FactHandle)fd, (Object)"test");
        ReteooWorkingMemoryTest.assertEquals((int)1, (int)tms.getAssertMap().size());
        key = tms.get((Object)"test");
        ReteooWorkingMemoryTest.assertSame((Object)fd, (Object)key.getFactHandle());
        ReteooWorkingMemoryTest.assertNull((Object)key.getOtherFactHandle());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)fd);
        ReteooWorkingMemoryTest.assertEquals((int)0, (int)tms.getAssertMap().size());
        key = tms.get((Object)"test");
        ReteooWorkingMemoryTest.assertNull((Object)key);
        fd = workingMemory.insert((Object)"test");
        ReteooWorkingMemoryTest.assertEquals((int)1, (int)tms.getAssertMap().size());
        ReteooWorkingMemoryTest.assertEquals((int)1, (int)tms.getAssertMap().size());
        key = tms.get((Object)"test");
        ReteooWorkingMemoryTest.assertSame((Object)fd, (Object)key.getFactHandle());
        ReteooWorkingMemoryTest.assertNull((Object)key.getOtherFactHandle());
    }

    public void testId() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ReteooWorkingMemoryTest.assertEquals((int)0, (int)workingMemory.getId());
        workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ReteooWorkingMemoryTest.assertEquals((int)1, (int)workingMemory.getId());
    }

    public void testGlobalResolver() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("global1", "value1");
        map.put("global2", "value2");
        MapGlobalResolver resolver = new MapGlobalResolver(map);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        workingMemory.setGlobalResolver((GlobalResolver)resolver);
        ReteooWorkingMemoryTest.assertEquals((Object)"value1", (Object)workingMemory.getGlobal("global1"));
        ReteooWorkingMemoryTest.assertEquals((Object)"value2", (Object)workingMemory.getGlobal("global2"));
    }

    public void testObjectIterator() {
        Object object;
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        session.insert((Object)new Person("bob", 35));
        session.insert((Object)new Cheese("stilton", 35));
        session.insert((Object)new Cheese("brie", 35));
        session.insert((Object)new Person("steve", 55));
        session.insert((Object)new Person("tom", 100));
        int i = 0;
        Iterator it = session.iterateFactHandles();
        while (it.hasNext()) {
            object = it.next();
            if (i++ <= 5) continue;
            ReteooWorkingMemoryTest.fail((String)"should not iterate for than 3 times");
        }
        i = 0;
        it = session.iterateObjects();
        while (it.hasNext()) {
            object = it.next();
            if (i++ <= 5) continue;
            ReteooWorkingMemoryTest.fail((String)"should not iterate for than 3 times");
        }
    }

    public void testExecuteQueueActions() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory wm = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        ReentrantAction action = new ReentrantAction();
        wm.queueWorkingMemoryAction((WorkingMemoryAction)action);
        wm.executeQueuedActions();
        ReteooWorkingMemoryTest.assertEquals((int)2, (int)action.counter.get());
    }

    private static class FinalAction
    extends ReentrantAction {
        public AtomicInteger counter;

        public FinalAction(AtomicInteger counter) {
            this.counter = counter;
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.counter.incrementAndGet();
            workingMemory.executeQueuedActions();
            workingMemory.executeQueuedActions();
        }
    }

    private static class ReentrantAction
    implements WorkingMemoryAction {
        public AtomicInteger counter = new AtomicInteger(0);

        private ReentrantAction() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void write(MarshallerWriteContext context) throws IOException {
        }

        public void execute(InternalWorkingMemory workingMemory) {
            Assert.assertEquals((int)0, (int)this.counter.get());
            workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new FinalAction(this.counter));
            Assert.assertEquals((int)0, (int)this.counter.get());
            workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new FinalAction(this.counter));
            Assert.assertEquals((int)0, (int)this.counter.get());
            workingMemory.executeQueuedActions();
            Assert.assertEquals((int)0, (int)this.counter.get());
            workingMemory.executeQueuedActions();
            Assert.assertEquals((int)0, (int)this.counter.get());
        }
    }
}

