/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test;

import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import org.drools.reteoo.test.ReteDslTestEngine;
import org.drools.reteoo.test.dsl.NodeTestCase;
import org.drools.reteoo.test.dsl.NodeTestCaseResult;
import org.junit.runner.notification.RunNotifier;

public class ReteDslTestEngineHelper {
    public static void executeDsl(String[] fileNames) {
        InputStream[] inputStreams = new InputStream[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            inputStreams[i] = ReteDslTestEngineHelper.class.getResourceAsStream(fileNames[i]);
            TestCase.assertNotNull((String)fileNames[i], (Object)inputStreams[i]);
        }
        ReteDslTestEngineHelper.executeDsl(fileNames, inputStreams);
    }

    public static void executeDsl(String[] fileNames, InputStream[] inputStreams) {
        InputStream inputStream = inputStreams[0];
        for (int i = 1; i < inputStreams.length; ++i) {
            TestCase.assertNotNull((Object)inputStreams[i]);
            inputStream = new SequenceInputStream(inputStream, inputStreams[i]);
        }
        ReteDslTestEngineHelper.executeDsl(Arrays.toString(fileNames), inputStream);
    }

    public static void executeDsl(String fileName) {
        ReteDslTestEngineHelper.executeDsl(fileName, ReteDslTestEngineHelper.class.getResourceAsStream(fileName));
    }

    public static void executeDsl(String fileName, InputStream inputStream) {
        TestCase.assertNotNull((Object)inputStream);
        try {
            NodeTestCase testCase = ReteDslTestEngine.compile(inputStream);
            ReteDslTestEngine tester = new ReteDslTestEngine();
            NodeTestCaseResult result = tester.run(testCase, (RunNotifier)null);
            if (result.getTotalTests() - result.getSuccesses() > 0) {
                TestCase.fail((String)("Error executing " + fileName + " : \n    " + result));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCase.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }
}

