/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;

public class DeclarationTest
extends TestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    protected void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    public void testDeclaration() throws IntrospectionException {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        Pattern pattern = new Pattern(5, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (InternalReadAccessor)extractor, pattern);
        DeclarationTest.assertEquals((String)"typeOfCheese", (String)declaration.getIdentifier());
        DeclarationTest.assertSame(String.class, (Object)declaration.getExtractor().getExtractToClass());
        DeclarationTest.assertSame((Object)extractor, (Object)declaration.getExtractor());
        DeclarationTest.assertEquals((int)5, (int)declaration.getPattern().getOffset());
    }

    public void testGetFieldValue() throws IntrospectionException {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        Pattern pattern = new Pattern(5, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (InternalReadAccessor)extractor, pattern);
        Cheese cheddar = new Cheese("cheddar", 5);
        DeclarationTest.assertEquals((Object)"cheddar", (Object)declaration.getValue(null, (Object)cheddar));
    }

    public static int getIndex(Class clazz, String name) throws IntrospectionException {
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

